/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.filter;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.filter.Filter;
import com.talpa.camera.cameraview.filter.OneParameterFilter;
import com.talpa.camera.cameraview.filter.TwoParameterFilter;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.opengl.draw.GlDrawable;
import com.talpa.camera.opengl.draw.GlRect;
import com.talpa.camera.opengl.program.GlTextureProgram;

public abstract class BaseFilter
implements Filter {
    private static final String TAG = BaseFilter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected static final String DEFAULT_VERTEX_POSITION_NAME = "aPosition";
    protected static final String DEFAULT_VERTEX_TEXTURE_COORDINATE_NAME = "aTextureCoord";
    protected static final String DEFAULT_VERTEX_MVP_MATRIX_NAME = "uMVPMatrix";
    protected static final String DEFAULT_VERTEX_TRANSFORM_MATRIX_NAME = "uTexMatrix";
    protected static final String DEFAULT_FRAGMENT_TEXTURE_COORDINATE_NAME = "vTextureCoord";
    @VisibleForTesting
    GlTextureProgram program = null;
    private GlDrawable programDrawable = null;
    @VisibleForTesting
    Size size;
    protected String vertexPositionName = "aPosition";
    protected String vertexTextureCoordinateName = "aTextureCoord";
    protected String vertexModelViewProjectionMatrixName = "uMVPMatrix";
    protected String vertexTransformMatrixName = "uTexMatrix";
    protected String fragmentTextureCoordinateName = "vTextureCoord";

    @NonNull
    private static String createDefaultVertexShader(@NonNull String vertexPositionName, @NonNull String vertexTextureCoordinateName, @NonNull String vertexModelViewProjectionMatrixName, @NonNull String vertexTransformMatrixName, @NonNull String fragmentTextureCoordinateName) {
        return "uniform mat4 " + vertexModelViewProjectionMatrixName + ";\nuniform mat4 " + vertexTransformMatrixName + ";\nattribute vec4 " + vertexPositionName + ";\nattribute vec4 " + vertexTextureCoordinateName + ";\nvarying vec2 " + fragmentTextureCoordinateName + ";\nvoid main() {\n    gl_Position = " + vertexModelViewProjectionMatrixName + " * " + vertexPositionName + ";\n    " + fragmentTextureCoordinateName + " = (" + vertexTransformMatrixName + " * " + vertexTextureCoordinateName + ").xy;\n}\n";
    }

    @NonNull
    private static String createDefaultFragmentShader(@NonNull String fragmentTextureCoordinateName) {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 " + fragmentTextureCoordinateName + ";\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, " + fragmentTextureCoordinateName + ");\n}\n";
    }

    @NonNull
    protected String createDefaultVertexShader() {
        return BaseFilter.createDefaultVertexShader(this.vertexPositionName, this.vertexTextureCoordinateName, this.vertexModelViewProjectionMatrixName, this.vertexTransformMatrixName, this.fragmentTextureCoordinateName);
    }

    @NonNull
    protected String createDefaultFragmentShader() {
        return BaseFilter.createDefaultFragmentShader(this.fragmentTextureCoordinateName);
    }

    @Override
    public void onCreate(int programHandle) {
        this.program = new GlTextureProgram(programHandle, this.vertexPositionName, this.vertexModelViewProjectionMatrixName, this.vertexTextureCoordinateName, this.vertexTransformMatrixName);
        this.programDrawable = new GlRect();
    }

    @Override
    public void onDestroy() {
        this.program.release();
        this.program = null;
        this.programDrawable = null;
    }

    @Override
    @NonNull
    public String getVertexShader() {
        return this.createDefaultVertexShader();
    }

    @Override
    public void setSize(int width, int height) {
        this.size = new Size(width, height);
    }

    @Override
    public void draw(long timestampUs, @NonNull float[] transformMatrix) {
        if (this.program == null) {
            LOG.w("Filter.draw() called after destroying the filter. This can happen rarely because of threading.");
        } else {
            this.onPreDraw(timestampUs, transformMatrix);
            this.onDraw(timestampUs);
            this.onPostDraw(timestampUs);
        }
    }

    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        this.program.setTextureTransform(transformMatrix);
        this.program.onPreDraw(this.programDrawable, this.programDrawable.getModelMatrix());
    }

    protected void onDraw(long timestampUs) {
        this.program.onDraw(this.programDrawable);
    }

    protected void onPostDraw(long timestampUs) {
        this.program.onPostDraw(this.programDrawable);
    }

    @Override
    @NonNull
    public final BaseFilter copy() {
        BaseFilter copy = this.onCopy();
        if (this.size != null) {
            copy.setSize(this.size.getWidth(), this.size.getHeight());
        }
        if (this instanceof OneParameterFilter) {
            ((OneParameterFilter)((Object)copy)).setParameter1(((OneParameterFilter)((Object)this)).getParameter1());
        }
        if (this instanceof TwoParameterFilter) {
            ((TwoParameterFilter)((Object)copy)).setParameter2(((TwoParameterFilter)((Object)this)).getParameter2());
        }
        return copy;
    }

    @NonNull
    protected BaseFilter onCopy() {
        try {
            return (BaseFilter)this.getClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Filters should have a public no-arguments constructor.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Filters should have a public no-arguments constructor.", e);
        }
    }
}

