/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.filter.BaseFilter;
import com.talpa.camera.cameraview.filter.OneParameterFilter;
import com.talpa.camera.opengl.core.Egloo;

public class BrightnessFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float brightness;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  gl_FragColor = brightness * color;\n}\n";
    private float brightness = 2.0f;
    private int brightnessLocation = -1;

    public void setBrightness(float brightness) {
        if (brightness < 1.0f) {
            brightness = 1.0f;
        }
        if (brightness > 2.0f) {
            brightness = 2.0f;
        }
        this.brightness = brightness;
    }

    public float getBrightness() {
        return this.brightness;
    }

    @Override
    public void setParameter1(float value) {
        this.setBrightness(value + 1.0f);
    }

    @Override
    public float getParameter1() {
        return this.getBrightness() - 1.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.brightnessLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"brightness");
        Egloo.checkGlProgramLocation(this.brightnessLocation, "brightness");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.brightnessLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        GLES20.glUniform1f((int)this.brightnessLocation, (float)this.brightness);
        Egloo.checkGlError("glUniform1f");
    }
}

