/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.filter.BaseFilter;
import com.talpa.camera.cameraview.filter.OneParameterFilter;
import com.talpa.camera.opengl.core.Egloo;

public class FillLightFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float mult;\nuniform float igamma;\nvarying vec2 vTextureCoord;\nvoid main() {\n  const vec3 color_weights = vec3(0.25, 0.5, 0.25);\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  float lightmask = dot(color.rgb, color_weights);\n  float backmask = (1.0 - lightmask);\n  vec3 ones = vec3(1.0, 1.0, 1.0);\n  vec3 diff = pow(mult * color.rgb, igamma * ones) - color.rgb;\n  diff = min(diff, 1.0);\n  vec3 new_color = min(color.rgb + diff * backmask, 1.0);\n  gl_FragColor = vec4(new_color, color.a);\n}\n";
    private float strength = 0.5f;
    private int multiplierLocation = -1;
    private int gammaLocation = -1;

    public void setStrength(float strength) {
        if (strength < 0.0f) {
            strength = 0.0f;
        }
        if (strength > 1.0f) {
            strength = 1.0f;
        }
        this.strength = strength;
    }

    public float getStrength() {
        return this.strength;
    }

    @Override
    public void setParameter1(float value) {
        this.setStrength(value);
    }

    @Override
    public float getParameter1() {
        return this.getStrength();
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.multiplierLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"mult");
        Egloo.checkGlProgramLocation(this.multiplierLocation, "mult");
        this.gammaLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"igamma");
        Egloo.checkGlProgramLocation(this.gammaLocation, "igamma");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.multiplierLocation = -1;
        this.gammaLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float amount = 1.0f - this.strength;
        float multiplier = 1.0f / (amount * 0.7f + 0.3f);
        GLES20.glUniform1f((int)this.multiplierLocation, (float)multiplier);
        Egloo.checkGlError("glUniform1f");
        float fadeGamma = 0.3f;
        float faded = fadeGamma + (1.0f - fadeGamma) * multiplier;
        float gamma = 1.0f / faded;
        GLES20.glUniform1f((int)this.gammaLocation, (float)gamma);
        Egloo.checkGlError("glUniform1f");
    }
}

