/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.frame;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.camera.cameraview.engine.offset.Angles;
import com.talpa.camera.cameraview.frame.FrameManager;
import com.talpa.camera.cameraview.size.Size;
import java.util.concurrent.LinkedBlockingQueue;

public class ByteBufferFrameManager
extends FrameManager<byte[]> {
    private static final int BUFFER_MODE_DISPATCH = 0;
    private static final int BUFFER_MODE_ENQUEUE = 1;
    private LinkedBlockingQueue<byte[]> mBufferQueue;
    private BufferCallback mBufferCallback;
    private final int mBufferMode;

    public ByteBufferFrameManager(int poolSize, @Nullable BufferCallback callback) {
        super(poolSize, byte[].class);
        if (callback != null) {
            this.mBufferCallback = callback;
            this.mBufferMode = 0;
        } else {
            this.mBufferQueue = new LinkedBlockingQueue(poolSize);
            this.mBufferMode = 1;
        }
    }

    @Override
    public void setUp(int format, @NonNull Size size, @NonNull Angles angles) {
        super.setUp(format, size, angles);
        int bytes = this.getFrameBytes();
        for (int i = 0; i < this.getPoolSize(); ++i) {
            if (this.mBufferMode == 0) {
                this.mBufferCallback.onBufferAvailable(new byte[bytes]);
                continue;
            }
            this.mBufferQueue.offer(new byte[bytes]);
        }
    }

    @Nullable
    public byte[] getBuffer() {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call getBuffer() when not in BUFFER_MODE_ENQUEUE.");
        }
        return this.mBufferQueue.poll();
    }

    public void onBufferUnused(@NonNull byte[] buffer) {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call onBufferUnused() when not in BUFFER_MODE_ENQUEUE.");
        }
        if (this.isSetUp()) {
            this.mBufferQueue.offer(buffer);
        } else {
            LOG.w("onBufferUnused: buffer was returned but we're not set up anymore.");
        }
    }

    @Override
    protected void onFrameDataReleased(@NonNull byte[] data, boolean recycled) {
        if (recycled && data.length == this.getFrameBytes()) {
            if (this.mBufferMode == 0) {
                this.mBufferCallback.onBufferAvailable(data);
            } else {
                this.mBufferQueue.offer(data);
            }
        }
    }

    @Override
    @NonNull
    protected byte[] onCloneFrameData(@NonNull byte[] data) {
        byte[] clone = new byte[data.length];
        System.arraycopy(data, 0, clone, 0, data.length);
        return clone;
    }

    @Override
    public void release() {
        super.release();
        if (this.mBufferMode == 1) {
            this.mBufferQueue.clear();
        }
    }

    public static interface BufferCallback {
        public void onBufferAvailable(@NonNull byte[] var1);
    }
}

