/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.frame;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.frame.FrameManager;
import com.talpa.camera.cameraview.size.Size;

public class Frame {
    private static final String TAG = Frame.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final FrameManager mManager;
    private final Class<?> mDataClass;
    private Object mData = null;
    private long mTime = -1L;
    private long mLastTime = -1L;
    private int mUserRotation = 0;
    private int mViewRotation = 0;
    private Size mSize = null;
    private int mFormat = -1;

    Frame(@NonNull FrameManager manager) {
        this.mManager = manager;
        this.mDataClass = manager.getFrameDataClass();
    }

    void setContent(@NonNull Object data, long time, int userRotation, int viewRotation, @NonNull Size size, int format) {
        this.mData = data;
        this.mTime = time;
        this.mLastTime = time;
        this.mUserRotation = userRotation;
        this.mViewRotation = viewRotation;
        this.mSize = size;
        this.mFormat = format;
    }

    private boolean hasContent() {
        return this.mData != null;
    }

    private void ensureHasContent() {
        if (!this.hasContent()) {
            LOG.e("Frame is dead! time:", this.mTime, "lastTime:", this.mLastTime);
            throw new RuntimeException("You should not access a released frame. If this frame was passed to a FrameProcessor, you can only use its contents synchronously, for the duration of the process() method.");
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Frame && ((Frame)obj).mTime == this.mTime;
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public Frame freeze() {
        this.ensureHasContent();
        Frame other = new Frame(this.mManager);
        Object data = this.mManager.cloneFrameData(this.getData());
        other.setContent(data, this.mTime, this.mUserRotation, this.mViewRotation, this.mSize, this.mFormat);
        return other;
    }

    public void release() {
        if (!this.hasContent()) {
            return;
        }
        LOG.v("Frame with time", this.mTime, "is being released.");
        Object data = this.mData;
        this.mData = null;
        this.mUserRotation = 0;
        this.mViewRotation = 0;
        this.mTime = -1L;
        this.mSize = null;
        this.mFormat = -1;
        this.mManager.onFrameReleased(this, data);
    }

    @NonNull
    public <T> T getData() {
        this.ensureHasContent();
        return (T)this.mData;
    }

    @NonNull
    public Class<?> getDataClass() {
        return this.mDataClass;
    }

    public long getTime() {
        this.ensureHasContent();
        return this.mTime;
    }

    @Deprecated
    public int getRotation() {
        return this.getRotationToUser();
    }

    public int getRotationToUser() {
        this.ensureHasContent();
        return this.mUserRotation;
    }

    public int getRotationToView() {
        this.ensureHasContent();
        return this.mViewRotation;
    }

    @NonNull
    public Size getSize() {
        this.ensureHasContent();
        return this.mSize;
    }

    public int getFormat() {
        this.ensureHasContent();
        return this.mFormat;
    }
}

