/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.frame;

import android.graphics.ImageFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.engine.offset.Angles;
import com.talpa.camera.cameraview.engine.offset.Axis;
import com.talpa.camera.cameraview.engine.offset.Reference;
import com.talpa.camera.cameraview.frame.Frame;
import com.talpa.camera.cameraview.size.Size;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class FrameManager<T> {
    private static final String TAG = FrameManager.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    private final int mPoolSize;
    private int mFrameBytes = -1;
    private Size mFrameSize = null;
    private int mFrameFormat = -1;
    private final Class<T> mFrameDataClass;
    private LinkedBlockingQueue<Frame> mFrameQueue;
    private Angles mAngles;

    protected FrameManager(int poolSize, @NonNull Class<T> dataClass) {
        this.mPoolSize = poolSize;
        this.mFrameDataClass = dataClass;
        this.mFrameQueue = new LinkedBlockingQueue(this.mPoolSize);
    }

    public final int getPoolSize() {
        return this.mPoolSize;
    }

    public final int getFrameBytes() {
        return this.mFrameBytes;
    }

    public final Class<T> getFrameDataClass() {
        return this.mFrameDataClass;
    }

    public void setUp(int format, @NonNull Size size, @NonNull Angles angles) {
        if (this.isSetUp()) {
            // empty if block
        }
        this.mFrameSize = size;
        this.mFrameFormat = format;
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)format);
        long sizeInBits = size.getHeight() * size.getWidth() * bitsPerPixel;
        this.mFrameBytes = (int)Math.ceil((double)sizeInBits / 8.0);
        for (int i = 0; i < this.getPoolSize(); ++i) {
            this.mFrameQueue.offer(new Frame(this));
        }
        this.mAngles = angles;
    }

    protected boolean isSetUp() {
        return this.mFrameSize != null;
    }

    @Nullable
    public Frame getFrame(@NonNull T data, long time) {
        if (!this.isSetUp()) {
            throw new IllegalStateException("Can't call getFrame() after releasing or before setUp.");
        }
        Frame frame = this.mFrameQueue.poll();
        if (frame != null) {
            LOG.v("getFrame for time:", time, "RECYCLING.");
            int userRotation = this.mAngles.offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
            int viewRotation = this.mAngles.offset(Reference.SENSOR, Reference.VIEW, Axis.RELATIVE_TO_SENSOR);
            frame.setContent(data, time, userRotation, viewRotation, this.mFrameSize, this.mFrameFormat);
            return frame;
        }
        LOG.i("getFrame for time:", time, "NOT AVAILABLE.");
        this.onFrameDataReleased(data, false);
        return null;
    }

    void onFrameReleased(@NonNull Frame frame, @NonNull T data) {
        if (!this.isSetUp()) {
            return;
        }
        boolean recycled = this.mFrameQueue.offer(frame);
        this.onFrameDataReleased(data, recycled);
    }

    protected abstract void onFrameDataReleased(@NonNull T var1, boolean var2);

    @NonNull
    final T cloneFrameData(@NonNull T data) {
        return this.onCloneFrameData(data);
    }

    @NonNull
    protected abstract T onCloneFrameData(@NonNull T var1);

    public void release() {
        if (!this.isSetUp()) {
            LOG.w("release called twice. Ignoring.");
            return;
        }
        LOG.i("release: Clearing the frame and buffer queue.");
        this.mFrameQueue.clear();
        this.mFrameBytes = -1;
        this.mFrameSize = null;
        this.mFrameFormat = -1;
        this.mAngles = null;
    }
}

