/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.talpa.camera.cameraview.gesture.Gesture;

public abstract class GestureFinder {
    private static final int GRANULARITY = 50;
    private boolean mActive;
    @VisibleForTesting
    Gesture mType;
    private PointF[] mPoints;
    private Controller mController;

    GestureFinder(@NonNull Controller controller, int points) {
        this.mController = controller;
        this.mPoints = new PointF[points];
        for (int i = 0; i < points; ++i) {
            this.mPoints[i] = new PointF(0.0f, 0.0f);
        }
    }

    public void setActive(boolean active) {
        this.mActive = active;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public final boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.mActive) {
            return false;
        }
        return this.handleTouchEvent(event);
    }

    protected abstract boolean handleTouchEvent(@NonNull MotionEvent var1);

    @NonNull
    public final Gesture getGesture() {
        return this.mType;
    }

    protected final void setGesture(Gesture gesture) {
        this.mType = gesture;
    }

    @NonNull
    public final PointF[] getPoints() {
        return this.mPoints;
    }

    @NonNull
    protected final PointF getPoint(int which) {
        return this.mPoints[which];
    }

    public final float computeValue(float currValue, float minValue, float maxValue) {
        return GestureFinder.capValue(currValue, this.getValue(currValue, minValue, maxValue), minValue, maxValue);
    }

    protected abstract float getValue(float var1, float var2, float var3);

    private static float capValue(float oldValue, float newValue, float minValue, float maxValue) {
        float distance;
        float half;
        if (newValue < minValue) {
            newValue = minValue;
        }
        if (newValue > maxValue) {
            newValue = maxValue;
        }
        if (newValue >= oldValue - (half = (distance = (maxValue - minValue) / 50.0f) / 2.0f) && newValue <= oldValue + half) {
            return oldValue;
        }
        return newValue;
    }

    @NonNull
    protected Controller getController() {
        return this.mController;
    }

    public static interface Controller {
        @NonNull
        public Context getContext();

        public int getWidth();

        public int getHeight();
    }
}

