/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.gesture;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.gesture.Gesture;
import com.talpa.camera.cameraview.gesture.GestureFinder;

public class ScrollGestureFinder
extends GestureFinder {
    private static final String TAG = ScrollGestureFinder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private GestureDetector mDetector;
    private boolean mNotify;
    private float mFactor;

    public ScrollGestureFinder(final @NonNull GestureFinder.Controller controller) {
        super(controller, 2);
        this.mDetector = new GestureDetector(controller.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                boolean horizontal;
                LOG.i("onScroll:", "distanceX=" + distanceX, "distanceY=" + distanceY);
                if (e1 == null || e2 == null) {
                    return false;
                }
                if (e1.getX() != ScrollGestureFinder.this.getPoint((int)0).x || e1.getY() != ScrollGestureFinder.this.getPoint((int)0).y) {
                    horizontal = Math.abs(distanceX) >= Math.abs(distanceY);
                    ScrollGestureFinder.this.setGesture(horizontal ? Gesture.SCROLL_HORIZONTAL : Gesture.SCROLL_VERTICAL);
                    ScrollGestureFinder.this.getPoint(0).set(e1.getX(), e1.getY());
                } else {
                    horizontal = ScrollGestureFinder.this.getGesture() == Gesture.SCROLL_HORIZONTAL;
                }
                ScrollGestureFinder.this.getPoint(1).set(e2.getX(), e2.getY());
                ScrollGestureFinder.this.mFactor = horizontal ? distanceX / (float)controller.getWidth() : distanceY / (float)controller.getHeight();
                ScrollGestureFinder.this.mFactor = horizontal ? -ScrollGestureFinder.this.mFactor : ScrollGestureFinder.this.mFactor;
                ScrollGestureFinder.this.mNotify = true;
                return true;
            }
        });
        this.mDetector.setIsLongpressEnabled(false);
    }

    @Override
    protected boolean handleTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            LOG.i("Notifying a gesture of type", this.getGesture().name());
        }
        return this.mNotify;
    }

    @Override
    public float getValue(float currValue, float minValue, float maxValue) {
        float delta = this.getFactor();
        delta *= maxValue - minValue;
        return currValue + (delta *= 2.0f);
    }

    protected float getFactor() {
        return this.mFactor;
    }
}

