/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.gesture;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.gesture.Gesture;
import com.talpa.camera.cameraview.gesture.GestureFinder;

public class TapGestureFinder
extends GestureFinder {
    private GestureDetector mDetector;
    private boolean mNotify;

    public TapGestureFinder(@NonNull GestureFinder.Controller controller) {
        super(controller, 1);
        this.mDetector = new GestureDetector(controller.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                TapGestureFinder.this.mNotify = true;
                TapGestureFinder.this.setGesture(Gesture.TAP);
                return true;
            }

            public void onLongPress(MotionEvent e) {
                TapGestureFinder.this.mNotify = true;
                TapGestureFinder.this.setGesture(Gesture.LONG_TAP);
            }
        });
        this.mDetector.setIsLongpressEnabled(true);
    }

    @Override
    protected boolean handleTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            this.getPoint((int)0).x = event.getX();
            this.getPoint((int)0).y = event.getY();
            return true;
        }
        return false;
    }

    @Override
    public float getValue(float currValue, float minValue, float maxValue) {
        return 0.0f;
    }
}

