/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.internal;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeviceEncoders {
    private static final String TAG = DeviceEncoders.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    @VisibleForTesting
    static boolean ENABLED = Build.VERSION.SDK_INT >= 21;
    public static final int MODE_RESPECT_ORDER = 0;
    public static final int MODE_PREFER_HARDWARE = 1;
    private final MediaCodecInfo mVideoEncoder;
    private final MediaCodecInfo mAudioEncoder;
    private final MediaCodecInfo.VideoCapabilities mVideoCapabilities;
    private final MediaCodecInfo.AudioCapabilities mAudioCapabilities;

    @SuppressLint(value={"NewApi"})
    public DeviceEncoders(int mode, @NonNull String videoType, @NonNull String audioType, int videoOffset, int audioOffset) {
        if (ENABLED) {
            List<MediaCodecInfo> encoders = this.getDeviceEncoders();
            this.mVideoEncoder = this.findDeviceEncoder(encoders, videoType, mode, videoOffset);
            LOG.i("Enabled. Found video encoder:", this.mVideoEncoder.getName());
            this.mAudioEncoder = this.findDeviceEncoder(encoders, audioType, mode, audioOffset);
            LOG.i("Enabled. Found audio encoder:", this.mAudioEncoder.getName());
            this.mVideoCapabilities = this.mVideoEncoder.getCapabilitiesForType(videoType).getVideoCapabilities();
            this.mAudioCapabilities = this.mAudioEncoder.getCapabilitiesForType(audioType).getAudioCapabilities();
        } else {
            this.mVideoEncoder = null;
            this.mAudioEncoder = null;
            this.mVideoCapabilities = null;
            this.mAudioCapabilities = null;
            LOG.i("Disabled.");
        }
    }

    @NonNull
    @SuppressLint(value={"NewApi"})
    @VisibleForTesting
    List<MediaCodecInfo> getDeviceEncoders() {
        MediaCodecInfo[] array;
        ArrayList<MediaCodecInfo> results = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo info : array = new MediaCodecList(0).getCodecInfos()) {
            if (!info.isEncoder()) continue;
            results.add(info);
        }
        return results;
    }

    @SuppressLint(value={"NewApi"})
    @VisibleForTesting
    boolean isHardwareEncoder(@NonNull String encoder) {
        boolean isSoftwareEncoder = (encoder = encoder.toLowerCase()).startsWith("omx.google.") || encoder.startsWith("c2.android.") || !encoder.startsWith("omx.") && !encoder.startsWith("c2.");
        return !isSoftwareEncoder;
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    @VisibleForTesting
    MediaCodecInfo findDeviceEncoder(@NonNull List<MediaCodecInfo> encoders, @NonNull String mimeType, int mode, int offset) {
        ArrayList<MediaCodecInfo> results = new ArrayList<MediaCodecInfo>();
        block0: for (MediaCodecInfo encoder : encoders) {
            String[] types;
            for (String type : types = encoder.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                results.add(encoder);
                continue block0;
            }
        }
        LOG.i("findDeviceEncoder -", "type:", mimeType, "encoders:", results.size());
        if (mode == 1) {
            Collections.sort(results, new Comparator<MediaCodecInfo>(){

                @Override
                public int compare(MediaCodecInfo o1, MediaCodecInfo o2) {
                    boolean hw1 = DeviceEncoders.this.isHardwareEncoder(o1.getName());
                    boolean hw2 = DeviceEncoders.this.isHardwareEncoder(o2.getName());
                    return Boolean.compare(hw2, hw1);
                }
            });
        }
        if (results.size() < offset + 1) {
            throw new RuntimeException("No encoders for type:" + mimeType);
        }
        return (MediaCodecInfo)results.get(offset);
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public Size getSupportedVideoSize(@NonNull Size size) {
        if (!ENABLED) {
            return size;
        }
        int width = size.getWidth();
        int height = size.getHeight();
        double aspect = (double)width / (double)height;
        LOG.i("getSupportedVideoSize - started. width:", width, "height:", height);
        if ((Integer)this.mVideoCapabilities.getSupportedWidths().getUpper() < width) {
            width = (Integer)this.mVideoCapabilities.getSupportedWidths().getUpper();
            height = (int)Math.round((double)width / aspect);
            LOG.i("getSupportedVideoSize - exceeds maxWidth! width:", width, "height:", height);
        }
        if ((Integer)this.mVideoCapabilities.getSupportedHeights().getUpper() < height) {
            height = (Integer)this.mVideoCapabilities.getSupportedHeights().getUpper();
            width = (int)Math.round(aspect * (double)height);
            LOG.i("getSupportedVideoSize - exceeds maxHeight! width:", width, "height:", height);
        }
        while (width % this.mVideoCapabilities.getWidthAlignment() != 0) {
            --width;
        }
        while (height % this.mVideoCapabilities.getHeightAlignment() != 0) {
            --height;
        }
        LOG.i("getSupportedVideoSize - aligned. width:", width, "height:", height);
        if (!this.mVideoCapabilities.getSupportedWidths().contains((Comparable)Integer.valueOf(width))) {
            throw new VideoException("Width not supported after adjustment. Desired:" + width + " Range:" + this.mVideoCapabilities.getSupportedWidths());
        }
        if (!this.mVideoCapabilities.getSupportedHeights().contains((Comparable)Integer.valueOf(height))) {
            throw new VideoException("Height not supported after adjustment. Desired:" + height + " Range:" + this.mVideoCapabilities.getSupportedHeights());
        }
        try {
            if (!this.mVideoCapabilities.getSupportedHeightsFor(width).contains((Comparable)Integer.valueOf(height))) {
                int candidateWidth = width;
                int minWidth = (Integer)this.mVideoCapabilities.getSupportedWidths().getLower();
                int widthAlignment = this.mVideoCapabilities.getWidthAlignment();
                while (candidateWidth >= minWidth) {
                    candidateWidth -= 32;
                    while (candidateWidth % widthAlignment != 0) {
                        --candidateWidth;
                    }
                    int candidateHeight = (int)Math.round((double)candidateWidth / aspect);
                    if (!this.mVideoCapabilities.getSupportedHeightsFor(candidateWidth).contains((Comparable)Integer.valueOf(candidateHeight))) continue;
                    LOG.w("getSupportedVideoSize - restarting with smaller size.");
                    return this.getSupportedVideoSize(new Size(candidateWidth, candidateHeight));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!this.mVideoCapabilities.isSizeSupported(width, height)) {
            throw new VideoException("Size not supported for unknown reason. Might be an aspect ratio issue. Desired size:" + new Size(width, height));
        }
        return new Size(width, height);
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedVideoBitRate(int bitRate) {
        if (!ENABLED) {
            return bitRate;
        }
        int newBitRate = (Integer)this.mVideoCapabilities.getBitrateRange().clamp((Comparable)Integer.valueOf(bitRate));
        LOG.i("getSupportedVideoBitRate -", "inputRate:", bitRate, "adjustedRate:", newBitRate);
        return newBitRate;
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedVideoFrameRate(@NonNull Size size, int frameRate) {
        if (!ENABLED) {
            return frameRate;
        }
        int newFrameRate = (int)((Double)this.mVideoCapabilities.getSupportedFrameRatesFor(size.getWidth(), size.getHeight()).clamp((Comparable)Double.valueOf(frameRate))).doubleValue();
        LOG.i("getSupportedVideoFrameRate -", "inputRate:", frameRate, "adjustedRate:", newFrameRate);
        return newFrameRate;
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedAudioBitRate(int bitRate) {
        if (!ENABLED) {
            return bitRate;
        }
        int newBitRate = (Integer)this.mAudioCapabilities.getBitrateRange().clamp((Comparable)Integer.valueOf(bitRate));
        LOG.i("getSupportedAudioBitRate -", "inputRate:", bitRate, "adjustedRate:", newBitRate);
        return newBitRate;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public String getVideoEncoder() {
        if (this.mVideoEncoder != null) {
            return this.mVideoEncoder.getName();
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public String getAudioEncoder() {
        if (this.mAudioEncoder != null) {
            return this.mAudioEncoder.getName();
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public void tryConfigureVideo(@NonNull String mimeType, @NonNull Size size, int frameRate, int bitRate) {
        if (this.mVideoEncoder != null) {
            MediaCodec codec = null;
            try {
                MediaFormat format = MediaFormat.createVideoFormat((String)mimeType, (int)size.getWidth(), (int)size.getHeight());
                format.setInteger("color-format", 2130708361);
                format.setInteger("bitrate", bitRate);
                format.setInteger("frame-rate", frameRate);
                format.setInteger("i-frame-interval", 1);
                codec = MediaCodec.createByCodecName((String)this.mVideoEncoder.getName());
                codec.configure(format, null, null, 1);
            }
            catch (Exception e) {
                throw new VideoException("Failed to configure video codec: " + e.getMessage());
            }
            finally {
                if (codec != null) {
                    try {
                        codec.release();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public void tryConfigureAudio(@NonNull String mimeType, int bitRate, int sampleRate, int channels) {
        if (this.mAudioEncoder != null) {
            MediaCodec codec = null;
            try {
                MediaFormat format = MediaFormat.createAudioFormat((String)mimeType, (int)sampleRate, (int)channels);
                int channelMask = channels == 2 ? 12 : 16;
                format.setInteger("channel-mask", channelMask);
                format.setInteger("bitrate", bitRate);
                codec = MediaCodec.createByCodecName((String)this.mAudioEncoder.getName());
                codec.configure(format, null, null, 1);
            }
            catch (Exception e) {
                throw new AudioException("Failed to configure video audio: " + e.getMessage());
            }
            finally {
                if (codec != null) {
                    try {
                        codec.release();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public class AudioException
    extends RuntimeException {
        private AudioException(String message) {
            super(message);
        }
    }

    public class VideoException
    extends RuntimeException {
        private VideoException(String message) {
            super(message);
        }
    }
}

