/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.internal;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.filter.Filter;
import com.talpa.camera.cameraview.filter.NoFilter;
import com.talpa.camera.opengl.core.Egloo;
import com.talpa.camera.opengl.program.GlProgram;
import com.talpa.camera.opengl.texture.GlTexture;

public class GlTextureDrawer {
    private static final String TAG = GlTextureDrawer.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int TEXTURE_TARGET = 36197;
    private static final int TEXTURE_UNIT = 33984;
    private final GlTexture mTexture;
    private float[] mTextureTransform = (float[])Egloo.IDENTITY_MATRIX.clone();
    @NonNull
    private Filter mFilter = new NoFilter();
    private Filter mPendingFilter = null;
    private int mProgramHandle = -1;

    public GlTextureDrawer() {
        this(new GlTexture(33984, 36197));
    }

    public GlTextureDrawer(int textureId) {
        this(new GlTexture(33984, 36197, textureId));
    }

    public GlTextureDrawer(@NonNull GlTexture texture) {
        this.mTexture = texture;
    }

    public void setFilter(@NonNull Filter filter) {
        this.mPendingFilter = filter;
    }

    @NonNull
    public GlTexture getTexture() {
        return this.mTexture;
    }

    @NonNull
    public float[] getTextureTransform() {
        return this.mTextureTransform;
    }

    public void setTextureTransform(@NonNull float[] textureTransform) {
        this.mTextureTransform = textureTransform;
    }

    public void draw(long timestampUs) {
        if (this.mPendingFilter != null) {
            this.release();
            this.mFilter = this.mPendingFilter;
            this.mPendingFilter = null;
        }
        if (this.mProgramHandle == -1) {
            this.mProgramHandle = GlProgram.create(this.mFilter.getVertexShader(), this.mFilter.getFragmentShader());
            this.mFilter.onCreate(this.mProgramHandle);
            Egloo.checkGlError("program creation");
        }
        GLES20.glUseProgram((int)this.mProgramHandle);
        Egloo.checkGlError("glUseProgram(handle)");
        this.mTexture.bind();
        this.mFilter.draw(timestampUs, this.mTextureTransform);
        this.mTexture.unbind();
        GLES20.glUseProgram((int)0);
        Egloo.checkGlError("glUseProgram(0)");
    }

    public void release() {
        if (this.mProgramHandle == -1) {
            return;
        }
        this.mFilter.onDestroy();
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }
}

