/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.markers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.camera.cameraview.markers.Marker;
import java.util.HashMap;

public class MarkerLayout
extends FrameLayout {
    public static final int TYPE_AUTOFOCUS = 1;
    @SuppressLint(value={"UseSparseArrays"})
    private final HashMap<Integer, View> mViews = new HashMap();

    public MarkerLayout(@NonNull Context context) {
        super(context);
    }

    public void onMarker(int type, @Nullable Marker marker) {
        View oldView = this.mViews.get(type);
        if (oldView != null) {
            this.removeView(oldView);
        }
        if (marker == null) {
            return;
        }
        View newView = marker.onAttach(this.getContext(), (ViewGroup)this);
        if (newView != null) {
            this.mViews.put(type, newView);
            this.addView(newView);
        }
    }

    public void onEvent(int type, @NonNull PointF[] points) {
        View view = this.mViews.get(type);
        if (view == null) {
            return;
        }
        view.clearAnimation();
        if (type == 1) {
            PointF point = points[0];
            float x = (int)(point.x - (float)(view.getWidth() / 2));
            float y = (int)(point.y - (float)(view.getHeight() / 2));
            view.setTranslationX(x);
            view.setTranslationY(y);
        }
    }
}

