/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.metering;

import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.metering.MeteringTransform;
import com.talpa.camera.cameraview.size.Size;

class MeteringRegion
implements Comparable<MeteringRegion> {
    static final int MAX_WEIGHT = 1000;
    final RectF mRegion;
    final int mWeight;

    MeteringRegion(@NonNull RectF region, int weight) {
        this.mRegion = region;
        this.mWeight = weight;
    }

    @NonNull
    MeteringRegion transform(@NonNull MeteringTransform transform) {
        RectF result = new RectF(Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f);
        PointF point = new PointF();
        point.set(this.mRegion.left, this.mRegion.top);
        point = transform.transformMeteringPoint(point);
        this.updateRect(result, point);
        point.set(this.mRegion.right, this.mRegion.top);
        point = transform.transformMeteringPoint(point);
        this.updateRect(result, point);
        point.set(this.mRegion.right, this.mRegion.bottom);
        point = transform.transformMeteringPoint(point);
        this.updateRect(result, point);
        point.set(this.mRegion.left, this.mRegion.bottom);
        point = transform.transformMeteringPoint(point);
        this.updateRect(result, point);
        return new MeteringRegion(result, this.mWeight);
    }

    private void updateRect(@NonNull RectF rect, @NonNull PointF point) {
        rect.left = Math.min(rect.left, point.x);
        rect.top = Math.min(rect.top, point.y);
        rect.right = Math.max(rect.right, point.x);
        rect.bottom = Math.max(rect.bottom, point.y);
    }

    @NonNull
    MeteringRegion clip(@NonNull Size bounds) {
        return this.clip(new RectF(0.0f, 0.0f, (float)bounds.getWidth(), (float)bounds.getHeight()));
    }

    @NonNull
    MeteringRegion clip(@NonNull RectF bounds) {
        RectF region = new RectF();
        region.set(Math.max(bounds.left, this.mRegion.left), Math.max(bounds.top, this.mRegion.top), Math.min(bounds.right, this.mRegion.right), Math.min(bounds.bottom, this.mRegion.bottom));
        return new MeteringRegion(region, this.mWeight);
    }

    @Override
    public int compareTo(@NonNull MeteringRegion o) {
        return -Integer.valueOf(this.mWeight).compareTo(o.mWeight);
    }
}

