/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.metering;

import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.talpa.camera.cameraview.metering.MeteringRegion;
import com.talpa.camera.cameraview.metering.MeteringTransform;
import com.talpa.camera.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MeteringRegions {
    private static final float POINT_AREA = 0.05f;
    @VisibleForTesting
    static final float BLUR_FACTOR_WEIGHT = 0.1f;
    private static final float BLUR_FACTOR_SIZE = 1.5f;
    @VisibleForTesting
    final List<MeteringRegion> mRegions;

    private MeteringRegions(@NonNull List<MeteringRegion> regions) {
        this.mRegions = regions;
    }

    @NonNull
    public MeteringRegions transform(@NonNull MeteringTransform transform) {
        ArrayList<MeteringRegion> regions = new ArrayList<MeteringRegion>();
        for (MeteringRegion region : this.mRegions) {
            regions.add(region.transform(transform));
        }
        return new MeteringRegions(regions);
    }

    @NonNull
    public <T> List<T> get(int atMost, @NonNull MeteringTransform<T> transform) {
        ArrayList<T> result = new ArrayList<T>();
        Collections.sort(this.mRegions);
        for (MeteringRegion region : this.mRegions) {
            result.add(transform.transformMeteringRegion(region.mRegion, region.mWeight));
        }
        atMost = Math.min(atMost, result.size());
        return result.subList(0, atMost);
    }

    @NonNull
    public static MeteringRegions fromPoint(@NonNull Size bounds, @NonNull PointF point) {
        return MeteringRegions.fromPoint(bounds, point, 1000);
    }

    @NonNull
    public static MeteringRegions fromPoint(@NonNull Size bounds, @NonNull PointF point, int weight) {
        float width = 0.05f * (float)bounds.getWidth();
        float height = 0.05f * (float)bounds.getHeight();
        RectF rectF = MeteringRegions.expand(point, width, height);
        return MeteringRegions.fromArea(bounds, rectF, weight, true);
    }

    @NonNull
    public static MeteringRegions fromArea(@NonNull Size bounds, @NonNull RectF area) {
        return MeteringRegions.fromArea(bounds, area, 1000);
    }

    @NonNull
    public static MeteringRegions fromArea(@NonNull Size bounds, @NonNull RectF area, int weight) {
        return MeteringRegions.fromArea(bounds, area, weight, false);
    }

    @NonNull
    public static MeteringRegions fromArea(@NonNull Size bounds, @NonNull RectF area, int weight, boolean blur) {
        ArrayList<MeteringRegion> regions = new ArrayList<MeteringRegion>();
        PointF center = new PointF(area.centerX(), area.centerY());
        float width = area.width();
        float height = area.height();
        regions.add(new MeteringRegion(area, weight));
        if (blur) {
            RectF background = MeteringRegions.expand(center, 1.5f * width, 1.5f * height);
            regions.add(new MeteringRegion(background, Math.round(0.1f * (float)weight)));
        }
        ArrayList<MeteringRegion> clipped = new ArrayList<MeteringRegion>();
        for (MeteringRegion region : regions) {
            clipped.add(region.clip(bounds));
        }
        return new MeteringRegions(clipped);
    }

    @NonNull
    private static RectF expand(@NonNull PointF center, float width, float height) {
        return new RectF(center.x - width / 2.0f, center.y - height / 2.0f, center.x + width / 2.0f, center.y + height / 2.0f);
    }
}

