/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.picture;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.talpa.camera.cameraview.PictureResult;
import com.talpa.camera.cameraview.filter.Filter;
import com.talpa.camera.cameraview.internal.CropHelper;
import com.talpa.camera.cameraview.internal.GlTextureDrawer;
import com.talpa.camera.cameraview.internal.WorkerHandler;
import com.talpa.camera.cameraview.overlay.Overlay;
import com.talpa.camera.cameraview.overlay.OverlayDrawer;
import com.talpa.camera.cameraview.picture.PictureRecorder;
import com.talpa.camera.cameraview.picture.SnapshotPictureRecorder;
import com.talpa.camera.cameraview.preview.RendererCameraPreview;
import com.talpa.camera.cameraview.preview.RendererFrameCallback;
import com.talpa.camera.cameraview.preview.RendererThread;
import com.talpa.camera.cameraview.size.AspectRatio;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.opengl.core.EglCore;
import com.talpa.camera.opengl.surface.EglSurface;
import com.talpa.camera.opengl.surface.EglWindowSurface;

public class SnapshotGlPictureRecorder
extends SnapshotPictureRecorder {
    private RendererCameraPreview mPreview;
    private AspectRatio mOutputRatio;
    private Overlay mOverlay;
    private boolean mHasOverlay;
    private OverlayDrawer mOverlayDrawer;
    private GlTextureDrawer mTextureDrawer;

    public SnapshotGlPictureRecorder(@NonNull PictureResult.Stub stub, @Nullable PictureRecorder.PictureResultListener listener, @NonNull RendererCameraPreview preview, @NonNull AspectRatio outputRatio, @Nullable Overlay overlay) {
        super(stub, listener);
        this.mPreview = preview;
        this.mOutputRatio = outputRatio;
        this.mOverlay = overlay;
        this.mHasOverlay = this.mOverlay != null && this.mOverlay.drawsOn(Overlay.Target.PICTURE_SNAPSHOT);
    }

    @Override
    @TargetApi(value=19)
    public void take() {
        this.mPreview.addRendererFrameCallback(new RendererFrameCallback(){

            @Override
            @RendererThread
            public void onRendererTextureCreated(int textureId) {
                SnapshotGlPictureRecorder.this.onRendererTextureCreated(textureId);
            }

            @Override
            @RendererThread
            public void onRendererFilterChanged(@NonNull Filter filter) {
                SnapshotGlPictureRecorder.this.onRendererFilterChanged(filter);
            }

            @Override
            @RendererThread
            public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, int rotation, float scaleX, float scaleY) {
                SnapshotGlPictureRecorder.this.mPreview.removeRendererFrameCallback(this);
                SnapshotGlPictureRecorder.this.onRendererFrame(surfaceTexture, rotation, scaleX, scaleY);
            }
        });
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererTextureCreated(int textureId) {
        this.mTextureDrawer = new GlTextureDrawer(textureId);
        Rect crop = CropHelper.computeCrop(this.mResult.size, this.mOutputRatio);
        this.mResult.size = new Size(crop.width(), crop.height());
        if (this.mHasOverlay) {
            this.mOverlayDrawer = new OverlayDrawer(this.mOverlay, this.mResult.size);
        }
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererFilterChanged(@NonNull Filter filter) {
        if (this.mTextureDrawer != null) {
            this.mTextureDrawer.setFilter(filter.copy());
        }
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererFrame(final @NonNull SurfaceTexture surfaceTexture, final int rotation, final float scaleX, final float scaleY) {
        final EGLContext eglContext = EGL14.eglGetCurrentContext();
        WorkerHandler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SnapshotGlPictureRecorder.this.takeFrame(surfaceTexture, rotation, scaleX, scaleY, eglContext);
                }
                catch (Exception e) {
                    SnapshotPictureRecorder.LOG.e("onRendererFrame fail");
                }
            }
        });
    }

    @WorkerThread
    @TargetApi(value=19)
    protected void takeFrame(@NonNull SurfaceTexture surfaceTexture, int rotation, float scaleX, float scaleY, @NonNull EGLContext eglContext) {
        if (this.mTextureDrawer == null) {
            return;
        }
        int fakeOutputTextureId = 9999;
        SurfaceTexture fakeOutputSurface = new SurfaceTexture(9999);
        fakeOutputSurface.setDefaultBufferSize(this.mResult.size.getWidth(), this.mResult.size.getHeight());
        EglCore core = new EglCore(eglContext, 1);
        EglWindowSurface eglSurface = new EglWindowSurface(core, fakeOutputSurface);
        eglSurface.makeCurrent();
        float[] transform = this.mTextureDrawer.getTextureTransform();
        surfaceTexture.getTransformMatrix(transform);
        float scaleTranslX = (1.0f - scaleX) / 2.0f;
        float scaleTranslY = (1.0f - scaleY) / 2.0f;
        Matrix.translateM((float[])transform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
        Matrix.scaleM((float[])transform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])transform, (int)0, (float)(rotation + this.mResult.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])transform, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        if (this.mHasOverlay) {
            this.mOverlayDrawer.draw(Overlay.Target.PICTURE_SNAPSHOT);
            Matrix.translateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)this.mResult.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            Matrix.translateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        this.mResult.rotation = 0;
        long timestampUs = surfaceTexture.getTimestamp() / 1000L;
        LOG.i("takeFrame:", "timestampUs:", timestampUs);
        this.mTextureDrawer.draw(timestampUs);
        if (this.mHasOverlay) {
            this.mOverlayDrawer.render(timestampUs);
        }
        this.mResult.data = eglSurface.toByteArray(Bitmap.CompressFormat.JPEG);
        ((EglSurface)eglSurface).release();
        this.mTextureDrawer.release();
        fakeOutputSurface.release();
        if (this.mHasOverlay) {
            this.mOverlayDrawer.release();
        }
        core.release();
        this.dispatchResult();
    }

    @Override
    protected void dispatchResult() {
        this.mOutputRatio = null;
        super.dispatchResult();
    }
}

