/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.size;

import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.size.AspectRatio;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.cameraview.size.SizeSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SizeSelectors {
    @NonNull
    public static SizeSelector withFilter(@NonNull Filter filter) {
        return new FilterSelector(filter);
    }

    @NonNull
    public static SizeSelector maxWidth(final int width) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getWidth() <= width;
            }
        });
    }

    @NonNull
    public static SizeSelector minWidth(final int width) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getWidth() >= width;
            }
        });
    }

    @NonNull
    public static SizeSelector maxHeight(final int height) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getHeight() <= height;
            }
        });
    }

    @NonNull
    public static SizeSelector minHeight(final int height) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getHeight() >= height;
            }
        });
    }

    @NonNull
    public static SizeSelector aspectRatio(AspectRatio ratio, final float delta) {
        final float desired = ratio.toFloat();
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                float candidate = AspectRatio.of(size.getWidth(), size.getHeight()).toFloat();
                return candidate >= desired - delta && candidate <= desired + delta;
            }
        });
    }

    @NonNull
    public static SizeSelector biggest() {
        return new SizeSelector(){

            @Override
            @NonNull
            public List<Size> select(@NonNull List<Size> source) {
                Collections.sort(source);
                Collections.reverse(source);
                return source;
            }
        };
    }

    @NonNull
    public static SizeSelector smallest() {
        return new SizeSelector(){

            @Override
            @NonNull
            public List<Size> select(@NonNull List<Size> source) {
                Collections.sort(source);
                return source;
            }
        };
    }

    @NonNull
    public static SizeSelector maxArea(final int area) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getHeight() * size.getWidth() <= area;
            }
        });
    }

    @NonNull
    public static SizeSelector minArea(final int area) {
        return SizeSelectors.withFilter(new Filter(){

            @Override
            public boolean accepts(@NonNull Size size) {
                return size.getHeight() * size.getWidth() >= area;
            }
        });
    }

    @NonNull
    public static SizeSelector and(SizeSelector ... selectors) {
        return new AndSelector(selectors);
    }

    @NonNull
    public static SizeSelector or(SizeSelector ... selectors) {
        return new OrSelector(selectors);
    }

    private static class OrSelector
    implements SizeSelector {
        private SizeSelector[] values;

        private OrSelector(SizeSelector ... values) {
            this.values = values;
        }

        @Override
        @NonNull
        public List<Size> select(@NonNull List<Size> source) {
            SizeSelector selector;
            List<Object> temp = null;
            SizeSelector[] sizeSelectorArray = this.values;
            int n = sizeSelectorArray.length;
            for (int i = 0; i < n && (temp = (selector = sizeSelectorArray[i]).select(source)).isEmpty(); ++i) {
            }
            return temp == null ? new ArrayList() : temp;
        }
    }

    private static class AndSelector
    implements SizeSelector {
        private SizeSelector[] values;

        private AndSelector(SizeSelector ... values) {
            this.values = values;
        }

        @Override
        @NonNull
        public List<Size> select(@NonNull List<Size> source) {
            List<Size> temp = source;
            for (SizeSelector selector : this.values) {
                temp = selector.select(temp);
            }
            return temp;
        }
    }

    private static class FilterSelector
    implements SizeSelector {
        private Filter constraint;

        private FilterSelector(@NonNull Filter constraint) {
            this.constraint = constraint;
        }

        @Override
        @NonNull
        public List<Size> select(@NonNull List<Size> source) {
            ArrayList<Size> sizes = new ArrayList<Size>();
            for (Size size : source) {
                if (!this.constraint.accepts(size)) continue;
                sizes.add(size);
            }
            return sizes;
        }
    }

    public static interface Filter {
        public boolean accepts(@NonNull Size var1);
    }
}

