/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.video;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import com.talpa.camera.cameraview.VideoResult;
import com.talpa.camera.cameraview.engine.Camera1Engine;
import com.talpa.camera.cameraview.internal.CamcorderProfiles;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.cameraview.video.FullVideoRecorder;

public class Full1VideoRecorder
extends FullVideoRecorder {
    private final Camera1Engine mEngine;
    private final Camera mCamera;
    private final int mCameraId;

    public Full1VideoRecorder(@NonNull Camera1Engine engine, @NonNull Camera camera, int cameraId) {
        super(engine);
        this.mCamera = camera;
        this.mEngine = engine;
        this.mCameraId = cameraId;
    }

    @Override
    protected void applyVideoSource(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        mediaRecorder.setCamera(this.mCamera);
        mediaRecorder.setVideoSource(1);
    }

    @Override
    @NonNull
    protected CamcorderProfile getCamcorderProfile(@NonNull VideoResult.Stub stub) {
        Size size = stub.rotation % 180 != 0 ? stub.size.flip() : stub.size;
        return CamcorderProfiles.get(this.mCameraId, size);
    }

    @Override
    protected void onDispatchResult() {
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.mEngine);
        super.onDispatchResult();
    }
}

