/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.video;

import android.hardware.camera2.CaptureRequest;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.camera.cameraview.VideoResult;
import com.talpa.camera.cameraview.engine.Camera2Engine;
import com.talpa.camera.cameraview.engine.action.Action;
import com.talpa.camera.cameraview.engine.action.ActionHolder;
import com.talpa.camera.cameraview.engine.action.BaseAction;
import com.talpa.camera.cameraview.engine.action.CompletionCallback;
import com.talpa.camera.cameraview.internal.CamcorderProfiles;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.cameraview.video.FullVideoRecorder;

@RequiresApi(value=21)
public class Full2VideoRecorder
extends FullVideoRecorder {
    private ActionHolder mHolder;
    private final String mCameraId;
    private Surface mInputSurface;

    public Full2VideoRecorder(@NonNull Camera2Engine engine, @NonNull String cameraId) {
        super(engine);
        this.mHolder = engine;
        this.mCameraId = cameraId;
    }

    @Override
    protected void onStart() {
        BaseAction action = new BaseAction(){

            @Override
            public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
                super.onCaptureStarted(holder, request);
                Object tag = holder.getBuilder(this).build().getTag();
                Object currentTag = request.getTag();
                if (tag == null ? currentTag == null : tag.equals(currentTag)) {
                    this.setState(Integer.MAX_VALUE);
                }
            }
        };
        action.addCallback(new CompletionCallback(){

            @Override
            protected void onActionCompleted(@NonNull Action action) {
                Full2VideoRecorder.super.onStart();
            }
        });
        action.start(this.mHolder);
    }

    @Override
    protected void applyVideoSource(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        mediaRecorder.setVideoSource(2);
    }

    @Override
    @NonNull
    protected CamcorderProfile getCamcorderProfile(@NonNull VideoResult.Stub stub) {
        Size size = stub.rotation % 180 != 0 ? stub.size.flip() : stub.size;
        return CamcorderProfiles.get(this.mCameraId, size);
    }

    @NonNull
    public Surface createInputSurface(@NonNull VideoResult.Stub stub) throws PrepareException {
        if (!this.prepareMediaRecorder(stub)) {
            throw new PrepareException(this.mError);
        }
        this.mInputSurface = this.mMediaRecorder.getSurface();
        return this.mInputSurface;
    }

    @Nullable
    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    public class PrepareException
    extends Exception {
        private PrepareException(Throwable cause) {
            super(cause);
        }
    }
}

