/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.video;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.controls.Audio;
import com.talpa.camera.cameraview.engine.CameraEngine;
import com.talpa.camera.cameraview.filter.Filter;
import com.talpa.camera.cameraview.internal.DeviceEncoders;
import com.talpa.camera.cameraview.overlay.Overlay;
import com.talpa.camera.cameraview.overlay.OverlayDrawer;
import com.talpa.camera.cameraview.preview.RendererCameraPreview;
import com.talpa.camera.cameraview.preview.RendererFrameCallback;
import com.talpa.camera.cameraview.preview.RendererThread;
import com.talpa.camera.cameraview.size.Size;
import com.talpa.camera.cameraview.video.VideoRecorder;
import com.talpa.camera.cameraview.video.encoding.AudioConfig;
import com.talpa.camera.cameraview.video.encoding.AudioMediaEncoder;
import com.talpa.camera.cameraview.video.encoding.EncoderThread;
import com.talpa.camera.cameraview.video.encoding.MediaEncoderEngine;
import com.talpa.camera.cameraview.video.encoding.TextureConfig;
import com.talpa.camera.cameraview.video.encoding.TextureMediaEncoder;

@RequiresApi(api=18)
public class SnapshotVideoRecorder
extends VideoRecorder
implements RendererFrameCallback,
MediaEncoderEngine.Listener {
    private static final String TAG = SnapshotVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int DEFAULT_VIDEO_FRAMERATE = 30;
    private static final int DEFAULT_AUDIO_BITRATE = 64000;
    private static final int STATE_RECORDING = 0;
    private static final int STATE_NOT_RECORDING = 1;
    private MediaEncoderEngine mEncoderEngine;
    private final Object mEncoderEngineLock = new Object();
    private RendererCameraPreview mPreview;
    private int mCurrentState = 1;
    private int mDesiredState = 1;
    private int mTextureId = 0;
    private Overlay mOverlay;
    private OverlayDrawer mOverlayDrawer;
    private boolean mHasOverlay;
    private Filter mCurrentFilter;

    private static int estimateVideoBitRate(@NonNull Size size, int frameRate) {
        return (int)(0.07f * (float)size.getWidth() * (float)size.getHeight() * (float)frameRate);
    }

    public SnapshotVideoRecorder(@NonNull CameraEngine engine, @NonNull RendererCameraPreview preview, @Nullable Overlay overlay) {
        super(engine);
        this.mPreview = preview;
        this.mOverlay = overlay;
        this.mHasOverlay = overlay != null && overlay.drawsOn(Overlay.Target.VIDEO_SNAPSHOT);
    }

    @Override
    protected void onStart() {
        this.mPreview.addRendererFrameCallback(this);
        this.mDesiredState = 0;
        this.dispatchVideoRecordingStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStop(boolean isCameraShutdown) {
        if (isCameraShutdown) {
            LOG.i("Stopping the encoder engine from isCameraShutdown.");
            this.mDesiredState = 1;
            this.mCurrentState = 1;
            Object object = this.mEncoderEngineLock;
            synchronized (object) {
                if (this.mEncoderEngine != null) {
                    this.mEncoderEngine.stop();
                    this.mEncoderEngine = null;
                }
            }
        } else {
            this.mDesiredState = 1;
        }
    }

    @Override
    @RendererThread
    public void onRendererTextureCreated(int textureId) {
        this.mTextureId = textureId;
        if (this.mHasOverlay) {
            this.mOverlayDrawer = new OverlayDrawer(this.mOverlay, this.mResult.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RendererThread
    public void onRendererFilterChanged(@NonNull Filter filter) {
        this.mCurrentFilter = filter.copy();
        this.mCurrentFilter.setSize(this.mResult.size.getWidth(), this.mResult.size.getHeight());
        Object object = this.mEncoderEngineLock;
        synchronized (object) {
            if (this.mEncoderEngine != null) {
                this.mEncoderEngine.notify("filter", this.mCurrentFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RendererThread
    public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, int rotation, float scaleX, float scaleY) {
        Object object;
        if (this.mCurrentState == 1 && this.mDesiredState == 0) {
            LOG.i("Starting the encoder engine.");
            if (this.mResult.videoFrameRate <= 0) {
                this.mResult.videoFrameRate = 30;
            }
            if (this.mResult.videoBitRate <= 0) {
                this.mResult.videoBitRate = SnapshotVideoRecorder.estimateVideoBitRate(this.mResult.size, this.mResult.videoFrameRate);
            }
            if (this.mResult.audioBitRate <= 0) {
                this.mResult.audioBitRate = 64000;
            }
            String videoType = "";
            switch (this.mResult.videoCodec) {
                case H_263: {
                    videoType = "video/3gpp";
                    break;
                }
                case H_264: {
                    videoType = "video/avc";
                    break;
                }
                case DEVICE_DEFAULT: {
                    videoType = "video/avc";
                }
            }
            String audioType = "audio/mp4a-latm";
            TextureConfig videoConfig = new TextureConfig();
            AudioConfig audioConfig = new AudioConfig();
            int audioChannels = 0;
            if (this.mResult.audio == Audio.ON) {
                audioChannels = audioConfig.channels;
            } else if (this.mResult.audio == Audio.MONO) {
                audioChannels = 1;
            } else if (this.mResult.audio == Audio.STEREO) {
                audioChannels = 2;
            }
            boolean hasAudio = audioChannels > 0;
            Size newVideoSize = null;
            int newVideoBitRate = 0;
            int newAudioBitRate = 0;
            int newVideoFrameRate = 0;
            int videoEncoderOffset = 0;
            int audioEncoderOffset = 0;
            boolean encodersFound = false;
            DeviceEncoders deviceEncoders = null;
            while (!encodersFound) {
                LOG.i("Checking DeviceEncoders...", "videoOffset:", videoEncoderOffset, "audioOffset:", audioEncoderOffset);
                try {
                    deviceEncoders = new DeviceEncoders(0, videoType, audioType, videoEncoderOffset, audioEncoderOffset);
                }
                catch (RuntimeException e) {
                    LOG.w("Could not respect encoders parameters.", "Going on again without checking encoders, possibly failing.");
                    newVideoSize = this.mResult.size;
                    newVideoBitRate = this.mResult.videoBitRate;
                    newVideoFrameRate = this.mResult.videoFrameRate;
                    newAudioBitRate = this.mResult.audioBitRate;
                    break;
                }
                deviceEncoders = new DeviceEncoders(1, videoType, audioType, videoEncoderOffset, audioEncoderOffset);
                try {
                    newVideoSize = deviceEncoders.getSupportedVideoSize(this.mResult.size);
                    newVideoBitRate = deviceEncoders.getSupportedVideoBitRate(this.mResult.videoBitRate);
                    newVideoFrameRate = deviceEncoders.getSupportedVideoFrameRate(newVideoSize, this.mResult.videoFrameRate);
                    deviceEncoders.tryConfigureVideo(videoType, newVideoSize, newVideoFrameRate, newVideoBitRate);
                    if (hasAudio) {
                        newAudioBitRate = deviceEncoders.getSupportedAudioBitRate(this.mResult.audioBitRate);
                        deviceEncoders.tryConfigureAudio(audioType, newAudioBitRate, audioConfig.samplingFrequency, audioChannels);
                    }
                    encodersFound = true;
                }
                catch (DeviceEncoders.VideoException videoException) {
                    LOG.i("Got VideoException:", videoException.getMessage());
                    ++videoEncoderOffset;
                }
                catch (DeviceEncoders.AudioException audioException) {
                    LOG.i("Got AudioException:", audioException.getMessage());
                    ++audioEncoderOffset;
                }
            }
            this.mResult.size = newVideoSize;
            this.mResult.videoBitRate = newVideoBitRate;
            this.mResult.audioBitRate = newAudioBitRate;
            this.mResult.videoFrameRate = newVideoFrameRate;
            videoConfig.width = this.mResult.size.getWidth();
            videoConfig.height = this.mResult.size.getHeight();
            videoConfig.bitRate = this.mResult.videoBitRate;
            videoConfig.frameRate = this.mResult.videoFrameRate;
            videoConfig.rotation = rotation + this.mResult.rotation;
            videoConfig.mimeType = videoType;
            videoConfig.encoder = deviceEncoders.getVideoEncoder();
            videoConfig.textureId = this.mTextureId;
            videoConfig.scaleX = scaleX;
            videoConfig.scaleY = scaleY;
            videoConfig.eglContext = EGL14.eglGetCurrentContext();
            if (this.mHasOverlay) {
                videoConfig.overlayTarget = Overlay.Target.VIDEO_SNAPSHOT;
                videoConfig.overlayDrawer = this.mOverlayDrawer;
                videoConfig.overlayRotation = this.mResult.rotation;
            }
            TextureMediaEncoder videoEncoder = new TextureMediaEncoder(videoConfig);
            this.mResult.rotation = 0;
            this.mCurrentFilter.setSize(this.mResult.size.getWidth(), this.mResult.size.getWidth());
            AudioMediaEncoder audioEncoder = null;
            if (hasAudio) {
                audioConfig.bitRate = this.mResult.audioBitRate;
                audioConfig.channels = audioChannels;
                audioConfig.encoder = deviceEncoders.getAudioEncoder();
                audioEncoder = new AudioMediaEncoder(audioConfig);
            }
            Object object2 = this.mEncoderEngineLock;
            synchronized (object2) {
                this.mEncoderEngine = new MediaEncoderEngine(this.mResult.file, videoEncoder, audioEncoder, this.mResult.maxDuration, this.mResult.maxSize, this);
                this.mEncoderEngine.notify("filter", this.mCurrentFilter);
                this.mEncoderEngine.start();
            }
            this.mCurrentState = 0;
        }
        if (this.mCurrentState == 0) {
            LOG.i("scheduling frame.");
            object = this.mEncoderEngineLock;
            synchronized (object) {
                if (this.mEncoderEngine != null) {
                    LOG.i("dispatching frame.");
                    TextureMediaEncoder textureEncoder = (TextureMediaEncoder)this.mEncoderEngine.getVideoEncoder();
                    TextureMediaEncoder.Frame frame = textureEncoder.acquireFrame();
                    frame.timestampNanos = surfaceTexture.getTimestamp();
                    frame.timestampMillis = System.currentTimeMillis();
                    surfaceTexture.getTransformMatrix(frame.transform);
                    this.mEncoderEngine.notify("frame", frame);
                }
            }
        }
        if (this.mCurrentState == 0 && this.mDesiredState == 1) {
            LOG.i("Stopping the encoder engine.");
            this.mCurrentState = 1;
            object = this.mEncoderEngineLock;
            synchronized (object) {
                if (this.mEncoderEngine != null) {
                    this.mEncoderEngine.stop();
                    this.mEncoderEngine = null;
                }
            }
        }
    }

    @Override
    public void onEncodingStart() {
    }

    @Override
    public void onEncodingStop() {
        this.dispatchVideoRecordingEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EncoderThread
    public void onEncodingEnd(int stopReason, @Nullable Exception e) {
        if (e != null) {
            LOG.e("Error onEncodingEnd", e);
            this.mResult = null;
            this.mError = e;
        } else if (stopReason == 1) {
            LOG.i("onEncodingEnd because of max duration.");
            this.mResult.endReason = 2;
        } else if (stopReason == 2) {
            LOG.i("onEncodingEnd because of max size.");
            this.mResult.endReason = 1;
        } else {
            LOG.i("onEncodingEnd because of user.");
        }
        this.mCurrentState = 1;
        this.mDesiredState = 1;
        this.mPreview.removeRendererFrameCallback(this);
        this.mPreview = null;
        if (this.mOverlayDrawer != null) {
            this.mOverlayDrawer.release();
            this.mOverlayDrawer = null;
        }
        Object object = this.mEncoderEngineLock;
        synchronized (object) {
            this.mEncoderEngine = null;
        }
        this.dispatchResult();
    }
}

