/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.edmodo.cropper.cropwindow.handle;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.talpa.camera.edmodo.cropper.cropwindow.edge.Edge;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.CenterHandleHelper;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.CornerHandleHelper;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.HandleHelper;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.HorizontalHandleHelper;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.VerticalHandleHelper;

public enum Handle {
    TOP_LEFT(new CornerHandleHelper(Edge.TOP, Edge.LEFT)),
    TOP_RIGHT(new CornerHandleHelper(Edge.TOP, Edge.RIGHT)),
    BOTTOM_LEFT(new CornerHandleHelper(Edge.BOTTOM, Edge.LEFT)),
    BOTTOM_RIGHT(new CornerHandleHelper(Edge.BOTTOM, Edge.RIGHT)),
    LEFT(new VerticalHandleHelper(Edge.LEFT)),
    TOP(new HorizontalHandleHelper(Edge.TOP)),
    RIGHT(new VerticalHandleHelper(Edge.RIGHT)),
    BOTTOM(new HorizontalHandleHelper(Edge.BOTTOM)),
    CENTER(new CenterHandleHelper());

    private HandleHelper mHelper;

    private Handle(HandleHelper helper) {
        this.mHelper = helper;
    }

    public void updateCropWindow(float x, float y, @NonNull RectF imageRect, float snapRadius) {
        this.mHelper.updateCropWindow(x, y, imageRect, snapRadius);
    }

    public void updateCropWindow(float x, float y, float targetAspectRatio, @NonNull RectF imageRect, float snapRadius) {
        this.mHelper.updateCropWindow(x, y, targetAspectRatio, imageRect, snapRadius);
    }
}

