/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.edmodo.cropper.cropwindow.handle;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.talpa.camera.edmodo.cropper.cropwindow.edge.Edge;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.HandleHelper;
import com.talpa.camera.edmodo.cropper.util.AspectRatioUtil;

class HorizontalHandleHelper
extends HandleHelper {
    private Edge mEdge;

    HorizontalHandleHelper(Edge edge) {
        super(edge, null);
        this.mEdge = edge;
    }

    @Override
    void updateCropWindow(float x, float y, float targetAspectRatio, @NonNull RectF imageRect, float snapRadius) {
        float offset;
        this.mEdge.adjustCoordinate(x, y, imageRect, snapRadius, targetAspectRatio);
        float left = Edge.LEFT.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float targetWidth = AspectRatioUtil.calculateWidth(Edge.getHeight(), targetAspectRatio);
        float difference = targetWidth - Edge.getWidth();
        float halfDifference = difference / 2.0f;
        Edge.LEFT.setCoordinate(left -= halfDifference);
        Edge.RIGHT.setCoordinate(right += halfDifference);
        if (Edge.LEFT.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.LEFT, imageRect, targetAspectRatio)) {
            offset = Edge.LEFT.snapToRect(imageRect);
            Edge.RIGHT.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
        if (Edge.RIGHT.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.RIGHT, imageRect, targetAspectRatio)) {
            offset = Edge.RIGHT.snapToRect(imageRect);
            Edge.LEFT.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
    }
}

