/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.edmodo.cropper.cropwindow.handle;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.talpa.camera.edmodo.cropper.cropwindow.edge.Edge;
import com.talpa.camera.edmodo.cropper.cropwindow.handle.HandleHelper;
import com.talpa.camera.edmodo.cropper.util.AspectRatioUtil;

class VerticalHandleHelper
extends HandleHelper {
    private Edge mEdge;

    VerticalHandleHelper(Edge edge) {
        super(null, edge);
        this.mEdge = edge;
    }

    @Override
    void updateCropWindow(float x, float y, float targetAspectRatio, @NonNull RectF imageRect, float snapRadius) {
        float offset;
        this.mEdge.adjustCoordinate(x, y, imageRect, snapRadius, targetAspectRatio);
        float top = Edge.TOP.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        float targetHeight = AspectRatioUtil.calculateHeight(Edge.getWidth(), targetAspectRatio);
        float difference = targetHeight - Edge.getHeight();
        float halfDifference = difference / 2.0f;
        Edge.TOP.setCoordinate(top -= halfDifference);
        Edge.BOTTOM.setCoordinate(bottom += halfDifference);
        if (Edge.TOP.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.TOP, imageRect, targetAspectRatio)) {
            offset = Edge.TOP.snapToRect(imageRect);
            Edge.BOTTOM.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
        if (Edge.BOTTOM.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.BOTTOM, imageRect, targetAspectRatio)) {
            offset = Edge.BOTTOM.snapToRect(imageRect);
            Edge.TOP.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
    }
}

