/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.edmodo.cropper.util;

import android.graphics.RectF;
import androidx.annotation.NonNull;

public class AspectRatioUtil {
    public static float calculateAspectRatio(float left, float top, float right, float bottom) {
        float width = right - left;
        float height = bottom - top;
        return width / height;
    }

    public static float calculateAspectRatio(@NonNull RectF rect) {
        return rect.width() / rect.height();
    }

    public static float calculateLeft(float top, float right, float bottom, float targetAspectRatio) {
        float height = bottom - top;
        return right - targetAspectRatio * height;
    }

    public static float calculateTop(float left, float right, float bottom, float targetAspectRatio) {
        float width = right - left;
        return bottom - width / targetAspectRatio;
    }

    public static float calculateRight(float left, float top, float bottom, float targetAspectRatio) {
        float height = bottom - top;
        return targetAspectRatio * height + left;
    }

    public static float calculateBottom(float left, float top, float right, float targetAspectRatio) {
        float width = right - left;
        return width / targetAspectRatio + top;
    }

    public static float calculateWidth(float height, float targetAspectRatio) {
        return targetAspectRatio * height;
    }

    public static float calculateHeight(float width, float targetAspectRatio) {
        return width / targetAspectRatio;
    }
}

