/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.opengl.program;

import android.opengl.GLES20;
import com.talpa.camera.opengl.core.Egloo;
import com.talpa.camera.opengl.core.GlBindable;
import com.talpa.camera.opengl.core.GlBindableKt;
import com.talpa.camera.opengl.draw.GlDrawable;
import com.talpa.camera.opengl.program.GlProgramLocation;
import com.talpa.camera.opengl.program.GlShader;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0004J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0004J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/talpa/camera/opengl/program/GlProgram;", "Lcom/talpa/camera/opengl/core/GlBindable;", "handle", "", "(I)V", "vertexShader", "", "fragmentShader", "(Ljava/lang/String;Ljava/lang/String;)V", "shaders", "", "Lcom/talpa/camera/opengl/program/GlShader;", "([Lcom/talpa/camera/opengl/program/GlShader;)V", "ownsHandle", "", "(IZ[Lcom/talpa/camera/opengl/program/GlShader;)V", "getHandle", "()I", "isReleased", "[Lcom/talpa/camera/opengl/program/GlShader;", "bind", "", "draw", "drawable", "Lcom/talpa/camera/opengl/draw/GlDrawable;", "modelViewProjectionMatrix", "", "getAttribHandle", "Lcom/talpa/camera/opengl/program/GlProgramLocation;", "name", "getUniformHandle", "onDraw", "onPostDraw", "onPreDraw", "release", "unbind", "Companion", "translation_sdkRelease"})
public class GlProgram
implements GlBindable {
    private boolean isReleased;
    private final int handle;
    private final boolean ownsHandle;
    private final GlShader[] shaders;
    @NotNull
    private static final String TAG;
    public static final Companion Companion;

    public void release() {
        if (!this.isReleased) {
            if (this.ownsHandle) {
                GLES20.glDeleteProgram((int)this.handle);
            }
            GlShader[] $this$forEach$iv = this.shaders;
            boolean $i$f$forEach = false;
            GlShader[] glShaderArray = $this$forEach$iv;
            int n = glShaderArray.length;
            for (int i = 0; i < n; ++i) {
                GlShader element$iv;
                GlShader it = element$iv = glShaderArray[i];
                boolean bl = false;
                it.release();
            }
            this.isReleased = true;
        }
    }

    @Override
    public void bind() {
        GLES20.glUseProgram((int)this.handle);
        Egloo.checkGlError("glUseProgram");
    }

    @Override
    public void unbind() {
        GLES20.glUseProgram((int)0);
    }

    @JvmOverloads
    public final void draw(@NotNull GlDrawable drawable, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
        Egloo.checkGlError("draw start");
        GlBindableKt.use(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, drawable, modelViewProjectionMatrix){
            final /* synthetic */ GlProgram this$0;
            final /* synthetic */ GlDrawable $drawable;
            final /* synthetic */ float[] $modelViewProjectionMatrix;

            public final void invoke() {
                this.this$0.onPreDraw(this.$drawable, this.$modelViewProjectionMatrix);
                this.this$0.onDraw(this.$drawable);
                this.this$0.onPostDraw(this.$drawable);
            }
            {
                this.this$0 = glProgram;
                this.$drawable = glDrawable;
                this.$modelViewProjectionMatrix = fArray;
                super(0);
            }
        }));
        Egloo.checkGlError("draw end");
    }

    public static /* synthetic */ void draw$default(GlProgram glProgram, GlDrawable glDrawable, float[] fArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n & 2) != 0) {
            fArray = glDrawable.getModelMatrix();
        }
        glProgram.draw(glDrawable, fArray);
    }

    @JvmOverloads
    public final void draw(@NotNull GlDrawable drawable) {
        GlProgram.draw$default(this, drawable, null, 2, null);
    }

    public void onPreDraw(@NotNull GlDrawable drawable, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
    }

    public void onDraw(@NotNull GlDrawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        drawable.draw();
    }

    public void onPostDraw(@NotNull GlDrawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
    }

    @NotNull
    protected final GlProgramLocation getAttribHandle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return GlProgramLocation.Companion.getAttrib(this.handle, name);
    }

    @NotNull
    protected final GlProgramLocation getUniformHandle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return GlProgramLocation.Companion.getUniform(this.handle, name);
    }

    public final int getHandle() {
        return this.handle;
    }

    protected GlProgram(int handle, boolean ownsHandle, GlShader ... shaders) {
        Intrinsics.checkParameterIsNotNull((Object)shaders, (String)"shaders");
        this.handle = handle;
        this.ownsHandle = ownsHandle;
        this.shaders = shaders;
    }

    public GlProgram(int handle) {
        this(handle, false, new GlShader[0]);
    }

    public GlProgram(@NotNull String vertexShader, @NotNull String fragmentShader) {
        Intrinsics.checkParameterIsNotNull((Object)vertexShader, (String)"vertexShader");
        Intrinsics.checkParameterIsNotNull((Object)fragmentShader, (String)"fragmentShader");
        this(new GlShader(35633, vertexShader), new GlShader(35632, fragmentShader));
    }

    public GlProgram(GlShader ... shaders) {
        Intrinsics.checkParameterIsNotNull((Object)shaders, (String)"shaders");
        this(Companion.create(Arrays.copyOf(shaders, shaders.length)), true, Arrays.copyOf(shaders, shaders.length));
    }

    static {
        Companion = new Companion(null);
        String string2 = GlProgram.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GlProgram::class.java.simpleName");
        TAG = string2;
    }

    @Deprecated(message="Use create(GlShader) signature.")
    @JvmStatic
    public static final int create(@NotNull String vertexShaderSource, @NotNull String fragmentShaderSource) {
        return Companion.create(vertexShaderSource, fragmentShaderSource);
    }

    @JvmStatic
    public static final int create(GlShader ... shaders) {
        return Companion.create(shaders);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/talpa/camera/opengl/program/GlProgram$Companion;", "", "()V", "TAG", "", "TAG$annotations", "getTAG$translation_sdkRelease", "()Ljava/lang/String;", "create", "", "shaders", "", "Lcom/talpa/camera/opengl/program/GlShader;", "([Lcom/talpa/camera/opengl/program/GlShader;)I", "vertexShaderSource", "fragmentShaderSource", "translation_sdkRelease"})
    public static final class Companion {
        public static /* synthetic */ void TAG$annotations() {
        }

        @NotNull
        public final String getTAG$translation_sdkRelease() {
            return TAG;
        }

        @Deprecated(message="Use create(GlShader) signature.")
        @JvmStatic
        public final int create(@NotNull String vertexShaderSource, @NotNull String fragmentShaderSource) {
            Intrinsics.checkParameterIsNotNull((Object)vertexShaderSource, (String)"vertexShaderSource");
            Intrinsics.checkParameterIsNotNull((Object)fragmentShaderSource, (String)"fragmentShaderSource");
            return this.create(new GlShader(35633, vertexShaderSource), new GlShader(35632, fragmentShaderSource));
        }

        @JvmStatic
        public final int create(GlShader ... shaders) {
            Intrinsics.checkParameterIsNotNull((Object)shaders, (String)"shaders");
            int program = GLES20.glCreateProgram();
            Egloo.checkGlError("glCreateProgram");
            if (program == 0) {
                throw (Throwable)new RuntimeException("Could not create program");
            }
            GlShader[] $this$forEach$iv = shaders;
            boolean $i$f$forEach = false;
            GlShader[] glShaderArray = $this$forEach$iv;
            int n = glShaderArray.length;
            for (int i = 0; i < n; ++i) {
                GlShader element$iv;
                GlShader it = element$iv = glShaderArray[i];
                boolean bl = false;
                GLES20.glAttachShader((int)program, (int)it.getId());
                Egloo.checkGlError("glAttachShader");
            }
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                String message = "Could not link program: " + GLES20.glGetProgramInfoLog((int)program);
                GLES20.glDeleteProgram((int)program);
                throw (Throwable)new RuntimeException(message);
            }
            return program;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

