/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.translate.ocr;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.text.TextPaint;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.AppCompatTextView;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.google.firebase.ml.vision.text.FirebaseVisionText;
import com.google.firebase.ml.vision.text.FirebaseVisionTextRecognizer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.photo.translation.R;
import com.talpa.base.BaseApp;
import com.talpa.base.common.FrameMetadata;
import com.talpa.base.utils.BitmapUtils;
import com.talpa.camera.cameraview.controls.Facing;
import com.talpa.camera.translate.ocr.ImageTranslate;
import com.talpa.camera.translate.ocr.NoContentException;
import com.talpa.camera.translate.trans.HiTranslator;
import com.talpa.tengine.SCTranslatorKt;
import com.talpa.tengine.Trans;
import com.talpa.tengine.lang.LANGKt;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J*\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/talpa/camera/translate/ocr/ImageTranslate;", "", "context", "Landroid/content/Context;", "sourceBitmap", "Landroid/graphics/Bitmap;", "sourceLanguage", "", "targetLanguage", "metadata", "Lcom/talpa/base/common/FrameMetadata;", "(Landroid/content/Context;Landroid/graphics/Bitmap;Ljava/lang/String;Ljava/lang/String;Lcom/talpa/base/common/FrameMetadata;)V", "visionText", "Lcom/google/firebase/ml/vision/text/FirebaseVisionText;", "backgroundColor", "", "bitmap", "block", "Lcom/google/firebase/ml/vision/text/FirebaseVisionText$TextBlock;", "changeLanguage", "Lio/reactivex/Flowable;", "createBlockView", "text", "detectorVisionImage", "visionImage", "Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;", "handleVisionTextToBitmap", "result", "handleVisionTextToBitmapToFlow", "translate", "translateTextOffline", "", "translateTextOnline", "Lcom/talpa/camera/translate/trans/HiTranslator$Result;", "translation_sdkRelease"})
public final class ImageTranslate {
    private FirebaseVisionText visionText;
    private final Context context;
    private Bitmap sourceBitmap;
    private String sourceLanguage;
    private String targetLanguage;
    private FrameMetadata metadata;

    @NotNull
    public final Flowable<Bitmap> translate() {
        FrameMetadata frameMetadata = this.metadata;
        FirebaseVisionImageMetadata firebaseVisionImageMetadata = new FirebaseVisionImageMetadata.Builder().setFormat(17).setWidth(this.sourceBitmap.getWidth()).setHeight(this.sourceBitmap.getHeight()).setRotation(frameMetadata != null ? frameMetadata.getRotation() : 0).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImageMetadata, (String)"FirebaseVisionImageMetad\u2026: 0)\n            .build()");
        FirebaseVisionImageMetadata metadata = firebaseVisionImageMetadata;
        FirebaseVisionImage firebaseVisionImage = FirebaseVisionImage.fromBitmap((Bitmap)BitmapUtils.rotateBitmap(this.sourceBitmap, metadata.getRotation(), Facing.BACK));
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImage, (String)"FirebaseVisionImage.from\u2026a.rotation, Facing.BACK))");
        FirebaseVisionImage visionImage = firebaseVisionImage;
        return this.detectorVisionImage(visionImage);
    }

    private final Flowable<Bitmap> detectorVisionImage(FirebaseVisionImage visionImage) {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(visionImage){
            final /* synthetic */ FirebaseVisionImage $visionImage;

            public final void subscribe(@NotNull FlowableEmitter<FirebaseVisionText> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                FirebaseVision firebaseVision = FirebaseVision.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
                FirebaseVisionTextRecognizer firebaseVisionTextRecognizer = firebaseVision.getOnDeviceTextRecognizer();
                Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionTextRecognizer, (String)"FirebaseVision.getInstan\u2026().onDeviceTextRecognizer");
                FirebaseVisionTextRecognizer detector = firebaseVisionTextRecognizer;
                OnSuccessListener onSuccessListener2 = (OnSuccessListener)new OnSuccessListener<FirebaseVisionText>(emitter){
                    final /* synthetic */ FlowableEmitter $emitter;

                    public final void onSuccess(FirebaseVisionText visionText) {
                        FlowableEmitter flowableEmitter = this.$emitter;
                        Intrinsics.checkExpressionValueIsNotNull((Object)flowableEmitter, (String)"emitter");
                        if (!flowableEmitter.isCancelled()) {
                            FirebaseVisionText firebaseVisionText = visionText;
                            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionText, (String)"visionText");
                            if (firebaseVisionText.getTextBlocks().isEmpty()) {
                                this.$emitter.tryOnError((Throwable)new NoContentException());
                            } else {
                                this.$emitter.onNext((Object)visionText);
                            }
                        }
                    }
                    {
                        this.$emitter = flowableEmitter;
                    }
                };
                detector.processImage(this.$visionImage).addOnSuccessListener(onSuccessListener2).addOnFailureListener(new OnFailureListener(emitter){
                    final /* synthetic */ FlowableEmitter $emitter;

                    public final void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        e.printStackTrace();
                        FlowableEmitter flowableEmitter = this.$emitter;
                        Intrinsics.checkExpressionValueIsNotNull((Object)flowableEmitter, (String)"emitter");
                        if (!flowableEmitter.isCancelled()) {
                            this.$emitter.tryOnError((Throwable)e);
                        }
                    }
                    {
                        this.$emitter = flowableEmitter;
                    }
                });
            }
            {
                this.$visionImage = firebaseVisionImage;
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).observeOn(Schedulers.single()).flatMap(new Function<T, Publisher<? extends R>>(this, visionImage){
            final /* synthetic */ ImageTranslate this$0;
            final /* synthetic */ FirebaseVisionImage $visionImage;

            @NotNull
            public final Flowable<Bitmap> apply(@NotNull FirebaseVisionText visionText) {
                Intrinsics.checkParameterIsNotNull((Object)visionText, (String)"visionText");
                ImageTranslate.access$setVisionText$p(this.this$0, visionText);
                Bitmap bitmap = this.$visionImage.getBitmap();
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"visionImage.bitmap");
                return ImageTranslate.access$handleVisionTextToBitmapToFlow(this.this$0, visionText, bitmap);
            }
            {
                this.this$0 = imageTranslate;
                this.$visionImage = firebaseVisionImage;
            }
        }).subscribeOn(Schedulers.single());
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create<Firebase\u2026beOn(Schedulers.single())");
        return flowable;
    }

    @Nullable
    public final Flowable<Bitmap> changeLanguage(@NotNull String sourceLanguage, @NotNull String targetLanguage) {
        Intrinsics.checkParameterIsNotNull((Object)sourceLanguage, (String)"sourceLanguage");
        Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
        FirebaseVisionText firebaseVisionText = this.visionText;
        if (firebaseVisionText != null) {
            FirebaseVisionText firebaseVisionText2 = firebaseVisionText;
            boolean bl = false;
            boolean bl2 = false;
            FirebaseVisionText it = firebaseVisionText2;
            boolean bl3 = false;
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            Bitmap bitmap = this.sourceBitmap;
            if (bitmap == null) {
                return null;
            }
            return this.handleVisionTextToBitmapToFlow(it, bitmap);
        }
        return null;
    }

    private final String result(FirebaseVisionText result) {
        JsonArray blockJsonArray = new JsonArray();
        String string2 = result.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.text");
        String resultText = string2;
        Iterator iterator = result.getTextBlocks().iterator();
        while (iterator.hasNext()) {
            List blockLanguages;
            String blockText;
            FirebaseVisionText.TextBlock block;
            FirebaseVisionText.TextBlock textBlock = block = (FirebaseVisionText.TextBlock)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)textBlock, (String)"block");
            Intrinsics.checkExpressionValueIsNotNull((Object)textBlock.getText(), (String)"block.text");
            Float blockConfidence = block.getConfidence();
            Intrinsics.checkExpressionValueIsNotNull((Object)block.getRecognizedLanguages(), (String)"block.recognizedLanguages");
            Object[] blockCornerPoints = block.getCornerPoints();
            Rect blockFrame = block.getBoundingBox();
            JsonObject jsonObject = new JsonObject();
            boolean bl = false;
            boolean bl2 = false;
            JsonObject $this$apply = jsonObject;
            boolean bl3 = false;
            $this$apply.addProperty("blockText", blockText);
            $this$apply.addProperty("blockConfidence", (Number)blockConfidence);
            $this$apply.addProperty("blockLanguages", blockLanguages.toString());
            $this$apply.addProperty("blockCornerPoints", String.valueOf(blockCornerPoints != null ? ArraysKt.toList((Object[])blockCornerPoints) : null));
            $this$apply.addProperty("blockFrame", String.valueOf(blockFrame));
            JsonObject blockJson = jsonObject;
            blockJsonArray.add((JsonElement)blockJson);
            JsonArray lineJsonArray = new JsonArray();
            blockJson.add("lines", (JsonElement)lineJsonArray);
            Iterator iterator2 = block.getLines().iterator();
            while (iterator2.hasNext()) {
                List lineLanguages;
                String lineText;
                FirebaseVisionText.Line line;
                FirebaseVisionText.Line line2 = line = (FirebaseVisionText.Line)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)line2, (String)"line");
                Intrinsics.checkExpressionValueIsNotNull((Object)line2.getText(), (String)"line.text");
                Float lineConfidence = line.getConfidence();
                Intrinsics.checkExpressionValueIsNotNull((Object)line.getRecognizedLanguages(), (String)"line.recognizedLanguages");
                Object[] lineCornerPoints = line.getCornerPoints();
                Rect lineFrame = line.getBoundingBox();
                JsonObject jsonObject2 = new JsonObject();
                boolean bl4 = false;
                boolean bl5 = false;
                JsonObject $this$apply2 = jsonObject2;
                boolean bl6 = false;
                $this$apply2.addProperty("lineText", lineText);
                $this$apply2.addProperty("lineConfidence", (Number)lineConfidence);
                $this$apply2.addProperty("lineLanguages", lineLanguages.toString());
                $this$apply2.addProperty("lineCornerPoints", String.valueOf(lineCornerPoints != null ? ArraysKt.toList((Object[])lineCornerPoints) : null));
                $this$apply2.addProperty("lineFrame", String.valueOf(lineFrame));
                JsonObject lineJson = jsonObject2;
                lineJsonArray.add((JsonElement)lineJson);
                JsonArray elementsJsonArray = new JsonArray();
                lineJson.add("elements", (JsonElement)elementsJsonArray);
                Iterator iterator3 = line.getElements().iterator();
                while (iterator3.hasNext()) {
                    List elementLanguages;
                    String elementText;
                    FirebaseVisionText.Element element;
                    FirebaseVisionText.Element element2 = element = (FirebaseVisionText.Element)iterator3.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                    Intrinsics.checkExpressionValueIsNotNull((Object)element2.getText(), (String)"element.text");
                    Float elementConfidence = element.getConfidence();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element.getRecognizedLanguages(), (String)"element.recognizedLanguages");
                    Object[] elementCornerPoints = element.getCornerPoints();
                    Rect elementFrame = element.getBoundingBox();
                    String string3 = "elementText=" + elementText;
                    boolean bl7 = false;
                    System.out.println((Object)string3);
                    JsonObject jsonObject3 = new JsonObject();
                    boolean bl8 = false;
                    boolean bl9 = false;
                    JsonObject $this$apply3 = jsonObject3;
                    boolean bl10 = false;
                    $this$apply3.addProperty("elementText", elementText);
                    $this$apply3.addProperty("elementConfidence", (Number)elementConfidence);
                    $this$apply3.addProperty("elementLanguages", elementLanguages.toString());
                    $this$apply3.addProperty("elementCornerPoints", String.valueOf(elementCornerPoints != null ? ArraysKt.toList((Object[])elementCornerPoints) : null));
                    $this$apply3.addProperty("elementFrame", String.valueOf(elementFrame));
                    JsonObject elementJson = jsonObject3;
                    elementsJsonArray.add((JsonElement)elementJson);
                }
                String string4 = "lineText=" + lineText;
                bl5 = false;
                System.out.println((Object)string4);
            }
            String string5 = "blockText=" + blockText;
            bl2 = false;
            System.out.println((Object)string5);
        }
        String string6 = "resultText=" + resultText;
        boolean bl = false;
        System.out.println((Object)string6);
        String string7 = blockJsonArray.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"blockJsonArray.toString()");
        return string7;
    }

    private final Flowable<Bitmap> handleVisionTextToBitmapToFlow(FirebaseVisionText result, Bitmap bitmap) {
        FlowableOnSubscribe sub2 = (FlowableOnSubscribe)new FlowableOnSubscribe<Bitmap>(this, result, bitmap){
            final /* synthetic */ ImageTranslate this$0;
            final /* synthetic */ FirebaseVisionText $result;
            final /* synthetic */ Bitmap $bitmap;

            public final void subscribe(@NotNull FlowableEmitter<Bitmap> emitter) {
                block3: {
                    Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                    try {
                        Bitmap translationBitmap = ImageTranslate.access$handleVisionTextToBitmap(this.this$0, this.$result, this.$bitmap);
                        if (!emitter.isCancelled()) {
                            FrameMetadata frameMetadata = ImageTranslate.access$getMetadata$p(this.this$0);
                            emitter.onNext((Object)BitmapUtils.reRotateBitmap(translationBitmap, frameMetadata != null ? frameMetadata.getRotation() : 0, Facing.BACK));
                        }
                    }
                    catch (Exception e) {
                        if (emitter.isCancelled()) break block3;
                        emitter.tryOnError((Throwable)e);
                    }
                }
            }
            {
                this.this$0 = imageTranslate;
                this.$result = firebaseVisionText;
                this.$bitmap = bitmap;
            }
        };
        Flowable flowable = Flowable.create((FlowableOnSubscribe)sub2, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create(sub, BackpressureStrategy.BUFFER)");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap handleVisionTextToBitmap(FirebaseVisionText result, Bitmap bitmap) {
        Bitmap newBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(-1);
        TextPaint textPaint = new TextPaint(1);
        boolean bl = false;
        boolean bl2 = false;
        TextPaint it = textPaint;
        boolean bl3 = false;
        Resources resources = BaseApp.INSTANCE.getAppContext().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"BaseApp.appContext.resources");
        it.density = resources.getDisplayMetrics().density;
        TextPaint textPaint2 = textPaint;
        textPaint2.setColor(-16777216);
        textPaint2.setTextAlign(Paint.Align.LEFT);
        List list = result.getTextBlocks();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.textBlocks");
        List blocks = list;
        boolean detectedContent = false;
        Iterable $this$forEachIndexed$iv = blocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Bitmap bit;
            Object translateResult;
            Point[] blockCornerPoints;
            Rect bounding;
            void textBlock;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            FirebaseVisionText.TextBlock textBlock2 = (FirebaseVisionText.TextBlock)item$iv;
            int index = n2;
            boolean bl5 = false;
            void v2 = textBlock;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"textBlock");
            if (v2.getBoundingBox() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)bounding, (String)"textBlock.boundingBox ?: return@forEachIndexed");
            Intrinsics.checkExpressionValueIsNotNull((Object)textBlock.getText(), (String)"textBlock.text");
            if (textBlock.getCornerPoints() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)blockCornerPoints, (String)"textBlock.cornerPoints ?: return@forEachIndexed");
            Point leftTopPoint = blockCornerPoints[0];
            Object translation = null;
            try {
                String blockText;
                translateResult = this.translateTextOnline(blockText);
                HiTranslator.Result result2 = translateResult;
                translateResult = result2 != null ? result2.getTranslation() : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                translateResult = null;
            }
            if ((translation = translateResult) == null) continue;
            detectedContent = true;
            int bg = this.backgroundColor();
            if (this.createBlockView(this.context, (FirebaseVisionText.TextBlock)textBlock, (String)translation, bg) == null) {
                continue;
            }
            canvas.drawBitmap(bit, (float)leftTopPoint.x, (float)leftTopPoint.y, new Paint());
        }
        if (!detectedContent) {
            throw (Throwable)new NoContentException();
        }
        Bitmap bitmap2 = newBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"newBitmap");
        return bitmap2;
    }

    private final HiTranslator.Result translateTextOnline(String text) {
        Trans.Result transResult2;
        HashMap map = LANGKt.languageTagToLangMap();
        String string2 = (String)map.get(this.sourceLanguage);
        if (string2 == null) {
            string2 = "en";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"map[sourceLanguage] ?: \"en\"");
        String source = string2;
        Locale locale = Locale.forLanguageTag(this.targetLanguage);
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.forLanguageTag(targetLanguage)");
        String string3 = (String)map.get(locale.getLanguage());
        if (string3 == null) {
            string3 = "en";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"map[Locale.forLanguageTa\u2026nguage).language] ?: \"en\"");
        String target = string3;
        Trans trans = new Trans(source, target, text);
        Trans.Result result = transResult2 = ((Trans)SCTranslatorKt.translateBySCTranslator((Context)this.context, (Trans)trans, (Function1)translateTextOnline.transResult.1.INSTANCE).blockingSingle()).getResult();
        if (result != null) {
            Trans.Result result2 = result;
            boolean bl = false;
            boolean bl2 = false;
            Trans.Result it = result2;
            boolean bl3 = false;
            HiTranslator.Result result3 = new HiTranslator.Result(this.sourceLanguage, this.targetLanguage, text, it.getTranslation(), it.getCode(), it.getErrorMessage(), false, 64, null);
            return result3;
        }
        Log.d((String)"cjslog", (String)"result null");
        return null;
    }

    private final void translateTextOffline() {
    }

    private final Bitmap createBlockView(Context context, FirebaseVisionText.TextBlock block, String text, int backgroundColor) {
        AppCompatTextView textView;
        Rect rect = block.getBoundingBox();
        if (rect == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"block.boundingBox ?: return null");
        Rect rect2 = rect;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_text, null);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.widget.AppCompatTextView");
        }
        AppCompatTextView appCompatTextView = textView = (AppCompatTextView)view;
        boolean bl = false;
        boolean bl2 = false;
        AppCompatTextView $this$apply = appCompatTextView;
        boolean bl3 = false;
        $this$apply.layout(rect2.left, rect2.top, rect2.right, rect2.bottom);
        textView.setWidth(rect2.width());
        textView.setHeight(rect2.height());
        textView.setLayoutParams(new ViewGroup.LayoutParams(rect2.width(), rect2.height()));
        textView.measure(0, 0);
        textView.setBackgroundColor(backgroundColor);
        textView.setText((CharSequence)text);
        Bitmap bitmap = Bitmap.createBitmap((int)rect2.width(), (int)rect2.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        textView.draw(canvas);
        return bitmap;
    }

    private final int backgroundColor() {
        return -1;
    }

    private final int backgroundColor(Bitmap bitmap, FirebaseVisionText.TextBlock block) {
        Point[] pointArray = block.getCornerPoints();
        if (pointArray == null) {
            return 0;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pointArray, (String)"block.cornerPoints ?: return 0");
        Point[] blockCornerPoints = pointArray;
        float rs_ = 0.0f;
        float gs_ = 0.0f;
        float bs_ = 0.0f;
        float as_ = 0.0f;
        for (Point point : blockCornerPoints) {
            int x;
            int n = point.x >= bitmap.getWidth() ? bitmap.getWidth() - 1 : (x = point.x <= 0 ? 1 : point.x);
            int y = point.y >= bitmap.getHeight() ? bitmap.getHeight() - 1 : (point.y <= 0 ? 1 : point.y);
            Bitmap $this$get$iv = bitmap;
            boolean $i$f$get = false;
            int color2 = $this$get$iv.getPixel(x, y);
            float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
            float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
            float b = (float)(color2 & 0xFF) / 255.0f;
            float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
            rs_ += r;
            gs_ += g;
            bs_ += b;
            as_ += a;
        }
        float red = rs_ / (float)blockCornerPoints.length;
        float green = gs_ / (float)blockCornerPoints.length;
        float blue = bs_ / (float)blockCornerPoints.length;
        float alpha = as_ / (float)blockCornerPoints.length;
        int bg = (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
        return bg;
    }

    public ImageTranslate(@NotNull Context context, @NotNull Bitmap sourceBitmap, @NotNull String sourceLanguage, @NotNull String targetLanguage, @Nullable FrameMetadata metadata) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sourceBitmap, (String)"sourceBitmap");
        Intrinsics.checkParameterIsNotNull((Object)sourceLanguage, (String)"sourceLanguage");
        Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
        this.context = context;
        this.sourceBitmap = sourceBitmap;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.metadata = metadata;
    }

    public static final /* synthetic */ FirebaseVisionText access$getVisionText$p(ImageTranslate $this) {
        return $this.visionText;
    }

    public static final /* synthetic */ void access$setVisionText$p(ImageTranslate $this, FirebaseVisionText firebaseVisionText) {
        $this.visionText = firebaseVisionText;
    }

    public static final /* synthetic */ Flowable access$handleVisionTextToBitmapToFlow(ImageTranslate $this, FirebaseVisionText result, Bitmap bitmap) {
        return $this.handleVisionTextToBitmapToFlow(result, bitmap);
    }

    public static final /* synthetic */ Bitmap access$handleVisionTextToBitmap(ImageTranslate $this, FirebaseVisionText result, Bitmap bitmap) {
        return $this.handleVisionTextToBitmap(result, bitmap);
    }

    public static final /* synthetic */ FrameMetadata access$getMetadata$p(ImageTranslate $this) {
        return $this.metadata;
    }

    public static final /* synthetic */ void access$setMetadata$p(ImageTranslate $this, FrameMetadata frameMetadata) {
        $this.metadata = frameMetadata;
    }
}

