/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.translate.trans;

import android.text.TextUtils;
import androidx.annotation.Keep;
import com.google.android.gms.common.util.Base64Utils;
import com.tencent.mmkv.MMKV;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B)\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000eJ\"\u0010\u0010\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/talpa/camera/translate/trans/HiTranslator;", "", "sourceLanguage", "", "targetLanguage", "text", "key", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "preferKey", "getPreferKey", "()Ljava/lang/String;", "preferKey$delegate", "Lkotlin/Lazy;", "connect", "Lcom/talpa/camera/translate/trans/HiTranslator$Result;", "execute", "generateKey", "parserJson", "json", "readInputStream", "inputStream", "Ljava/io/InputStream;", "readTranslation", "storeTranslation", "", "translation", "writeOutputStream", "outputStream", "Ljava/io/OutputStream;", "zip", "Builder", "Companion", "Result", "translation_sdkRelease"})
@Keep
public final class HiTranslator {
    private final Lazy preferKey$delegate;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final String text;
    private final String key;
    private static final String BASE_URL = "https://api.translasion.com/v1/translate";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 6000;
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/json";
    private static final String PREFER_TRANSLATOR = "prefer_translator_data";
    public static final Companion Companion = new Companion(null);

    private final String getPreferKey() {
        Lazy lazy = this.preferKey$delegate;
        HiTranslator hiTranslator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Result execute() {
        String translation = this.readTranslation(this.getPreferKey());
        if (!TextUtils.isEmpty((CharSequence)translation)) {
            return new Result(this.sourceLanguage, this.targetLanguage, this.text, translation, 1000, null, true, 32, null);
        }
        Result result = this.connect();
        if (!TextUtils.isEmpty((CharSequence)result.getTranslation())) {
            String string2 = this.getPreferKey();
            String string3 = result.getTranslation();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            this.storeTranslation(string2, string3);
        }
        return result;
    }

    private final Result connect() {
        InputStream inputStream;
        OutputStream outputStream;
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(6000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream2 = outputStream = connection.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"outputStream");
        this.writeOutputStream(outputStream2);
        outputStream.close();
        InputStream inputStream2 = inputStream = connection.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        Result result = this.readInputStream(inputStream2);
        inputStream.close();
        connection.disconnect();
        return result;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("text", (Object)this.text);
        jsonObj.put("k", (Object)this.key);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string2 = jsonObj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonObj.toString()");
        String string3 = json = string2;
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream2.write(byArray2);
        outputStream.flush();
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    private final Result parserJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "text";
        int valueCode = 0;
        String valueMessage = null;
        String valueText = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueText = valueResult.getString(keyText);
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.text, valueText, valueCode, valueMessage, false, 64, null);
    }

    private final void storeTranslation(String preferKey2, String translation) {
        MMKV mmkv = MMKV.defaultMMKV();
        mmkv.encode(preferKey2, translation);
    }

    private final String readTranslation(String preferKey2) {
        MMKV mmkv = MMKV.defaultMMKV();
        return mmkv.decodeString(preferKey2, null);
    }

    private final String generateKey(String sourceLanguage, String targetLanguage, String text) {
        String content;
        String string2 = content = sourceLanguage + '-' + targetLanguage + '-' + text;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string4 = Base64Utils.encode((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Base64Utils.encode(content.toByteArray())");
        return string4;
    }

    private final void zip() {
    }

    private HiTranslator(String sourceLanguage, String targetLanguage, String text, String key) {
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.text = text;
        this.key = key;
        this.preferKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HiTranslator this$0;

            @NotNull
            public final String invoke() {
                return HiTranslator.access$generateKey(this.this$0, HiTranslator.access$getSourceLanguage$p(this.this$0), HiTranslator.access$getTargetLanguage$p(this.this$0), HiTranslator.access$getText$p(this.this$0));
            }
            {
                this.this$0 = hiTranslator;
                super(0);
            }
        }));
    }

    public /* synthetic */ HiTranslator(String sourceLanguage, String targetLanguage, String text, String key, DefaultConstructorMarker $constructor_marker) {
        this(sourceLanguage, targetLanguage, text, key);
    }

    public static final /* synthetic */ String access$generateKey(HiTranslator $this, String sourceLanguage, String targetLanguage, String text) {
        return $this.generateKey(sourceLanguage, targetLanguage, text);
    }

    public static final /* synthetic */ String access$getSourceLanguage$p(HiTranslator $this) {
        return $this.sourceLanguage;
    }

    public static final /* synthetic */ String access$getTargetLanguage$p(HiTranslator $this) {
        return $this.targetLanguage;
    }

    public static final /* synthetic */ String access$getText$p(HiTranslator $this) {
        return $this.text;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/talpa/camera/translate/trans/HiTranslator$Builder;", "", "()V", "key", "", "sourceLanguage", "targetLanguage", "text", "build", "Lcom/talpa/camera/translate/trans/HiTranslator;", "setKey", "setSourceLanguage", "setTargetLanguage", "setText", "translation_sdkRelease"})
    @Keep
    public static final class Builder {
        private String sourceLanguage;
        private String targetLanguage;
        private String text;
        private String key;

        @NotNull
        public final Builder setSourceLanguage(@NotNull String sourceLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)sourceLanguage, (String)"sourceLanguage");
            this.sourceLanguage = sourceLanguage;
            return this;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            this.targetLanguage = targetLanguage;
            return this;
        }

        @NotNull
        public final Builder setText(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text = text;
            return this;
        }

        @NotNull
        public final Builder setKey(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.key = key;
            return this;
        }

        @NotNull
        public final HiTranslator build() {
            if (this.targetLanguage == null) {
                throw (Throwable)new NullPointerException("targetLanguage can`t null.");
            }
            if (this.text == null) {
                throw (Throwable)new NullPointerException("text can`t null.");
            }
            if (this.key == null) {
                throw (Throwable)new NullPointerException("key can`t null.");
            }
            String string2 = this.targetLanguage;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = this.text;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = this.key;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            return new HiTranslator(this.sourceLanguage, string2, string3, string4, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0087\b\u0018\u00002\u00020\u0001BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JU\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\bH\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/talpa/camera/translate/trans/HiTranslator$Result;", "", "sourceLanguage", "", "targetLanguage", "text", "translation", "valueCode", "", "valueMessage", "isCache", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Z)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getText", "getTranslation", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "translation_sdkRelease"})
    @Keep
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final String text;
        @Nullable
        private final String translation;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getTranslation() {
            return this.translation;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.text = text;
            this.translation = translation;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
        }

        public /* synthetic */ Result(String string2, String string3, String string4, String string5, int n, String string6, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string6 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            this(string2, string3, string4, string5, n, string6, bl);
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @Nullable
        public final String component4() {
            return this.translation;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return new Result(sourceLanguage, targetLanguage, text, translation, valueCode, valueMessage, isCache);
        }

        public static /* synthetic */ Result copy$default(Result result, String string2, String string3, String string4, String string5, int n, String string6, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = result.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string3 = result.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                string4 = result.text;
            }
            if ((n2 & 8) != 0) {
                string5 = result.translation;
            }
            if ((n2 & 0x10) != 0) {
                n = result.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string6 = result.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result.isCache;
            }
            return result.copy(string2, string3, string4, string5, n, string6, bl);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", text=" + this.text + ", translation=" + this.translation + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ")";
        }

        public int hashCode() {
            String string2 = this.sourceLanguage;
            String string3 = this.targetLanguage;
            String string4 = this.text;
            String string5 = this.translation;
            String string6 = this.valueMessage;
            int n = ((((((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + Integer.hashCode(this.valueCode)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31;
            int n2 = this.isCache ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result = (Result)object;
                    if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result.sourceLanguage) || !Intrinsics.areEqual((Object)this.targetLanguage, (Object)result.targetLanguage) || !Intrinsics.areEqual((Object)this.text, (Object)result.text) || !Intrinsics.areEqual((Object)this.translation, (Object)result.translation) || this.valueCode != result.valueCode || !Intrinsics.areEqual((Object)this.valueMessage, (Object)result.valueMessage) || this.isCache != result.isCache) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/talpa/camera/translate/trans/HiTranslator$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "PREFER_TRANSLATOR", "READ_TIME_OUT", "REQUEST_METHOD", "translation_sdkRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

