/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.translate.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Log;
import com.talpa.base.BaseApp;
import com.talpa.camera.edmodo.cropper.cropwindow.edge.Edge;
import com.tencent.mmkv.MMKV;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a\u0018\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"MAX_TEXT_SIZE_PX", "", "MIN_TEXT_SIZE_PX", "PREFER_KEY_SOURCE_LANG", "", "PREFER_NAME", "RATIO_16_9_VALUE", "", "RATIO_4_3_VALUE", "adjustTextSizePx", "", "maxSingleLine", "area", "Landroid/graphics/RectF;", "replaceImage", "Landroid/graphics/Bitmap;", "completedBitmap", "translationBitmap", "mask", "saveLanguage", "", "preferKey", "value", "isNetworkConnected", "", "Landroid/content/Context;", "translation_sdkRelease"})
public final class UtilsKt {
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG = "key_source_lang";
    @NotNull
    public static final String PREFER_NAME = "prefer_camera";
    public static final int MAX_TEXT_SIZE_PX = 160;
    public static final int MIN_TEXT_SIZE_PX = 12;

    @NotNull
    public static final Bitmap replaceImage(@NotNull Bitmap completedBitmap, @NotNull Bitmap translationBitmap, int mask) {
        Intrinsics.checkParameterIsNotNull((Object)completedBitmap, (String)"completedBitmap");
        Intrinsics.checkParameterIsNotNull((Object)translationBitmap, (String)"translationBitmap");
        Bitmap newBitmap = Bitmap.createBitmap((int)completedBitmap.getWidth(), (int)completedBitmap.getHeight(), (Bitmap.Config)completedBitmap.getConfig());
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawBitmap(completedBitmap, 0.0f, 0.0f, null);
        canvas.drawColor(mask);
        canvas.drawBitmap(translationBitmap, Edge.LEFT.getCoordinate(), Edge.TOP.getCoordinate(), new Paint());
        canvas.save();
        canvas.restore();
        Bitmap bitmap = newBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"newBitmap");
        return bitmap;
    }

    public static /* synthetic */ Bitmap replaceImage$default(Bitmap bitmap, Bitmap bitmap2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return UtilsKt.replaceImage(bitmap, bitmap2, n);
    }

    public static final void saveLanguage(@NotNull String preferKey2, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)preferKey2, (String)"preferKey");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        MMKV mmkv = MMKV.defaultMMKV();
        mmkv.encode(preferKey2, value);
    }

    public static /* synthetic */ void saveLanguage$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = PREFER_KEY_SOURCE_LANG;
        }
        UtilsKt.saveLanguage(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNetworkConnected(@NotNull Context $this$isNetworkConnected) {
        NetworkInfo networkInfo;
        Intrinsics.checkParameterIsNotNull((Object)$this$isNetworkConnected, (String)"$this$isNetworkConnected");
        Object object = $this$isNetworkConnected.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkInfo networkInfo2 = networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo2 == null) return false;
        if (!networkInfo2.isAvailable()) return false;
        if (!networkInfo.isConnected()) return false;
        return true;
    }

    public static final float adjustTextSizePx(@NotNull String maxSingleLine, @NotNull RectF area) {
        Intrinsics.checkParameterIsNotNull((Object)maxSingleLine, (String)"maxSingleLine");
        Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
        TextPaint textPaint = new TextPaint(1);
        boolean bl = false;
        boolean bl2 = false;
        TextPaint it = textPaint;
        boolean bl3 = false;
        Resources resources = BaseApp.INSTANCE.getAppContext().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"BaseApp.appContext.resources");
        it.density = resources.getDisplayMetrics().density;
        TextPaint textPaintClone = textPaint;
        float trySize = 160;
        textPaintClone.setTextSize(trySize);
        Paint.FontMetricsInt fm = textPaintClone.getFontMetricsInt();
        int top = fm.top;
        int bottom = fm.bottom;
        int height = Math.abs(bottom - top);
        int lineCount = 1;
        Log.d((String)"cjslog", (String)("with:" + area.width() + " + " + area.height() + ' ' + maxSingleLine));
        while ((textPaintClone.measureText(maxSingleLine, 0, maxSingleLine.length() / lineCount) > area.width() || (float)(lineCount * height) > area.height()) && trySize > (float)12) {
            StaticLayout staticLayout;
            float f = trySize;
            trySize = f + -1.0f;
            textPaintClone.setTextSize(trySize);
            Intrinsics.checkExpressionValueIsNotNull((Object)StaticLayout.Builder.obtain((CharSequence)maxSingleLine, (int)0, (int)maxSingleLine.length(), (TextPaint)textPaintClone, (int)((int)area.width())).build(), (String)"StaticLayout.Builder\n   \u2026.width().toInt()).build()");
            lineCount = staticLayout.getLineCount();
            fm = textPaintClone.getFontMetricsInt();
            top = fm.top;
            bottom = fm.bottom;
            height = Math.abs(bottom - top);
        }
        do {
            ++lineCount;
            while ((float)(lineCount * height) < area.height() && textPaintClone.measureText(maxSingleLine, 0, maxSingleLine.length() / lineCount) < area.width()) {
                float f = trySize;
                trySize = f + 1.0f;
                textPaintClone.setTextSize(trySize);
                fm = textPaintClone.getFontMetricsInt();
                top = fm.top;
                bottom = fm.bottom;
                height = Math.abs(bottom - top);
            }
        } while ((float)(lineCount * height) < area.height());
        return trySize;
    }
}

