/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.translate.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import androidx.core.content.ContextCompat;
import com.photo.translation.R;
import com.talpa.camera.translate.view.CaptureButtonState;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0004-./0B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0014J\u0006\u0010*\u001a\u00020#J\u0010\u0010+\u001a\u00020#2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010,\u001a\u00020#R\u0015\u0010\u000b\u001a\u00060\fR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0011\u001a\u00060\u0012R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0018\u001a\u00060\u0019R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/talpa/camera/translate/view/CaptureButton;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributes", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraState", "Lcom/talpa/camera/translate/view/CaptureButton$CameraState;", "getCameraState", "()Lcom/talpa/camera/translate/view/CaptureButton$CameraState;", "cropButton", "Landroid/graphics/drawable/Drawable;", "cropState", "Lcom/talpa/camera/translate/view/CaptureButton$CropState;", "getCropState", "()Lcom/talpa/camera/translate/view/CaptureButton$CropState;", "mAlpha", "mPaint", "Landroid/graphics/Paint;", "resultState", "Lcom/talpa/camera/translate/view/CaptureButton$ResultState;", "getResultState", "()Lcom/talpa/camera/translate/view/CaptureButton$ResultState;", "state", "Lcom/talpa/camera/translate/view/CaptureButtonState;", "transformRate", "", "transparentAnim", "Lcom/talpa/camera/translate/view/CaptureButton$TransparentAnim;", "cameraDraw", "", "canvas", "Landroid/graphics/Canvas;", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "revertAnim", "setState", "startAnim", "CameraState", "CropState", "ResultState", "TransparentAnim", "translation_sdkRelease"})
public final class CaptureButton
extends View {
    private int mAlpha;
    private Paint mPaint;
    private final TransparentAnim transparentAnim;
    private float transformRate;
    @NotNull
    private final CameraState cameraState;
    @NotNull
    private final CropState cropState;
    @NotNull
    private final ResultState resultState;
    private Drawable cropButton;
    private CaptureButtonState state;
    private HashMap _$_findViewCache;

    @NotNull
    public final CameraState getCameraState() {
        return this.cameraState;
    }

    @NotNull
    public final CropState getCropState() {
        return this.cropState;
    }

    @NotNull
    public final ResultState getResultState() {
        return this.resultState;
    }

    public final void startAnim() {
        this.startAnimation(this.transparentAnim);
    }

    public final void revertAnim() {
        block0: {
            Animation animation = this.getAnimation();
            if (animation == null) break block0;
            animation.cancel();
        }
    }

    public final void setState(@Nullable CaptureButtonState state) {
        this.state = state;
        this.requestLayout();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            CaptureButtonState captureButtonState = this.state;
            if (captureButtonState == null) break block0;
            captureButtonState.onDraw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block0: {
            CaptureButtonState captureButtonState = this.state;
            if (captureButtonState == null) break block0;
            captureButtonState.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void cameraDraw(Canvas canvas) {
        this.mPaint.setColor(-1);
        this.mPaint.setAlpha(this.mAlpha);
        float circleCenter = (float)this.getMeasuredHeight() / 2.0f;
        float radius = (float)this.getMeasuredHeight() / 2.0f * this.transformRate;
        canvas.drawCircle(circleCenter, circleCenter, radius, this.mPaint);
        this.mPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.pickerview_bg_topbar));
        this.mPaint.setAlpha(this.mAlpha);
        canvas.drawCircle(circleCenter, circleCenter, radius - (float)8 * this.transformRate, this.mPaint);
        this.mPaint.setColor(-1);
        this.mPaint.setAlpha(this.mAlpha);
        canvas.drawCircle(circleCenter, circleCenter, radius - (float)8 * this.transformRate - (float)8 * this.transformRate, this.mPaint);
    }

    public CaptureButton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public CaptureButton(@NotNull Context context, @Nullable AttributeSet attributes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attributes, 0);
    }

    public CaptureButton(@NotNull Context context, @Nullable AttributeSet attributes, int defStyle) {
        Drawable drawable;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributes, defStyle);
        this.mAlpha = 255;
        this.mPaint = new Paint();
        this.transparentAnim = new TransparentAnim();
        this.transformRate = 1.0f;
        this.cameraState = new CameraState();
        this.cropState = new CropState();
        this.resultState = new ResultState();
        this.state = this.cameraState;
        this.mPaint.setAntiAlias(true);
        CaptureButton captureButton = this;
        Drawable drawable2 = context.getDrawable(R.mipmap.select_language);
        if (drawable2 != null) {
            Drawable drawable3 = drawable2;
            CaptureButton captureButton2 = captureButton;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable3;
            boolean bl3 = false;
            it.setBounds(0, 0, it.getIntrinsicWidth(), it.getIntrinsicHeight());
            Drawable drawable4 = drawable3;
            captureButton = captureButton2;
            drawable = drawable4;
        } else {
            drawable = null;
        }
        captureButton.cropButton = drawable;
        Drawable drawable5 = this.getBackground();
        RippleDrawable rippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)ContextCompat.getColor((Context)context, (int)R.color.capture_foreground)), drawable5, null);
        this.setBackground((Drawable)rippleDrawable);
    }

    public static final /* synthetic */ void access$setCropButton$p(CaptureButton $this, Drawable drawable) {
        $this.cropButton = drawable;
    }

    public static final /* synthetic */ int access$getMAlpha$p(CaptureButton $this) {
        return $this.mAlpha;
    }

    public static final /* synthetic */ float access$getTransformRate$p(CaptureButton $this) {
        return $this.transformRate;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/talpa/camera/translate/view/CaptureButton$CropState;", "Lcom/talpa/camera/translate/view/CaptureButtonState;", "(Lcom/talpa/camera/translate/view/CaptureButton;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "translation_sdkRelease"})
    public final class CropState
    implements CaptureButtonState {
        @Override
        public void onDraw(@NotNull Canvas canvas) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                Drawable drawable = CaptureButton.this.cropButton;
                int dx = CaptureButton.this.getMeasuredWidth() / 2 - (drawable != null ? drawable.getIntrinsicWidth() : 0) / 2;
                Drawable drawable2 = CaptureButton.this.cropButton;
                int dy = CaptureButton.this.getMeasuredHeight() / 2 - (drawable2 != null ? drawable2.getIntrinsicHeight() : 0) / 2;
                Canvas canvas2 = canvas;
                boolean bl = false;
                int n = Math.abs(dx);
                float f = n;
                bl = false;
                int n2 = Math.abs(dy);
                canvas2.translate(f, (float)n2);
                Drawable drawable3 = CaptureButton.this.cropButton;
                if (drawable3 == null) break block0;
                drawable3.draw(canvas);
            }
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            CaptureButton.this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/talpa/camera/translate/view/CaptureButton$CameraState;", "Lcom/talpa/camera/translate/view/CaptureButtonState;", "(Lcom/talpa/camera/translate/view/CaptureButton;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "translation_sdkRelease"})
    public final class CameraState
    implements CaptureButtonState {
        @Override
        public void onDraw(@NotNull Canvas canvas) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            CaptureButton.this.cameraDraw(canvas);
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            CaptureButton.this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/talpa/camera/translate/view/CaptureButton$ResultState;", "Lcom/talpa/camera/translate/view/CaptureButtonState;", "(Lcom/talpa/camera/translate/view/CaptureButton;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "translation_sdkRelease"})
    public final class ResultState
    implements CaptureButtonState {
        @Override
        public void onDraw(@NotNull Canvas canvas) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            CaptureButton.this.cameraDraw(canvas);
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            CaptureButton.this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.translation_result), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.translation_result), (int)0x40000000));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/talpa/camera/translate/view/CaptureButton$TransparentAnim;", "Landroid/view/animation/Animation;", "(Lcom/talpa/camera/translate/view/CaptureButton;)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "initialize", "width", "", "height", "parentWidth", "parentHeight", "translation_sdkRelease"})
    public final class TransparentAnim
    extends Animation {
        protected void applyTransformation(float interpolatedTime, @Nullable Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            CaptureButton.this.mAlpha = 255 - (int)(0.5 * (double)interpolatedTime * (double)255);
            CaptureButton.this.transformRate = 1.0f - 0.25f * interpolatedTime;
            CaptureButton.this.postInvalidate();
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
            this.setDuration(50L);
            this.setFillAfter(true);
            this.setInterpolator((Interpolator)new LinearInterpolator());
        }
    }
}

