/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translation.engine;

import android.content.Context;
import com.talpa.translation.controller.TranslateStateMachineImpl;
import com.talpa.translation.controller.TranslationStateMachine;
import com.talpa.translation.handler.TranslationHandler;
import com.talpa.translation.session.TranslationSession;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/talpa/translation/engine/TranslationStateEngine;", "", "()V", "androidContext", "Landroid/content/Context;", "handlerMap", "Ljava/util/HashMap;", "", "Lcom/talpa/translation/handler/TranslationHandler;", "Lkotlin/collections/HashMap;", "stateMachine", "Lcom/talpa/translation/controller/TranslationStateMachine;", "getStateMachine", "()Lcom/talpa/translation/controller/TranslationStateMachine;", "getAndroidContext", "getHandler", "translationSession", "Lcom/talpa/translation/session/TranslationSession;", "initEngine", "", "post", "setHandler", "translationHandler", "translation_sdkRelease"})
public final class TranslationStateEngine {
    private static Context androidContext;
    private static final HashMap<String, TranslationHandler> handlerMap;
    @NotNull
    private static final TranslationStateMachine stateMachine;
    public static final TranslationStateEngine INSTANCE;

    @NotNull
    public final TranslationStateMachine getStateMachine() {
        return stateMachine;
    }

    public final void initEngine(@NotNull Context androidContext) {
        Intrinsics.checkParameterIsNotNull((Object)androidContext, (String)"androidContext");
        TranslationStateEngine.androidContext = androidContext;
    }

    @NotNull
    public final Context getAndroidContext() {
        Context context = androidContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidContext");
        }
        return context;
    }

    public final void post(@NotNull TranslationSession translationSession) {
        Intrinsics.checkParameterIsNotNull((Object)translationSession, (String)"translationSession");
        TranslationHandler h = this.getHandler(translationSession);
        h.handle(translationSession);
    }

    public final void setHandler(@NotNull TranslationSession translationSession, @NotNull TranslationHandler translationHandler) {
        Intrinsics.checkParameterIsNotNull((Object)translationSession, (String)"translationSession");
        Intrinsics.checkParameterIsNotNull((Object)translationHandler, (String)"translationHandler");
        ((Map)handlerMap).put(translationSession.getType().name() + ':' + translationSession.getState().name(), translationHandler);
    }

    private final TranslationHandler getHandler(TranslationSession translationSession) {
        String key = translationSession.getType().name() + ':' + translationSession.getState().name();
        TranslationHandler translationHandler = handlerMap.get(key);
        if (translationHandler == null) {
            throw (Throwable)new IllegalStateException("error translateSession");
        }
        return translationHandler;
    }

    private TranslationStateEngine() {
    }

    static {
        TranslationStateEngine translationStateEngine;
        INSTANCE = translationStateEngine = new TranslationStateEngine();
        handlerMap = new HashMap();
        stateMachine = new TranslateStateMachineImpl();
    }
}

