package com.talpa.translate.activity

import android.content.Context
import android.content.Intent
import android.media.projection.MediaProjectionManager
import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import com.talpa.TranslationController
import com.talpa.translate.base.utils.TB_screen_trans_dialog
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.base.view.alert.AlertView
import com.talpa.translate.base.view.alert.OnItemClickListener
import com.talpa.translate.record.CaptureManager.Companion.STATE_INITIALIZE
import com.talpa.translate.record.CaptureManager.Companion.STATE_PERMISSION_GRANTED

/**
 * Create by chenjunsheng on 2020/8/4
 */
class ScreenRecordActivity : AppCompatActivity() {

    companion object {
        fun start(context: Context) {
            val intent = Intent(context, ScreenRecordActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            context.startActivity(intent)
        }
        const val REQUEST_CODE = 100
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        /*AlertDialog.Builder(this)
            .setTitle("请给录屏权限")
            .setPositiveButton(
                "给"
            ) { dialog, which ->
                val projectionManager =
                    getSystemService(Context.MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
                val captureIntent = projectionManager.createScreenCaptureIntent()
                startActivityForResult(captureIntent, REQUEST_CODE)
            }
            .setNegativeButton("不给"
            ) { dialog, which ->
                TranslationController.getCaptureManager()?.setCurrentState(STATE_INITIALIZE)
                finish() }
            .show()*/
        //AlertView("标题", "内容", null, new String[]{"确定"}, null, this, AlertView.Style.Alert, this).show();
        AlertView(this, object : OnItemClickListener {
            override fun onConfirm(view: AlertView) {
                view.dismissImmediately()
                val projectionManager =
                    getSystemService(Context.MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
                val captureIntent = projectionManager.createScreenCaptureIntent()
                startActivityForResult(captureIntent, REQUEST_CODE)
                logEvent(TB_screen_trans_dialog, "state", "YES")
            }

            override fun onCancel(view: AlertView) {
                logEvent(TB_screen_trans_dialog, "state", "NO")
                view.dismiss()
                TranslationController.getCaptureManager()?.setCurrentState(STATE_INITIALIZE)
                finish()
            }

        }).show()
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (data == null) {
            Log.d("cjslog", "media project fail")
            TranslationController.getCaptureManager()?.setCurrentState(STATE_INITIALIZE)
            finish()
            return
        }
        /*val mediaProjection = mMediaProjectionManager.getMediaProjection(resultCode, data)
        if (mediaProjection == null) {
            Log.d("cjslog", "media project fail")
            finish()
            return
        }*/

        TranslationController.getCaptureManager()?.startRecordService(this, resultCode, data)
        TranslationController.getCaptureManager()?.setCurrentState(STATE_PERMISSION_GRANTED)
        //RecordManager.startRecord(this, resultCode, data)

        finish()
    }
}