/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.location.Location;
import android.media.Image;
import android.media.ImageReader;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.talpa.translate.camera.view.CameraException;
import com.talpa.translate.camera.view.CameraOptions;
import com.talpa.translate.camera.view.PictureResult;
import com.talpa.translate.camera.view.VideoResult;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Hdr;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.controls.WhiteBalance;
import com.talpa.translate.camera.view.engine.CameraBaseEngine;
import com.talpa.translate.camera.view.engine.CameraEngine;
import com.talpa.translate.camera.view.engine.EngineThread;
import com.talpa.translate.camera.view.engine.action.Action;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.action.Actions;
import com.talpa.translate.camera.view.engine.action.BaseAction;
import com.talpa.translate.camera.view.engine.action.CompletionCallback;
import com.talpa.translate.camera.view.engine.action.LogAction;
import com.talpa.translate.camera.view.engine.mappers.Camera2Mapper;
import com.talpa.translate.camera.view.engine.meter.MeterAction;
import com.talpa.translate.camera.view.engine.meter.MeterResetAction;
import com.talpa.translate.camera.view.engine.offset.Axis;
import com.talpa.translate.camera.view.engine.offset.Reference;
import com.talpa.translate.camera.view.engine.options.Camera2Options;
import com.talpa.translate.camera.view.engine.orchestrator.CameraState;
import com.talpa.translate.camera.view.frame.Frame;
import com.talpa.translate.camera.view.frame.FrameManager;
import com.talpa.translate.camera.view.frame.ImageFrameManager;
import com.talpa.translate.camera.view.gesture.Gesture;
import com.talpa.translate.camera.view.internal.CropHelper;
import com.talpa.translate.camera.view.metering.MeteringRegions;
import com.talpa.translate.camera.view.picture.Full2PictureRecorder;
import com.talpa.translate.camera.view.picture.Snapshot2PictureRecorder;
import com.talpa.translate.camera.view.preview.RendererCameraPreview;
import com.talpa.translate.camera.view.size.AspectRatio;
import com.talpa.translate.camera.view.video.Full2VideoRecorder;
import com.talpa.translate.camera.view.video.SnapshotVideoRecorder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;

@RequiresApi(value=21)
public class Camera2Engine
extends CameraBaseEngine
implements ImageReader.OnImageAvailableListener,
ActionHolder {
    private static final int FRAME_PROCESSING_FORMAT = 35;
    @VisibleForTesting
    static final long METER_TIMEOUT = 5000L;
    private static final long METER_TIMEOUT_SHORT = 2500L;
    private final CameraManager mManager;
    private String mCameraId;
    private CameraDevice mCamera;
    private CameraCharacteristics mCameraCharacteristics;
    private CameraCaptureSession mSession;
    private CaptureRequest.Builder mRepeatingRequestBuilder;
    private TotalCaptureResult mLastRepeatingResult;
    private final Camera2Mapper mMapper = Camera2Mapper.get();
    private ImageReader mFrameProcessingReader;
    private Surface mFrameProcessingSurface;
    private Surface mPreviewStreamSurface;
    private VideoResult.Stub mFullVideoPendingStub;
    private ImageReader mPictureReader;
    private final boolean mPictureCaptureStopsPreview = false;
    private final List<Action> mActions = new CopyOnWriteArrayList<Action>();
    private MeterAction mMeterAction;
    private final CameraCaptureSession.CaptureCallback mRepeatingRequestCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureStarted(Camera2Engine.this, request);
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureProgressed(Camera2Engine.this, request, partialResult);
            }
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Camera2Engine.this.mLastRepeatingResult = result;
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureCompleted(Camera2Engine.this, request, result);
            }
        }
    };

    public Camera2Engine(CameraEngine.Callback callback) {
        super(callback);
        this.mManager = (CameraManager)this.getCallback().getContext().getSystemService("camera");
        new LogAction().start(this);
    }

    @VisibleForTesting
    @NonNull
    <T> T readCharacteristic(@NonNull CameraCharacteristics.Key<T> key, @NonNull T fallback) {
        return this.readCharacteristic(this.mCameraCharacteristics, key, fallback);
    }

    @NonNull
    private <T> T readCharacteristic(@NonNull CameraCharacteristics characteristics, @NonNull CameraCharacteristics.Key<T> key, @NonNull T fallback) {
        Object value = characteristics.get(key);
        return (T)(value == null ? fallback : value);
    }

    @NonNull
    private CameraException createCameraException(@NonNull CameraAccessException exception) {
        int reason;
        switch (exception.getReason()) {
            case 1: 
            case 4: 
            case 5: {
                reason = 1;
                break;
            }
            case 2: 
            case 3: {
                reason = 3;
                break;
            }
            default: {
                reason = 0;
            }
        }
        return new CameraException(exception, reason);
    }

    @NonNull
    private CameraException createCameraException(int stateCallbackError) {
        int reason;
        switch (stateCallbackError) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                reason = 1;
                break;
            }
            default: {
                reason = 0;
            }
        }
        return new CameraException(reason);
    }

    @NonNull
    private CaptureRequest.Builder createRepeatingRequestBuilder(int template) throws CameraAccessException {
        CaptureRequest.Builder oldBuilder = this.mRepeatingRequestBuilder;
        this.mRepeatingRequestBuilder = this.mCamera.createCaptureRequest(template);
        this.mRepeatingRequestBuilder.setTag((Object)template);
        this.applyAllParameters(this.mRepeatingRequestBuilder, oldBuilder);
        return this.mRepeatingRequestBuilder;
    }

    private void addRepeatingRequestBuilderSurfaces(Surface ... extraSurfaces) {
        this.mRepeatingRequestBuilder.addTarget(this.mPreviewStreamSurface);
        if (this.mFrameProcessingSurface != null) {
            this.mRepeatingRequestBuilder.addTarget(this.mFrameProcessingSurface);
        }
        for (Surface extraSurface : extraSurfaces) {
            if (extraSurface == null) {
                throw new IllegalArgumentException("Should not add a null surface.");
            }
            this.mRepeatingRequestBuilder.addTarget(extraSurface);
        }
    }

    private void removeRepeatingRequestBuilderSurfaces() {
        this.mRepeatingRequestBuilder.removeTarget(this.mPreviewStreamSurface);
        if (this.mFrameProcessingSurface != null) {
            this.mRepeatingRequestBuilder.removeTarget(this.mFrameProcessingSurface);
        }
    }

    @EngineThread
    protected void applyRepeatingRequestBuilder() {
        this.applyRepeatingRequestBuilder(true, 3);
    }

    @EngineThread
    private void applyRepeatingRequestBuilder(boolean checkStarted, int errorReason) {
        if (this.getState() == CameraState.PREVIEW && !this.isChangingState() || !checkStarted) {
            try {
                this.mSession.setRepeatingRequest(this.mRepeatingRequestBuilder.build(), this.mRepeatingRequestCallback, null);
            }
            catch (CameraAccessException e) {
                throw new CameraException(e, errorReason);
            }
            catch (IllegalStateException e) {
                LOG.e(new Object[]{"applyRepeatingRequestBuilder: session is invalid!", e, "checkStarted:", checkStarted, "currentThread:", Thread.currentThread().getName(), "state:", this.getState(), "targetState:", this.getTargetState()});
                throw new CameraException(3);
            }
        }
    }

    @Override
    @EngineThread
    @NonNull
    protected List<com.talpa.translate.camera.view.size.Size> getPreviewStreamAvailableSizes() {
        try {
            CameraCharacteristics characteristics = this.mManager.getCameraCharacteristics(this.mCameraId);
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamMap == null) {
                throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
            }
            Size[] sizes = streamMap.getOutputSizes(this.mPreview.getOutputClass());
            ArrayList<com.talpa.translate.camera.view.size.Size> candidates = new ArrayList<com.talpa.translate.camera.view.size.Size>(sizes.length);
            for (Size size : sizes) {
                com.talpa.translate.camera.view.size.Size add = new com.talpa.translate.camera.view.size.Size(size.getWidth(), size.getHeight());
                if (candidates.contains(add)) continue;
                candidates.add(add);
            }
            return candidates;
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
    }

    @Override
    @EngineThread
    @NonNull
    protected List<com.talpa.translate.camera.view.size.Size> getFrameProcessingAvailableSizes() {
        try {
            CameraCharacteristics characteristics = this.mManager.getCameraCharacteristics(this.mCameraId);
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamMap == null) {
                throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
            }
            Size[] sizes = streamMap.getOutputSizes(this.mFrameProcessingFormat);
            ArrayList<com.talpa.translate.camera.view.size.Size> candidates = new ArrayList<com.talpa.translate.camera.view.size.Size>(sizes.length);
            for (Size size : sizes) {
                com.talpa.translate.camera.view.size.Size add = new com.talpa.translate.camera.view.size.Size(size.getWidth(), size.getHeight());
                if (candidates.contains(add)) continue;
                candidates.add(add);
            }
            return candidates;
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
    }

    @Override
    @EngineThread
    protected void onPreviewStreamSizeChanged() {
        LOG.i("onPreviewStreamSizeChanged:", "Calling restartBind().");
        this.restartBind();
    }

    @Override
    @EngineThread
    protected final boolean collectCameraInfo(@NonNull Facing facing) {
        int internalFacing = this.mMapper.mapFacing(facing);
        String[] cameraIds = null;
        try {
            cameraIds = this.mManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        LOG.i("collectCameraInfo", "Facing:", facing, "Internal:", internalFacing, "Cameras:", cameraIds.length);
        for (String cameraId : cameraIds) {
            try {
                CameraCharacteristics characteristics = this.mManager.getCameraCharacteristics(cameraId);
                if (internalFacing != this.readCharacteristic(characteristics, CameraCharacteristics.LENS_FACING, -99)) continue;
                this.mCameraId = cameraId;
                int sensorOffset = this.readCharacteristic(characteristics, CameraCharacteristics.SENSOR_ORIENTATION, 0);
                this.getAngles().setSensorOffset(facing, sensorOffset);
                return true;
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @EngineThread
    @SuppressLint(value={"MissingPermission"})
    @NonNull
    protected Task<CameraOptions> onStartEngine() {
        final TaskCompletionSource task2 = new TaskCompletionSource();
        try {
            this.mManager.openCamera(this.mCameraId, new CameraDevice.StateCallback(){

                public void onOpened(@NonNull CameraDevice camera) {
                    Camera2Engine.this.mCamera = camera;
                    try {
                        int format;
                        CameraEngine.LOG.i("onStartEngine:", "Opened camera device.");
                        Camera2Engine.this.mCameraCharacteristics = Camera2Engine.this.mManager.getCameraCharacteristics(Camera2Engine.this.mCameraId);
                        boolean flip = Camera2Engine.this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
                        switch (Camera2Engine.this.mPictureFormat) {
                            case JPEG: {
                                format = 256;
                                break;
                            }
                            case DNG: {
                                format = 32;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown format:" + Camera2Engine.this.mPictureFormat);
                            }
                        }
                        Camera2Engine.this.mCameraOptions = new Camera2Options(Camera2Engine.this.mManager, Camera2Engine.this.mCameraId, flip, format);
                        Camera2Engine.this.createRepeatingRequestBuilder(1);
                    }
                    catch (CameraAccessException e) {
                        task2.trySetException((Exception)Camera2Engine.this.createCameraException(e));
                        return;
                    }
                    task2.trySetResult((Object)Camera2Engine.this.mCameraOptions);
                }

                public void onDisconnected(@NonNull CameraDevice camera) {
                    CameraException exception = new CameraException(3);
                    if (task2.getTask().isComplete()) {
                        CameraEngine.LOG.i("CameraDevice.StateCallback reported disconnection.");
                        throw exception;
                    }
                    task2.trySetException((Exception)exception);
                }

                public void onError(@NonNull CameraDevice camera, int error) {
                    if (task2.getTask().isComplete()) {
                        CameraEngine.LOG.e("CameraDevice.StateCallback reported an error:", error);
                        throw new CameraException(3);
                    }
                    task2.trySetException((Exception)Camera2Engine.this.createCameraException(error));
                }
            }, null);
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        return task2.getTask();
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartBind() {
        LOG.i("onStartBind:", "Started");
        final TaskCompletionSource task2 = new TaskCompletionSource();
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewStreamSize = this.computePreviewStreamSize();
        ArrayList<Surface> outputSurfaces = new ArrayList<Surface>();
        Class outputClass = this.mPreview.getOutputClass();
        final Object output = this.mPreview.getOutput();
        if (outputClass == SurfaceHolder.class) {
            try {
                Tasks.await((Task)Tasks.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        ((SurfaceHolder)output).setFixedSize(Camera2Engine.this.mPreviewStreamSize.getWidth(), Camera2Engine.this.mPreviewStreamSize.getHeight());
                        return null;
                    }
                }));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CameraException(e, 1);
            }
            this.mPreviewStreamSurface = ((SurfaceHolder)output).getSurface();
        } else if (outputClass == SurfaceTexture.class) {
            ((SurfaceTexture)output).setDefaultBufferSize(this.mPreviewStreamSize.getWidth(), this.mPreviewStreamSize.getHeight());
            this.mPreviewStreamSurface = new Surface((SurfaceTexture)output);
        } else {
            throw new RuntimeException("Unknown CameraPreview output class.");
        }
        outputSurfaces.add(this.mPreviewStreamSurface);
        if (this.getMode() == Mode.VIDEO && this.mFullVideoPendingStub != null) {
            Full2VideoRecorder recorder = new Full2VideoRecorder(this, this.mCameraId);
            try {
                outputSurfaces.add(recorder.createInputSurface(this.mFullVideoPendingStub));
            }
            catch (Full2VideoRecorder.PrepareException e) {
                throw new CameraException(e, 1);
            }
            this.mVideoRecorder = recorder;
        }
        if (this.getMode() == Mode.PICTURE) {
            int format;
            switch (this.mPictureFormat) {
                case JPEG: {
                    format = 256;
                    break;
                }
                case DNG: {
                    format = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown format:" + this.mPictureFormat);
                }
            }
            this.mPictureReader = ImageReader.newInstance((int)this.mCaptureSize.getWidth(), (int)this.mCaptureSize.getHeight(), (int)format, (int)2);
            outputSurfaces.add(this.mPictureReader.getSurface());
        }
        if (this.hasFrameProcessors()) {
            this.mFrameProcessingSize = this.computeFrameProcessingSize();
            this.mFrameProcessingReader = ImageReader.newInstance((int)this.mFrameProcessingSize.getWidth(), (int)this.mFrameProcessingSize.getHeight(), (int)this.mFrameProcessingFormat, (int)(this.getFrameProcessingPoolSize() + 1));
            this.mFrameProcessingReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, null);
            this.mFrameProcessingSurface = this.mFrameProcessingReader.getSurface();
            outputSurfaces.add(this.mFrameProcessingSurface);
        } else {
            this.mFrameProcessingReader = null;
            this.mFrameProcessingSize = null;
            this.mFrameProcessingSurface = null;
        }
        try {
            this.mCamera.createCaptureSession(outputSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession session) {
                    Camera2Engine.this.mSession = session;
                    CameraEngine.LOG.i("onStartBind:", "Completed");
                    task2.trySetResult(null);
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                    String message = CameraEngine.LOG.e("onConfigureFailed! Session", session);
                    throw new RuntimeException(message);
                }

                public void onReady(@NonNull CameraCaptureSession session) {
                    super.onReady(session);
                    CameraEngine.LOG.i("CameraCaptureSession.StateCallback reported onReady.");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        return task2.getTask();
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartPreview() {
        LOG.i("onStartPreview:", "Dispatching onCameraPreviewStreamSizeChanged.");
        this.getCallback().onCameraPreviewStreamSizeChanged();
        com.talpa.translate.camera.view.size.Size previewSizeForView = this.getPreviewStreamSize(Reference.VIEW);
        if (previewSizeForView == null) {
            throw new IllegalStateException("previewStreamSize should not be null at this point.");
        }
        this.mPreview.setStreamSize(previewSizeForView.getWidth(), previewSizeForView.getHeight());
        this.mPreview.setDrawRotation(this.getAngles().offset(Reference.BASE, Reference.VIEW, Axis.ABSOLUTE));
        if (this.hasFrameProcessors()) {
            this.getFrameManager().setUp(this.mFrameProcessingFormat, this.mFrameProcessingSize, this.getAngles());
        }
        LOG.i("onStartPreview:", "Starting preview.");
        this.addRepeatingRequestBuilderSurfaces(new Surface[0]);
        this.applyRepeatingRequestBuilder(false, 2);
        LOG.i("onStartPreview:", "Started preview.");
        if (this.mFullVideoPendingStub != null) {
            final VideoResult.Stub stub = this.mFullVideoPendingStub;
            this.mFullVideoPendingStub = null;
            this.getOrchestrator().scheduleStateful("do take video", CameraState.PREVIEW, new Runnable(){

                @Override
                public void run() {
                    Camera2Engine.this.doTakeVideo(stub);
                }
            });
        }
        final TaskCompletionSource task2 = new TaskCompletionSource();
        new BaseAction(){

            @Override
            public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                super.onCaptureCompleted(holder, request, result);
                this.setState(Integer.MAX_VALUE);
                task2.trySetResult(null);
            }
        }.start(this);
        return task2.getTask();
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopPreview() {
        LOG.i("onStopPreview:", "Started.");
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(true);
            this.mVideoRecorder = null;
        }
        this.mPictureRecorder = null;
        if (this.hasFrameProcessors()) {
            this.getFrameManager().release();
        }
        this.removeRepeatingRequestBuilderSurfaces();
        this.mLastRepeatingResult = null;
        LOG.i("onStopPreview:", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopBind() {
        LOG.i("onStopBind:", "About to clean up.");
        this.mFrameProcessingSurface = null;
        this.mPreviewStreamSurface = null;
        this.mPreviewStreamSize = null;
        this.mCaptureSize = null;
        this.mFrameProcessingSize = null;
        if (this.mFrameProcessingReader != null) {
            this.mFrameProcessingReader.close();
            this.mFrameProcessingReader = null;
        }
        if (this.mPictureReader != null) {
            this.mPictureReader.close();
            this.mPictureReader = null;
        }
        this.mSession.close();
        this.mSession = null;
        LOG.i("onStopBind:", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopEngine() {
        try {
            LOG.i("onStopEngine:", "Clean up.", "Releasing camera.");
            this.mCamera.close();
            LOG.i("onStopEngine:", "Clean up.", "Released camera.");
        }
        catch (Exception e) {
            LOG.w("onStopEngine:", "Clean up.", "Exception while releasing camera.", e);
        }
        this.mCamera = null;
        LOG.i("onStopEngine:", "Aborting actions.");
        for (Action action : this.mActions) {
            action.abort(this);
        }
        this.mCameraCharacteristics = null;
        this.mCameraOptions = null;
        this.mVideoRecorder = null;
        this.mRepeatingRequestBuilder = null;
        LOG.w("onStopEngine:", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    protected void onTakePictureSnapshot(final @NonNull PictureResult.Stub stub, @NonNull AspectRatio outputRatio, boolean doMetering) {
        if (doMetering) {
            LOG.i("onTakePictureSnapshot:", "doMetering is true. Delaying.");
            BaseAction action = Actions.timeout(2500L, this.createMeterAction(null));
            action.addCallback(new CompletionCallback(){

                @Override
                protected void onActionCompleted(@NonNull Action action) {
                    Camera2Engine.this.setPictureSnapshotMetering(false);
                    Camera2Engine.this.takePictureSnapshot(stub);
                    Camera2Engine.this.setPictureSnapshotMetering(true);
                }
            });
            action.start(this);
        } else {
            LOG.i("onTakePictureSnapshot:", "doMetering is false. Performing.");
            if (!(this.mPreview instanceof RendererCameraPreview)) {
                throw new RuntimeException("takePictureSnapshot with Camera2 is only supported with Preview.GL_SURFACE");
            }
            stub.size = this.getUncroppedSnapshotSize(Reference.OUTPUT);
            stub.rotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
            this.mPictureRecorder = new Snapshot2PictureRecorder(stub, this, (RendererCameraPreview)((Object)this.mPreview), outputRatio);
            this.mPictureRecorder.take();
        }
    }

    @Override
    @EngineThread
    protected void onTakePicture(final @NonNull PictureResult.Stub stub, boolean doMetering) {
        if (doMetering) {
            LOG.i("onTakePicture:", "doMetering is true. Delaying.");
            BaseAction action = Actions.timeout(2500L, this.createMeterAction(null));
            action.addCallback(new CompletionCallback(){

                @Override
                protected void onActionCompleted(@NonNull Action action) {
                    Camera2Engine.this.setPictureMetering(false);
                    Camera2Engine.this.takePicture(stub);
                    Camera2Engine.this.setPictureMetering(true);
                }
            });
            action.start(this);
        } else {
            LOG.i("onTakePicture:", "doMetering is false. Performing.");
            stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
            stub.size = this.getPictureSize(Reference.OUTPUT);
            try {
                CaptureRequest.Builder builder = this.mCamera.createCaptureRequest(2);
                this.applyAllParameters(builder, this.mRepeatingRequestBuilder);
                this.mPictureRecorder = new Full2PictureRecorder(stub, this, builder, this.mPictureReader);
                this.mPictureRecorder.take();
            }
            catch (CameraAccessException e) {
                throw this.createCameraException(e);
            }
        }
    }

    @Override
    public void onPictureResult(@Nullable PictureResult.Stub result, @Nullable Exception error) {
        boolean unlock;
        boolean fullPicture = this.mPictureRecorder instanceof Full2PictureRecorder;
        super.onPictureResult(result, error);
        if (fullPicture) {
            // empty if block
        }
        boolean bl = unlock = fullPicture && this.getPictureMetering() || !fullPicture && this.getPictureSnapshotMetering();
        if (unlock) {
            this.getOrchestrator().scheduleStateful("reset metering after picture", CameraState.PREVIEW, new Runnable(){

                @Override
                public void run() {
                    Camera2Engine.this.unlockAndResetMetering();
                }
            });
        }
    }

    @Override
    @EngineThread
    protected void onTakeVideo(@NonNull VideoResult.Stub stub) {
        LOG.i("onTakeVideo", "called.");
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getAngles().flip(Reference.SENSOR, Reference.OUTPUT) ? this.mCaptureSize.flip() : this.mCaptureSize;
        LOG.w("onTakeVideo", "calling restartBind.");
        this.mFullVideoPendingStub = stub;
        this.restartBind();
    }

    private void doTakeVideo(@NonNull VideoResult.Stub stub) {
        if (!(this.mVideoRecorder instanceof Full2VideoRecorder)) {
            throw new IllegalStateException("doTakeVideo called, but video recorder is not a Full2VideoRecorder! " + this.mVideoRecorder);
        }
        Full2VideoRecorder recorder = (Full2VideoRecorder)this.mVideoRecorder;
        try {
            this.createRepeatingRequestBuilder(3);
            this.addRepeatingRequestBuilderSurfaces(recorder.getInputSurface());
            this.applyRepeatingRequestBuilder(true, 3);
            this.mVideoRecorder.start(stub);
        }
        catch (CameraAccessException e) {
            this.onVideoResult(null, (Exception)((Object)e));
            throw this.createCameraException(e);
        }
        catch (CameraException e) {
            this.onVideoResult(null, e);
            throw e;
        }
    }

    @Override
    @EngineThread
    protected void onTakeVideoSnapshot(@NonNull VideoResult.Stub stub, @NonNull AspectRatio outputRatio) {
        if (!(this.mPreview instanceof RendererCameraPreview)) {
            throw new IllegalStateException("Video snapshots are only supported with GL_SURFACE.");
        }
        RendererCameraPreview glPreview = (RendererCameraPreview)((Object)this.mPreview);
        com.talpa.translate.camera.view.size.Size outputSize = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        if (outputSize == null) {
            throw new IllegalStateException("outputSize should not be null.");
        }
        Rect outputCrop = CropHelper.computeCrop(outputSize, outputRatio);
        stub.size = outputSize = new com.talpa.translate.camera.view.size.Size(outputCrop.width(), outputCrop.height());
        stub.rotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
        stub.videoFrameRate = Math.round(this.mPreviewFrameRate);
        LOG.i("onTakeVideoSnapshot", "rotation:", stub.rotation, "size:", stub.size);
        this.mVideoRecorder = new SnapshotVideoRecorder(this, glPreview, this.getOverlay());
        this.mVideoRecorder.start(stub);
    }

    @Override
    public void onVideoRecordingEnd() {
        boolean needsIssue549Workaround;
        super.onVideoRecordingEnd();
        boolean bl = needsIssue549Workaround = this.mVideoRecorder instanceof Full2VideoRecorder && this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) == 2;
        if (needsIssue549Workaround) {
            LOG.w("Applying the Issue549 workaround.", Thread.currentThread());
            this.maybeRestorePreviewTemplateAfterVideo();
            LOG.w("Applied the Issue549 workaround. Sleeping...");
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.w("Applied the Issue549 workaround. Slept!");
        }
    }

    @Override
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        super.onVideoResult(result, exception);
        this.getOrchestrator().scheduleStateful("restore preview template", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                Camera2Engine.this.maybeRestorePreviewTemplateAfterVideo();
            }
        });
    }

    @EngineThread
    private void maybeRestorePreviewTemplateAfterVideo() {
        int template = (Integer)this.mRepeatingRequestBuilder.build().getTag();
        if (template != 1) {
            try {
                this.createRepeatingRequestBuilder(1);
                this.addRepeatingRequestBuilderSurfaces(new Surface[0]);
                this.applyRepeatingRequestBuilder();
            }
            catch (CameraAccessException e) {
                throw this.createCameraException(e);
            }
        }
    }

    private void applyAllParameters(@NonNull CaptureRequest.Builder builder, @Nullable CaptureRequest.Builder oldBuilder) {
        LOG.i("applyAllParameters:", "called for tag", builder.build().getTag());
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.applyDefaultFocus(builder);
        this.applyFlash(builder, Flash.OFF);
        this.applyLocation(builder, null);
        this.applyWhiteBalance(builder, WhiteBalance.AUTO);
        this.applyHdr(builder, Hdr.OFF);
        this.applyZoom(builder, 0.0f);
        this.applyExposureCorrection(builder, 0.0f);
        this.applyPreviewFrameRate(builder, 0.0f);
        if (oldBuilder != null) {
            builder.set(CaptureRequest.CONTROL_AF_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AF_REGIONS));
            builder.set(CaptureRequest.CONTROL_AE_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AE_REGIONS));
            builder.set(CaptureRequest.CONTROL_AWB_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AWB_REGIONS));
            builder.set(CaptureRequest.CONTROL_AF_MODE, oldBuilder.get(CaptureRequest.CONTROL_AF_MODE));
        }
    }

    protected void applyDefaultFocus(@NonNull CaptureRequest.Builder builder) {
        int[] modesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, new int[0]);
        ArrayList<Integer> modes = new ArrayList<Integer>();
        for (int mode : modesArray) {
            modes.add(mode);
        }
        if (this.getMode() == Mode.VIDEO && modes.contains(3)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            return;
        }
        if (modes.contains(4)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            return;
        }
        if (modes.contains(1)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            return;
        }
        if (modes.contains(0)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.0f));
            return;
        }
    }

    protected void applyFocusForMetering(@NonNull CaptureRequest.Builder builder) {
        int[] modesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, new int[0]);
        ArrayList<Integer> modes = new ArrayList<Integer>();
        for (int mode : modesArray) {
            modes.add(mode);
        }
        if (modes.contains(1)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            return;
        }
        if (this.getMode() == Mode.VIDEO && modes.contains(3)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            return;
        }
        if (modes.contains(4)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            return;
        }
    }

    @Override
    public void setFlash(final @NonNull Flash flash) {
        final Flash old = this.mFlash;
        this.mFlash = flash;
        this.mFlashTask = this.getOrchestrator().scheduleStateful("flash (" + flash + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                boolean needsWorkaround;
                boolean shouldApply = Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                boolean bl = needsWorkaround = Camera2Engine.this.getState() == CameraState.PREVIEW;
                if (needsWorkaround) {
                    Camera2Engine.this.mFlash = Flash.OFF;
                    Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                    try {
                        Camera2Engine.this.mSession.capture(Camera2Engine.this.mRepeatingRequestBuilder.build(), null, null);
                    }
                    catch (CameraAccessException e) {
                        throw Camera2Engine.this.createCameraException(e);
                    }
                    Camera2Engine.this.mFlash = flash;
                    Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                } else if (shouldApply) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
            }
        });
    }

    protected boolean applyFlash(@NonNull CaptureRequest.Builder builder, @NonNull Flash oldFlash) {
        if (this.mCameraOptions.supports(this.mFlash)) {
            int[] availableAeModesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES, new int[0]);
            ArrayList<Integer> availableAeModes = new ArrayList<Integer>();
            for (int mode : availableAeModesArray) {
                availableAeModes.add(mode);
            }
            List<Pair<Integer, Integer>> pairs = this.mMapper.mapFlash(this.mFlash);
            for (Pair<Integer, Integer> pair : pairs) {
                if (!availableAeModes.contains(pair.first)) continue;
                LOG.i("applyFlash: setting CONTROL_AE_MODE to", pair.first);
                LOG.i("applyFlash: setting FLASH_MODE to", pair.second);
                builder.set(CaptureRequest.CONTROL_AE_MODE, pair.first);
                builder.set(CaptureRequest.FLASH_MODE, pair.second);
                return true;
            }
        }
        this.mFlash = oldFlash;
        return false;
    }

    @Override
    public void setLocation(@Nullable Location location) {
        final Location old = this.mLocation;
        this.mLocation = location;
        this.mLocationTask = this.getOrchestrator().scheduleStateful("location", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyLocation(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
            }
        });
    }

    protected boolean applyLocation(@NonNull CaptureRequest.Builder builder, @Nullable Location oldLocation) {
        if (this.mLocation != null) {
            builder.set(CaptureRequest.JPEG_GPS_LOCATION, (Object)this.mLocation);
        }
        return true;
    }

    @Override
    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        final WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        this.mWhiteBalanceTask = this.getOrchestrator().scheduleStateful("white balance (" + whiteBalance + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyWhiteBalance(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
            }
        });
    }

    protected boolean applyWhiteBalance(@NonNull CaptureRequest.Builder builder, @NonNull WhiteBalance oldWhiteBalance) {
        if (this.mCameraOptions.supports(this.mWhiteBalance)) {
            int whiteBalance = this.mMapper.mapWhiteBalance(this.mWhiteBalance);
            builder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)whiteBalance);
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    @Override
    public void setHdr(@NonNull Hdr hdr) {
        final Hdr old = this.mHdr;
        this.mHdr = hdr;
        this.mHdrTask = this.getOrchestrator().scheduleStateful("hdr (" + hdr + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyHdr(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
            }
        });
    }

    protected boolean applyHdr(@NonNull CaptureRequest.Builder builder, @NonNull Hdr oldHdr) {
        if (this.mCameraOptions.supports(this.mHdr)) {
            int hdr = this.mMapper.mapHdr(this.mHdr);
            builder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)hdr);
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @Override
    public void setZoom(final float zoom, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mZoomValue;
        this.mZoomValue = zoom;
        this.mZoomTask = this.getOrchestrator().scheduleStateful("zoom (" + zoom + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyZoom(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                    if (notify) {
                        Camera2Engine.this.getCallback().dispatchOnZoomChanged(zoom, points);
                    }
                }
            }
        });
    }

    protected boolean applyZoom(@NonNull CaptureRequest.Builder builder, float oldZoom) {
        if (this.mCameraOptions.isZoomSupported()) {
            float maxZoom = this.readCharacteristic(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM, Float.valueOf(1.0f)).floatValue();
            float calculatedZoom = this.mZoomValue * (maxZoom - 1.0f) + 1.0f;
            Rect newRect = this.getZoomRect(calculatedZoom, maxZoom);
            builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)newRect);
            return true;
        }
        this.mZoomValue = oldZoom;
        return false;
    }

    @NonNull
    private Rect getZoomRect(float zoomLevel, float maxDigitalZoom) {
        Rect activeRect = this.readCharacteristic(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE, new Rect());
        int minW = (int)((float)activeRect.width() / maxDigitalZoom);
        int minH = (int)((float)activeRect.height() / maxDigitalZoom);
        int difW = activeRect.width() - minW;
        int difH = activeRect.height() - minH;
        int cropW = (int)((float)difW * (zoomLevel - 1.0f) / (maxDigitalZoom - 1.0f) / 2.0f);
        int cropH = (int)((float)difH * (zoomLevel - 1.0f) / (maxDigitalZoom - 1.0f) / 2.0f);
        return new Rect(cropW, cropH, activeRect.width() - cropW, activeRect.height() - cropH);
    }

    @Override
    public void setExposureCorrection(final float EVvalue, final @NonNull float[] bounds, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mExposureCorrectionValue;
        this.mExposureCorrectionValue = EVvalue;
        this.mExposureCorrectionTask = this.getOrchestrator().scheduleStateful("exposure correction (" + EVvalue + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyExposureCorrection(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                    if (notify) {
                        Camera2Engine.this.getCallback().dispatchOnExposureCorrectionChanged(EVvalue, bounds, points);
                    }
                }
            }
        });
    }

    protected boolean applyExposureCorrection(@NonNull CaptureRequest.Builder builder, float oldEVvalue) {
        if (this.mCameraOptions.isExposureCorrectionSupported()) {
            Rational exposureCorrectionStep = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP, new Rational(1, 1));
            int exposureCorrectionSteps = Math.round(this.mExposureCorrectionValue * exposureCorrectionStep.floatValue());
            builder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)exposureCorrectionSteps);
            return true;
        }
        this.mExposureCorrectionValue = oldEVvalue;
        return false;
    }

    @Override
    public void setPlaySounds(boolean playSounds) {
        this.mPlaySounds = playSounds;
        this.mPlaySoundsTask = Tasks.forResult(null);
    }

    @Override
    public void setPreviewFrameRate(float previewFrameRate) {
        final float oldPreviewFrameRate = this.mPreviewFrameRate;
        this.mPreviewFrameRate = previewFrameRate;
        this.mPreviewFrameRateTask = this.getOrchestrator().scheduleStateful("preview fps (" + previewFrameRate + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.applyPreviewFrameRate(Camera2Engine.this.mRepeatingRequestBuilder, oldPreviewFrameRate)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
            }
        });
    }

    protected boolean applyPreviewFrameRate(@NonNull CaptureRequest.Builder builder, float oldPreviewFrameRate) {
        Range[] fallback = new Range[]{};
        Range[] fpsRanges = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES, fallback);
        this.sortRanges(fpsRanges);
        if (this.mPreviewFrameRate == 0.0f) {
            for (Range fpsRange : fpsRanges) {
                if (!fpsRange.contains((Comparable)Integer.valueOf(30)) && !fpsRange.contains((Comparable)Integer.valueOf(24))) continue;
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)fpsRange);
                return true;
            }
        } else {
            this.mPreviewFrameRate = Math.min(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMaxValue());
            this.mPreviewFrameRate = Math.max(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMinValue());
            for (Range fpsRange : fpsRanges) {
                if (!fpsRange.contains((Comparable)Integer.valueOf(Math.round(this.mPreviewFrameRate)))) continue;
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)fpsRange);
                return true;
            }
        }
        this.mPreviewFrameRate = oldPreviewFrameRate;
        return false;
    }

    private void sortRanges(Range<Integer>[] fpsRanges) {
        if (this.getPreviewFrameRateExact() && this.mPreviewFrameRate != 0.0f) {
            Arrays.sort(fpsRanges, new Comparator<Range<Integer>>(){

                @Override
                public int compare(Range<Integer> range1, Range<Integer> range2) {
                    return (Integer)range1.getUpper() - (Integer)range1.getLower() - ((Integer)range2.getUpper() - (Integer)range2.getLower());
                }
            });
        } else {
            Arrays.sort(fpsRanges, new Comparator<Range<Integer>>(){

                @Override
                public int compare(Range<Integer> range1, Range<Integer> range2) {
                    return (Integer)range2.getUpper() - (Integer)range2.getLower() - ((Integer)range1.getUpper() - (Integer)range1.getLower());
                }
            });
        }
    }

    @Override
    public void setPictureFormat(@NonNull PictureFormat pictureFormat) {
        if (pictureFormat != this.mPictureFormat) {
            this.mPictureFormat = pictureFormat;
            this.getOrchestrator().scheduleStateful("picture format (" + pictureFormat + ")", CameraState.ENGINE, new Runnable(){

                @Override
                public void run() {
                    Camera2Engine.this.restart();
                }
            });
        }
    }

    @Override
    @NonNull
    protected FrameManager instantiateFrameManager(int poolSize) {
        return new ImageFrameManager(poolSize);
    }

    @EngineThread
    public void onImageAvailable(ImageReader reader) {
        LOG.v("onImageAvailable:", "trying to acquire Image.");
        Image image = null;
        try {
            image = reader.acquireLatestImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image == null) {
            LOG.w("onImageAvailable:", "failed to acquire Image!");
        } else if (this.getState() == CameraState.PREVIEW && !this.isChangingState()) {
            Frame frame = this.getFrameManager().getFrame(image, System.currentTimeMillis());
            if (frame != null) {
                LOG.v("onImageAvailable:", "Image acquired, dispatching.");
                this.getCallback().dispatchFrame(frame);
            } else {
                LOG.i("onImageAvailable:", "Image acquired, but no free frames. DROPPING.");
            }
        } else {
            LOG.i("onImageAvailable:", "Image acquired in wrong state. Closing it now.");
            image.close();
        }
    }

    @Override
    public void setHasFrameProcessors(final boolean hasFrameProcessors) {
        this.getOrchestrator().schedule("has frame processors (" + hasFrameProcessors + ")", true, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getState().isAtLeast(CameraState.BIND) && Camera2Engine.this.isChangingState()) {
                    Camera2Engine.this.setHasFrameProcessors(hasFrameProcessors);
                    return;
                }
                Camera2Engine.this.mHasFrameProcessors = hasFrameProcessors;
                if (Camera2Engine.this.getState().isAtLeast(CameraState.BIND)) {
                    Camera2Engine.this.restartBind();
                }
            }
        });
    }

    @Override
    public void setFrameProcessingFormat(final int format) {
        if (this.mFrameProcessingFormat == 0) {
            this.mFrameProcessingFormat = 35;
        }
        this.getOrchestrator().schedule("frame processing format (" + format + ")", true, new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getState().isAtLeast(CameraState.BIND) && Camera2Engine.this.isChangingState()) {
                    Camera2Engine.this.setFrameProcessingFormat(format);
                    return;
                }
                int n = Camera2Engine.this.mFrameProcessingFormat = format > 0 ? format : 35;
                if (Camera2Engine.this.getState().isAtLeast(CameraState.BIND)) {
                    Camera2Engine.this.restartBind();
                }
            }
        });
    }

    @Override
    public void startAutoFocus(final @Nullable Gesture gesture, final @NonNull MeteringRegions regions, final @NonNull PointF legacyPoint) {
        this.getOrchestrator().scheduleStateful("autofocus (" + (Object)((Object)gesture) + ")", CameraState.PREVIEW, new Runnable(){

            @Override
            public void run() {
                if (!Camera2Engine.this.mCameraOptions.isAutoFocusSupported()) {
                    return;
                }
                Camera2Engine.this.getCallback().dispatchOnFocusStart(gesture, legacyPoint);
                final MeterAction action = Camera2Engine.this.createMeterAction(regions);
                BaseAction wrapper = Actions.timeout(5000L, action);
                wrapper.start(Camera2Engine.this);
                wrapper.addCallback(new CompletionCallback(){

                    @Override
                    protected void onActionCompleted(@NonNull Action a) {
                        Camera2Engine.this.getCallback().dispatchOnFocusEnd(gesture, action.isSuccessful(), legacyPoint);
                        Camera2Engine.this.getOrchestrator().remove("reset metering");
                        if (Camera2Engine.this.shouldResetAutoFocus()) {
                            Camera2Engine.this.getOrchestrator().scheduleStatefulDelayed("reset metering", CameraState.PREVIEW, Camera2Engine.this.getAutoFocusResetDelay(), new Runnable(){

                                @Override
                                public void run() {
                                    Camera2Engine.this.unlockAndResetMetering();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    @NonNull
    private MeterAction createMeterAction(@Nullable MeteringRegions regions) {
        if (this.mMeterAction != null) {
            this.mMeterAction.abort(this);
        }
        this.applyFocusForMetering(this.mRepeatingRequestBuilder);
        this.mMeterAction = new MeterAction(this, regions, regions == null);
        return this.mMeterAction;
    }

    @EngineThread
    private void unlockAndResetMetering() {
        Actions.sequence(new BaseAction(){

            @Override
            protected void onStart(@NonNull ActionHolder holder) {
                super.onStart(holder);
                Camera2Engine.this.applyDefaultFocus(holder.getBuilder(this));
                holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                holder.getBuilder(this).set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
                holder.applyBuilder(this);
                this.setState(Integer.MAX_VALUE);
            }
        }, new MeterResetAction()).start(this);
    }

    @Override
    public void addAction(@NonNull Action action) {
        if (!this.mActions.contains(action)) {
            this.mActions.add(action);
        }
    }

    @Override
    public void removeAction(@NonNull Action action) {
        this.mActions.remove(action);
    }

    @Override
    @NonNull
    public CameraCharacteristics getCharacteristics(@NonNull Action action) {
        return this.mCameraCharacteristics;
    }

    @Override
    @Nullable
    public TotalCaptureResult getLastResult(@NonNull Action action) {
        return this.mLastRepeatingResult;
    }

    @Override
    @NonNull
    public CaptureRequest.Builder getBuilder(@NonNull Action action) {
        return this.mRepeatingRequestBuilder;
    }

    @Override
    @EngineThread
    public void applyBuilder(@NonNull Action source) {
        this.applyRepeatingRequestBuilder();
    }

    @Override
    public void applyBuilder(@NonNull Action source, @NonNull CaptureRequest.Builder builder) throws CameraAccessException {
        if (this.getState() == CameraState.PREVIEW && !this.isChangingState()) {
            this.mSession.capture(builder.build(), this.mRepeatingRequestCallback, null);
        }
    }
}

