package com.talpa.translate.ocr

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import com.talpa.translate.ocr.text.CompatTextDrawer


/**
 * Create by chenjunsheng on 2020/8/3
 * 适配6.0以下版本，不加载so
 */
class PhotoAnalyzerCompat(context: Context) : IAnalyzer {

    private var mOriginBitmap: Bitmap? = null

    private val mTextDrawer = CompatTextDrawer(context)

    override fun getTextDrawer(): TextDrawer {
        return mTextDrawer
    }

    override fun initialize(bitmap: Bitmap) {
        mOriginBitmap = bitmap
    }

    override fun cleanUp() {
        //mOriginBitmap?.recycle()
        //mOriginBitmap = null
    }

    override fun postAnalyzeArea(rects: Array<Rect>): Bitmap? {
        return mOriginBitmap
    }
}