/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.activity;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.photo.translation.R;
import com.talpa.translate.activity.CameraActivityKt;
import com.talpa.translate.base.utils.StaticesEventKt;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.camera.CameraFragment;
import com.talpa.translate.dialog.DiskAlertDialog;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\b\u0010\u000f\u001a\u00020\nH\u0016J-\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/talpa/translate/activity/CameraActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/talpa/translate/dialog/DiskAlertDialog$Callback;", "()V", "checkEnv", "", "checkPermission", "context", "Landroid/content/Context;", "dealIntent", "", "handleIntent", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLackUsageConfirm", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "showNoticeDialog", "Companion", "translation_xiaomiRelease"})
public final class CameraActivity
extends AppCompatActivity
implements DiskAlertDialog.Callback {
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.checkPermission((Context)this)) {
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])CameraActivityKt.access$getPERMISSIONS_REQUIRED$p(), (int)100);
            return;
        }
        this.setContentView(R.layout.activity_camerax);
        this.dealIntent();
        if (!this.checkEnv()) {
            this.showNoticeDialog();
            return;
        }
        this.handleIntent();
    }

    private final boolean checkEnv() {
        return UtilsKt.getFreeSpace() >= (long)30720;
    }

    private final void handleIntent() {
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        if (StringsKt.equals$default((String)intent.getAction(), (String)"com.talpa.translate.CAMERA_PENDING", (boolean)false, (int)2, null)) {
            StaticesEventKt.logEvent("NT_notification_click", "opt", "3");
        }
    }

    @Override
    public void onLackUsageConfirm() {
        this.finish();
    }

    private final void showNoticeDialog() {
        DiskAlertDialog diskAlertDialog = new DiskAlertDialog();
        boolean bl = false;
        boolean bl2 = false;
        DiskAlertDialog it = diskAlertDialog;
        boolean bl3 = false;
        it.setCancelable(false);
        DiskAlertDialog dialog = diskAlertDialog;
        dialog.show(this.getSupportFragmentManager(), "DiskAlertDialog");
    }

    private final void dealIntent() {
        if (Build.VERSION.SDK_INT >= 29) {
            long screenshotId = this.getIntent().getLongExtra("screenshot_id", -1L);
            if (screenshotId != -1L) {
                CameraFragment f;
                Log.d((String)"cjslog", (String)("screen shot:" + screenshotId));
                Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.container);
                if (!(fragment instanceof CameraFragment)) {
                    fragment = null;
                }
                if ((f = (CameraFragment)fragment) != null) {
                    Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)screenshotId);
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"ContentUris.withAppended\u2026g()\n                    )");
                    Uri uri2 = uri;
                    f.setScreenShotMode(true);
                    f.setImageFromShot(uri2);
                }
            }
        } else {
            String screenshot = this.getIntent().getStringExtra("screenshot_path");
            if (!TextUtils.isEmpty((CharSequence)screenshot)) {
                CameraFragment f;
                Log.d((String)"cjslog", (String)("screen shot:" + screenshot));
                Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.container);
                if (!(fragment instanceof CameraFragment)) {
                    fragment = null;
                }
                if ((f = (CameraFragment)fragment) != null) {
                    Uri uri = null;
                    File file = new File(screenshot);
                    Log.d((String)"cjslog", (String)("file exsist:" + file.exists()));
                    if (Build.VERSION.SDK_INT >= 24) {
                        Uri uri3 = FileProvider.getUriForFile((Context)((Context)this), (String)(this.getPackageName() + ".fileProvider"), (File)file);
                        Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"FileProvider.getUriForFi\u2026                        )");
                        uri = uri3;
                    } else {
                        Uri uri4 = Uri.fromFile((File)file);
                        Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"Uri.fromFile(file)");
                        uri = uri4;
                    }
                    f.setScreenShotMode(true);
                    f.setImageFromShot(uri);
                }
            }
        }
    }

    private final boolean checkPermission(Context context) {
        boolean bl;
        block1: {
            String[] $this$all$iv = CameraActivityKt.access$getPERMISSIONS_REQUIRED$p();
            boolean $i$f$all = false;
            String[] stringArray = $this$all$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (ContextCompat.checkSelfPermission((Context)context, (String)it) == 0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 100: {
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                if (this.checkPermission(context)) {
                    this.setContentView(R.layout.activity_camerax);
                    this.dealIntent();
                    break;
                }
                this.finish();
                break;
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/talpa/translate/activity/CameraActivity$Companion;", "", "()V", "start", "", "context", "Landroid/app/Activity;", "requestCode", "", "Landroid/content/Context;", "screenShotPath", "", "id", "", "translation_xiaomiRelease"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final class Companion {
        public final void start(@NotNull Activity context, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent((Context)context, CameraActivity.class);
            context.startActivityForResult(intent, requestCode);
        }

        public final void start(@NotNull Context context, int requestCode, @NotNull String screenShotPath, long id2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)screenShotPath, (String)"screenShotPath");
            Intent intent = new Intent(context, CameraActivity.class);
            intent.putExtra("screenshot_path", screenShotPath);
            intent.putExtra("screenshot_id", id2);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

