/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video;

import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.VideoResult;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.VideoCodec;
import com.talpa.translate.camera.view.internal.DeviceEncoders;
import com.talpa.translate.camera.view.size.Size;
import com.talpa.translate.camera.view.video.VideoRecorder;

public abstract class FullVideoRecorder
extends VideoRecorder {
    private static final String TAG = FullVideoRecorder.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    protected MediaRecorder mMediaRecorder;
    private CamcorderProfile mProfile;
    private boolean mMediaRecorderPrepared;

    FullVideoRecorder(@Nullable VideoRecorder.VideoResultListener listener) {
        super(listener);
    }

    @NonNull
    protected abstract CamcorderProfile getCamcorderProfile(@NonNull VideoResult.Stub var1);

    protected abstract void applyVideoSource(@NonNull VideoResult.Stub var1, @NonNull MediaRecorder var2);

    protected final boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub) {
        if (this.mMediaRecorderPrepared) {
            return true;
        }
        return this.prepareMediaRecorder(stub, true);
    }

    private boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub, boolean applyEncodersConstraints) {
        boolean hasAudio;
        LOG.i("prepareMediaRecorder:", "Preparing on thread", Thread.currentThread());
        this.mMediaRecorder = new MediaRecorder();
        this.mProfile = this.getCamcorderProfile(stub);
        this.applyVideoSource(stub, this.mMediaRecorder);
        int audioChannels = 0;
        if (stub.audio == Audio.ON) {
            audioChannels = this.mProfile.audioChannels;
        } else if (stub.audio == Audio.MONO) {
            audioChannels = 1;
        } else if (stub.audio == Audio.STEREO) {
            audioChannels = 2;
        }
        boolean bl = hasAudio = audioChannels > 0;
        if (hasAudio) {
            this.mMediaRecorder.setAudioSource(0);
        }
        if (stub.videoCodec == VideoCodec.H_264) {
            this.mProfile.videoCodec = 2;
            this.mProfile.fileFormat = 2;
        } else if (stub.videoCodec == VideoCodec.H_263) {
            this.mProfile.videoCodec = 1;
            this.mProfile.fileFormat = 2;
        }
        this.mMediaRecorder.setOutputFormat(this.mProfile.fileFormat);
        if (stub.videoFrameRate <= 0) {
            stub.videoFrameRate = this.mProfile.videoFrameRate;
        }
        if (stub.videoBitRate <= 0) {
            stub.videoBitRate = this.mProfile.videoBitRate;
        }
        if (stub.audioBitRate <= 0 && hasAudio) {
            stub.audioBitRate = this.mProfile.audioBitRate;
        }
        if (applyEncodersConstraints) {
            boolean flip;
            String videoType;
            String audioType;
            switch (this.mProfile.audioCodec) {
                case 1: {
                    audioType = "audio/3gpp";
                    break;
                }
                case 2: {
                    audioType = "audio/amr-wb";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    audioType = "audio/mp4a-latm";
                    break;
                }
                case 6: {
                    audioType = "audio/vorbis";
                    break;
                }
                default: {
                    audioType = "audio/3gpp";
                }
            }
            switch (this.mProfile.videoCodec) {
                case 1: {
                    videoType = "video/3gpp";
                    break;
                }
                case 2: {
                    videoType = "video/avc";
                    break;
                }
                case 3: {
                    videoType = "video/mp4v-es";
                    break;
                }
                case 4: {
                    videoType = "video/x-vnd.on2.vp8";
                    break;
                }
                case 5: {
                    videoType = "video/hevc";
                    break;
                }
                default: {
                    videoType = "video/avc";
                }
            }
            boolean bl2 = flip = stub.rotation % 180 != 0;
            if (flip) {
                stub.size = stub.size.flip();
            }
            Size newVideoSize = null;
            int newVideoBitRate = 0;
            int newAudioBitRate = 0;
            int newVideoFrameRate = 0;
            int videoEncoderOffset = 0;
            int audioEncoderOffset = 0;
            boolean encodersFound = false;
            while (!encodersFound) {
                DeviceEncoders encoders;
                LOG.i("prepareMediaRecorder:", "Checking DeviceEncoders...", "videoOffset:", videoEncoderOffset, "audioOffset:", audioEncoderOffset);
                try {
                    encoders = new DeviceEncoders(0, videoType, audioType, videoEncoderOffset, audioEncoderOffset);
                }
                catch (RuntimeException e) {
                    LOG.w("prepareMediaRecorder:", "Could not respect encoders parameters.", "Trying again without checking encoders.");
                    return this.prepareMediaRecorder(stub, false);
                }
                try {
                    newVideoSize = encoders.getSupportedVideoSize(stub.size);
                    newVideoBitRate = encoders.getSupportedVideoBitRate(stub.videoBitRate);
                    newVideoFrameRate = encoders.getSupportedVideoFrameRate(newVideoSize, stub.videoFrameRate);
                    encoders.tryConfigureVideo(videoType, newVideoSize, newVideoFrameRate, newVideoBitRate);
                    if (hasAudio) {
                        newAudioBitRate = encoders.getSupportedAudioBitRate(stub.audioBitRate);
                        encoders.tryConfigureAudio(audioType, newAudioBitRate, this.mProfile.audioSampleRate, audioChannels);
                    }
                    encodersFound = true;
                }
                catch (DeviceEncoders.VideoException videoException) {
                    LOG.i("prepareMediaRecorder:", "Got VideoException:", videoException.getMessage());
                    ++videoEncoderOffset;
                }
                catch (DeviceEncoders.AudioException audioException) {
                    LOG.i("prepareMediaRecorder:", "Got AudioException:", audioException.getMessage());
                    ++audioEncoderOffset;
                }
            }
            stub.size = newVideoSize;
            stub.videoBitRate = newVideoBitRate;
            stub.audioBitRate = newAudioBitRate;
            stub.videoFrameRate = newVideoFrameRate;
            if (flip) {
                stub.size = stub.size.flip();
            }
        }
        boolean flip = stub.rotation % 180 != 0;
        this.mMediaRecorder.setVideoSize(flip ? stub.size.getHeight() : stub.size.getWidth(), flip ? stub.size.getWidth() : stub.size.getHeight());
        this.mMediaRecorder.setVideoFrameRate(stub.videoFrameRate);
        this.mMediaRecorder.setVideoEncoder(this.mProfile.videoCodec);
        this.mMediaRecorder.setVideoEncodingBitRate(stub.videoBitRate);
        if (hasAudio) {
            this.mMediaRecorder.setAudioChannels(audioChannels);
            this.mMediaRecorder.setAudioSamplingRate(this.mProfile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(this.mProfile.audioCodec);
            this.mMediaRecorder.setAudioEncodingBitRate(stub.audioBitRate);
        }
        if (stub.location != null) {
            this.mMediaRecorder.setLocation((float)stub.location.getLatitude(), (float)stub.location.getLongitude());
        }
        if (stub.file != null) {
            this.mMediaRecorder.setOutputFile(stub.file.getAbsolutePath());
        } else if (stub.fileDescriptor != null) {
            this.mMediaRecorder.setOutputFile(stub.fileDescriptor);
        } else {
            throw new IllegalStateException("file and fileDescriptor are both null.");
        }
        this.mMediaRecorder.setOrientationHint(stub.rotation);
        this.mMediaRecorder.setMaxFileSize(stub.maxSize <= 0L ? stub.maxSize : Math.round((double)stub.maxSize / 0.9));
        LOG.i("prepareMediaRecorder:", "Increased max size from", stub.maxSize, "to", Math.round((double)stub.maxSize / 0.9));
        this.mMediaRecorder.setMaxDuration(stub.maxDuration);
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                LOG.i("OnInfoListener:", "Received info", what, extra, "Thread: ", Thread.currentThread());
                boolean shouldStop = false;
                switch (what) {
                    case 800: {
                        FullVideoRecorder.this.mResult.endReason = 2;
                        shouldStop = true;
                        break;
                    }
                    case 801: 
                    case 802: {
                        FullVideoRecorder.this.mResult.endReason = 1;
                        shouldStop = true;
                    }
                }
                if (shouldStop) {
                    LOG.i("OnInfoListener:", "Stopping");
                    FullVideoRecorder.this.stop(false);
                }
            }
        });
        this.mMediaRecorder.setOnErrorListener(new MediaRecorder.OnErrorListener(){

            public void onError(MediaRecorder mr, int what, int extra) {
                LOG.e("OnErrorListener: got error", what, extra, ". Stopping.");
                FullVideoRecorder.this.mResult = null;
                FullVideoRecorder.this.mError = new RuntimeException("MediaRecorder error: " + what + " " + extra);
                LOG.i("OnErrorListener:", "Stopping");
                FullVideoRecorder.this.stop(false);
            }
        });
        try {
            this.mMediaRecorder.prepare();
            this.mMediaRecorderPrepared = true;
            this.mError = null;
            return true;
        }
        catch (Exception e) {
            LOG.w("prepareMediaRecorder:", "Error while preparing media recorder.", e);
            this.mMediaRecorderPrepared = false;
            this.mError = e;
            return false;
        }
    }

    @Override
    protected void onStart() {
        if (!this.prepareMediaRecorder(this.mResult)) {
            this.mResult = null;
            this.stop(false);
            return;
        }
        try {
            this.mMediaRecorder.start();
            this.dispatchVideoRecordingStart();
        }
        catch (Exception e) {
            LOG.w("start:", "Error while starting media recorder.", e);
            this.mResult = null;
            this.mError = e;
            this.stop(false);
        }
    }

    @Override
    protected void onStop(boolean isCameraShutdown) {
        block6: {
            if (this.mMediaRecorder != null) {
                block5: {
                    this.dispatchVideoRecordingEnd();
                    try {
                        LOG.i("stop:", "Stopping MediaRecorder...");
                        this.mMediaRecorder.stop();
                        LOG.i("stop:", "Stopped MediaRecorder.");
                    }
                    catch (Exception e) {
                        this.mResult = null;
                        if (this.mError != null) break block5;
                        LOG.w("stop:", "Error while closing media recorder.", e);
                        this.mError = e;
                    }
                }
                try {
                    LOG.i("stop:", "Releasing MediaRecorder...");
                    this.mMediaRecorder.release();
                    LOG.i("stop:", "Released MediaRecorder.");
                }
                catch (Exception e) {
                    this.mResult = null;
                    if (this.mError != null) break block6;
                    LOG.w("stop:", "Error while releasing media recorder.", e);
                    this.mError = e;
                }
            }
        }
        this.mProfile = null;
        this.mMediaRecorder = null;
        this.mMediaRecorderPrepared = false;
        this.dispatchResult();
    }
}

