/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.thirdpart.leptonica;

import android.graphics.Bitmap;
import androidx.annotation.IntRange;
import com.talpa.translate.ocr.thirdpart.leptonica.Pix;
import com.talpa.translate.ocr.thirdpart.leptonica.WriteFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JpegIO {
    public static final int DEFAULT_QUALITY = 85;
    public static final boolean DEFAULT_PROGRESSIVE = false;

    public static byte[] compressToJpeg(Pix pixs) {
        return JpegIO.compressToJpeg(pixs, 85, false);
    }

    public static byte[] compressToJpeg(Pix pixs, @IntRange(from=0L, to=100L) int quality, boolean progressive) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("Quality must be between 0 and 100 (inclusive)");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Bitmap bmp = WriteFile.writeBitmap(pixs);
        bmp.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)byteStream);
        bmp.recycle();
        byte[] encodedData = byteStream.toByteArray();
        try {
            byteStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return encodedData;
    }

    private static native byte[] nativeCompressToJpeg(long var0, int var2, boolean var3);

    static {
        System.loadLibrary("leptonica");
    }
}

