/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.record;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.talpa.translate.record.CaptureResult;
import com.talpa.translate.record.IRecordListener;

public interface IRecordService
extends IInterface {
    public void registerListener(IRecordListener var1) throws RemoteException;

    public CaptureResult captureFrameSync() throws RemoteException;

    public void destroyService() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRecordService {
        private static final String DESCRIPTOR = "com.talpa.translate.record.IRecordService";
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_captureFrameSync = 2;
        static final int TRANSACTION_destroyService = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRecordService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRecordService) {
                return (IRecordService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IRecordListener _arg0 = IRecordListener.Stub.asInterface(data.readStrongBinder());
                    this.registerListener(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    CaptureResult _result = this.captureFrameSync();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.destroyService();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRecordService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRecordService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRecordService {
            private IBinder mRemote;
            public static IRecordService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(IRecordListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerListener(listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureResult captureFrameSync() throws RemoteException {
                CaptureResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CaptureResult captureResult = Stub.getDefaultImpl().captureFrameSync();
                        return captureResult;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (CaptureResult)CaptureResult.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void destroyService() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().destroyService();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRecordService {
        @Override
        public void registerListener(IRecordListener listener) throws RemoteException {
        }

        @Override
        public CaptureResult captureFrameSync() throws RemoteException {
            return null;
        }

        @Override
        public void destroyService() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

