/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.location.Location;
import android.media.MediaActionSound;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.photo.translation.R;
import com.talpa.translate.camera.view.CameraException;
import com.talpa.translate.camera.view.CameraListener;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.CameraOptions;
import com.talpa.translate.camera.view.PictureResult;
import com.talpa.translate.camera.view.VideoResult;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Control;
import com.talpa.translate.camera.view.controls.ControlParser;
import com.talpa.translate.camera.view.controls.Engine;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Grid;
import com.talpa.translate.camera.view.controls.Hdr;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.controls.Preview;
import com.talpa.translate.camera.view.controls.VideoCodec;
import com.talpa.translate.camera.view.controls.WhiteBalance;
import com.talpa.translate.camera.view.engine.Camera1Engine;
import com.talpa.translate.camera.view.engine.Camera2Engine;
import com.talpa.translate.camera.view.engine.CameraEngine;
import com.talpa.translate.camera.view.engine.offset.Reference;
import com.talpa.translate.camera.view.engine.orchestrator.CameraState;
import com.talpa.translate.camera.view.filter.Filter;
import com.talpa.translate.camera.view.filter.FilterParser;
import com.talpa.translate.camera.view.filter.NoFilter;
import com.talpa.translate.camera.view.filter.OneParameterFilter;
import com.talpa.translate.camera.view.filter.TwoParameterFilter;
import com.talpa.translate.camera.view.frame.Frame;
import com.talpa.translate.camera.view.frame.FrameProcessor;
import com.talpa.translate.camera.view.gesture.Gesture;
import com.talpa.translate.camera.view.gesture.GestureAction;
import com.talpa.translate.camera.view.gesture.GestureFinder;
import com.talpa.translate.camera.view.gesture.GestureParser;
import com.talpa.translate.camera.view.gesture.PinchGestureFinder;
import com.talpa.translate.camera.view.gesture.ScrollGestureFinder;
import com.talpa.translate.camera.view.gesture.TapGestureFinder;
import com.talpa.translate.camera.view.internal.CropHelper;
import com.talpa.translate.camera.view.internal.GridLinesLayout;
import com.talpa.translate.camera.view.internal.OrientationHelper;
import com.talpa.translate.camera.view.markers.AutoFocusMarker;
import com.talpa.translate.camera.view.markers.AutoFocusTrigger;
import com.talpa.translate.camera.view.markers.MarkerLayout;
import com.talpa.translate.camera.view.markers.MarkerParser;
import com.talpa.translate.camera.view.metering.MeteringRegions;
import com.talpa.translate.camera.view.overlay.OverlayLayout;
import com.talpa.translate.camera.view.preview.CameraPreview;
import com.talpa.translate.camera.view.preview.FilterCameraPreview;
import com.talpa.translate.camera.view.preview.GlCameraPreview;
import com.talpa.translate.camera.view.preview.SurfaceCameraPreview;
import com.talpa.translate.camera.view.preview.TextureCameraPreview;
import com.talpa.translate.camera.view.size.AspectRatio;
import com.talpa.translate.camera.view.size.Size;
import com.talpa.translate.camera.view.size.SizeSelector;
import com.talpa.translate.camera.view.size.SizeSelectorParser;
import java.io.File;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CameraView
extends FrameLayout
implements LifecycleObserver {
    private static final String TAG = CameraView.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final int PERMISSION_REQUEST_CODE = 16;
    static final long DEFAULT_AUTOFOCUS_RESET_DELAY_MILLIS = 3000L;
    static final boolean DEFAULT_PLAY_SOUNDS = true;
    static final boolean DEFAULT_USE_DEVICE_ORIENTATION = true;
    static final boolean DEFAULT_PICTURE_METERING = true;
    static final boolean DEFAULT_PICTURE_SNAPSHOT_METERING = false;
    static final boolean DEFAULT_REQUEST_PERMISSIONS = true;
    static final int DEFAULT_FRAME_PROCESSING_POOL_SIZE = 2;
    static final int DEFAULT_FRAME_PROCESSING_EXECUTORS = 1;
    private boolean mPlaySounds;
    private boolean mUseDeviceOrientation;
    private boolean mRequestPermissions;
    private HashMap<Gesture, GestureAction> mGestureMap = new HashMap(4);
    private Preview mPreview;
    private Engine mEngine;
    private Filter mPendingFilter;
    private int mFrameProcessingExecutors;
    private Handler mUiHandler;
    private Executor mFrameProcessingExecutor;
    @VisibleForTesting
    CameraCallbacks mCameraCallbacks;
    private CameraPreview mCameraPreview;
    private OrientationHelper mOrientationHelper;
    private CameraEngine mCameraEngine;
    private Size mLastPreviewStreamSize;
    private MediaActionSound mSound;
    private AutoFocusMarker mAutoFocusMarker;
    @VisibleForTesting
    List<CameraListener> mListeners = new CopyOnWriteArrayList<CameraListener>();
    @VisibleForTesting
    List<FrameProcessor> mFrameProcessors = new CopyOnWriteArrayList<FrameProcessor>();
    private Lifecycle mLifecycle;
    @VisibleForTesting
    PinchGestureFinder mPinchGestureFinder;
    @VisibleForTesting
    TapGestureFinder mTapGestureFinder;
    @VisibleForTesting
    ScrollGestureFinder mScrollGestureFinder;
    @VisibleForTesting
    GridLinesLayout mGridLinesLayout;
    @VisibleForTesting
    MarkerLayout mMarkerLayout;
    private boolean mKeepScreenOn;
    private boolean mExperimental;
    private boolean mInEditor;
    @VisibleForTesting
    OverlayLayout mOverlayLayout;

    public CameraView(@NonNull Context context) {
        super(context, null);
        this.initialize(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    private void initialize(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.mInEditor = this.isInEditMode();
        if (this.mInEditor) {
            return;
        }
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CameraView, 0, 0);
        ControlParser controls = new ControlParser(context, a);
        boolean playSounds = a.getBoolean(R.styleable.CameraView_cameraPlaySounds, true);
        boolean useDeviceOrientation = a.getBoolean(R.styleable.CameraView_cameraUseDeviceOrientation, true);
        this.mExperimental = a.getBoolean(R.styleable.CameraView_cameraExperimental, false);
        this.mRequestPermissions = a.getBoolean(R.styleable.CameraView_cameraRequestPermissions, true);
        this.mPreview = controls.getPreview();
        this.mEngine = controls.getEngine();
        int gridColor = a.getColor(R.styleable.CameraView_cameraGridColor, GridLinesLayout.DEFAULT_COLOR);
        long videoMaxSize = (long)a.getFloat(R.styleable.CameraView_cameraVideoMaxSize, 0.0f);
        int videoMaxDuration = a.getInteger(R.styleable.CameraView_cameraVideoMaxDuration, 0);
        int videoBitRate = a.getInteger(R.styleable.CameraView_cameraVideoBitRate, 0);
        int audioBitRate = a.getInteger(R.styleable.CameraView_cameraAudioBitRate, 0);
        float videoFrameRate = a.getFloat(R.styleable.CameraView_cameraPreviewFrameRate, 0.0f);
        boolean videoFrameRateExact = a.getBoolean(R.styleable.CameraView_cameraPreviewFrameRateExact, false);
        long autoFocusResetDelay = a.getInteger(R.styleable.CameraView_cameraAutoFocusResetDelay, 3000);
        boolean pictureMetering = a.getBoolean(R.styleable.CameraView_cameraPictureMetering, true);
        boolean pictureSnapshotMetering = a.getBoolean(R.styleable.CameraView_cameraPictureSnapshotMetering, false);
        int snapshotMaxWidth = a.getInteger(R.styleable.CameraView_cameraSnapshotMaxWidth, 0);
        int snapshotMaxHeight = a.getInteger(R.styleable.CameraView_cameraSnapshotMaxHeight, 0);
        int frameMaxWidth = a.getInteger(R.styleable.CameraView_cameraFrameProcessingMaxWidth, 0);
        int frameMaxHeight = a.getInteger(R.styleable.CameraView_cameraFrameProcessingMaxHeight, 0);
        int frameFormat = a.getInteger(R.styleable.CameraView_cameraFrameProcessingFormat, 0);
        int framePoolSize = a.getInteger(R.styleable.CameraView_cameraFrameProcessingPoolSize, 2);
        int frameExecutors = a.getInteger(R.styleable.CameraView_cameraFrameProcessingExecutors, 1);
        SizeSelectorParser sizeSelectors = new SizeSelectorParser(a);
        GestureParser gestures = new GestureParser(a);
        MarkerParser markers = new MarkerParser(a);
        FilterParser filters = new FilterParser(a);
        a.recycle();
        this.mCameraCallbacks = new CameraCallbacks();
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mPinchGestureFinder = new PinchGestureFinder(this.mCameraCallbacks);
        this.mTapGestureFinder = new TapGestureFinder(this.mCameraCallbacks);
        this.mScrollGestureFinder = new ScrollGestureFinder(this.mCameraCallbacks);
        this.mGridLinesLayout = new GridLinesLayout(context);
        this.mOverlayLayout = new OverlayLayout(context);
        this.mMarkerLayout = new MarkerLayout(context);
        this.addView(this.mGridLinesLayout);
        this.addView((View)this.mMarkerLayout);
        this.addView((View)this.mOverlayLayout);
        this.doInstantiateEngine();
        this.setPlaySounds(playSounds);
        this.setUseDeviceOrientation(useDeviceOrientation);
        this.setGrid(controls.getGrid());
        this.setGridColor(gridColor);
        this.setFacing(controls.getFacing());
        this.setFlash(controls.getFlash());
        this.setMode(controls.getMode());
        this.setWhiteBalance(controls.getWhiteBalance());
        this.setHdr(controls.getHdr());
        this.setAudio(controls.getAudio());
        this.setAudioBitRate(audioBitRate);
        this.setPictureSize(sizeSelectors.getPictureSizeSelector());
        this.setPictureMetering(pictureMetering);
        this.setPictureSnapshotMetering(pictureSnapshotMetering);
        this.setPictureFormat(controls.getPictureFormat());
        this.setVideoSize(sizeSelectors.getVideoSizeSelector());
        this.setVideoCodec(controls.getVideoCodec());
        this.setVideoMaxSize(videoMaxSize);
        this.setVideoMaxDuration(videoMaxDuration);
        this.setVideoBitRate(videoBitRate);
        this.setAutoFocusResetDelay(autoFocusResetDelay);
        this.setPreviewFrameRateExact(videoFrameRateExact);
        this.setPreviewFrameRate(videoFrameRate);
        this.setSnapshotMaxWidth(snapshotMaxWidth);
        this.setSnapshotMaxHeight(snapshotMaxHeight);
        this.setFrameProcessingMaxWidth(frameMaxWidth);
        this.setFrameProcessingMaxHeight(frameMaxHeight);
        this.setFrameProcessingFormat(frameFormat);
        this.setFrameProcessingPoolSize(framePoolSize);
        this.setFrameProcessingExecutors(frameExecutors);
        this.mapGesture(Gesture.TAP, gestures.getTapAction());
        this.mapGesture(Gesture.LONG_TAP, gestures.getLongTapAction());
        this.mapGesture(Gesture.PINCH, gestures.getPinchAction());
        this.mapGesture(Gesture.SCROLL_HORIZONTAL, gestures.getHorizontalScrollAction());
        this.mapGesture(Gesture.SCROLL_VERTICAL, gestures.getVerticalScrollAction());
        this.setAutoFocusMarker(markers.getAutoFocusMarker());
        this.setFilter(filters.getFilter());
        this.mOrientationHelper = new OrientationHelper(context, this.mCameraCallbacks);
    }

    private void doInstantiateEngine() {
        LOG.w("doInstantiateEngine:", "instantiating. engine:", this.mEngine);
        this.mCameraEngine = this.instantiateCameraEngine(this.mEngine, this.mCameraCallbacks);
        LOG.w("doInstantiateEngine:", "instantiated. engine:", this.mCameraEngine.getClass().getSimpleName());
        this.mCameraEngine.setOverlay(this.mOverlayLayout);
    }

    @VisibleForTesting
    void doInstantiatePreview() {
        LOG.w("doInstantiateEngine:", "instantiating. preview:", this.mPreview);
        this.mCameraPreview = this.instantiatePreview(this.mPreview, this.getContext(), (ViewGroup)this);
        LOG.w("doInstantiateEngine:", "instantiated. preview:", this.mCameraPreview.getClass().getSimpleName());
        this.mCameraEngine.setPreview(this.mCameraPreview);
        if (this.mPendingFilter != null) {
            this.setFilter(this.mPendingFilter);
            this.mPendingFilter = null;
        }
    }

    @NonNull
    protected CameraEngine instantiateCameraEngine(@NonNull Engine engine, @NonNull CameraEngine.Callback callback) {
        if (this.mExperimental && engine == Engine.CAMERA2 && Build.VERSION.SDK_INT >= 21) {
            return new Camera2Engine(callback);
        }
        this.mEngine = Engine.CAMERA1;
        return new Camera1Engine(callback);
    }

    @NonNull
    protected CameraPreview instantiatePreview(@NonNull Preview preview, @NonNull Context context, @NonNull ViewGroup container) {
        switch (preview) {
            case SURFACE: {
                return new SurfaceCameraPreview(context, container);
            }
            case TEXTURE: {
                if (!this.isHardwareAccelerated()) break;
                return new TextureCameraPreview(context, container);
            }
        }
        this.mPreview = Preview.GL_SURFACE;
        return new GlCameraPreview(context, container);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mInEditor) {
            return;
        }
        if (this.mCameraPreview == null) {
            this.doInstantiatePreview();
        }
        this.mOrientationHelper.enable();
    }

    protected void onDetachedFromWindow() {
        if (!this.mInEditor) {
            this.mOrientationHelper.disable();
        }
        this.mLastPreviewStreamSize = null;
        super.onDetachedFromWindow();
    }

    private String ms(int mode) {
        switch (mode) {
            case -2147483648: {
                return "AT_MOST";
            }
            case 0x40000000: {
                return "EXACTLY";
            }
            case 0: {
                return "UNSPECIFIED";
            }
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        if (this.mInEditor) {
            int width2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height2 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height2, (int)0x40000000));
            return;
        }
        this.mLastPreviewStreamSize = this.mCameraEngine.getPreviewStreamSize(Reference.VIEW);
        if (this.mLastPreviewStreamSize == null) {
            LOG.w("onMeasure:", "surface is not ready. Calling default behavior.");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthValue = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightValue = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float previewWidth = this.mLastPreviewStreamSize.getWidth();
        float previewHeight = this.mLastPreviewStreamSize.getHeight();
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (!this.mCameraPreview.supportsCropping()) {
            if (widthMode == 0x40000000) {
                widthMode = Integer.MIN_VALUE;
            }
            if (heightMode == 0x40000000) {
                heightMode = Integer.MIN_VALUE;
            }
        } else {
            if (widthMode == Integer.MIN_VALUE && lp.width == -1) {
                widthMode = 0x40000000;
            }
            if (heightMode == Integer.MIN_VALUE && lp.height == -1) {
                heightMode = 0x40000000;
            }
        }
        LOG.i("onMeasure:", "requested dimensions are (" + widthValue + "[" + this.ms(widthMode) + "]x" + heightValue + "[" + this.ms(heightMode) + "])");
        LOG.i("onMeasure:", "previewSize is", "(" + previewWidth + "x" + previewHeight + ")");
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            LOG.i("onMeasure:", "both are MATCH_PARENT or fixed value. We adapt.", "This means CROP_CENTER.", "(" + widthValue + "x" + heightValue + ")");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (widthMode == 0 && heightMode == 0) {
            LOG.i("onMeasure:", "both are completely free.", "We respect that and extend to the whole preview size.", "(" + previewWidth + "x" + previewHeight + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)((int)previewWidth), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)previewHeight), (int)0x40000000));
            return;
        }
        float ratio = previewHeight / previewWidth;
        if (widthMode == 0 || heightMode == 0) {
            int width3;
            int height3;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == 0;
            if (freeWidth) {
                height3 = heightValue;
                width3 = Math.round((float)height3 / ratio);
            } else {
                width3 = widthValue;
                height3 = Math.round((float)width3 * ratio);
            }
            LOG.i("onMeasure:", "one dimension was free, we adapted it to fit the ratio.", "(" + width3 + "x" + height3 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height3, (int)0x40000000));
            return;
        }
        if (widthMode == 0x40000000 || heightMode == 0x40000000) {
            int width4;
            int height4;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == Integer.MIN_VALUE;
            if (freeWidth) {
                height4 = heightValue;
                width4 = Math.min(Math.round((float)height4 / ratio), widthValue);
            } else {
                width4 = widthValue;
                height4 = Math.min(Math.round((float)width4 * ratio), heightValue);
            }
            LOG.i("onMeasure:", "one dimension was EXACTLY, another AT_MOST.", "We have TRIED to fit the aspect ratio, but it's not guaranteed.", "(" + width4 + "x" + height4 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width4, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height4, (int)0x40000000));
            return;
        }
        float atMostRatio = (float)heightValue / (float)widthValue;
        if (atMostRatio >= ratio) {
            width = widthValue;
            height = Math.round((float)width * ratio);
        } else {
            height = heightValue;
            width = Math.round((float)height / ratio);
        }
        LOG.i("onMeasure:", "both dimension were AT_MOST.", "We fit the preview aspect ratio.", "(" + width + "x" + height + ")");
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public boolean mapGesture(@NonNull Gesture gesture, @NonNull GestureAction action) {
        GestureAction none = GestureAction.NONE;
        if (gesture.isAssignableTo(action)) {
            this.mGestureMap.put(gesture, action);
            switch (gesture) {
                case PINCH: {
                    this.mPinchGestureFinder.setActive(this.mGestureMap.get((Object)Gesture.PINCH) != none);
                    break;
                }
                case TAP: 
                case LONG_TAP: {
                    this.mTapGestureFinder.setActive(this.mGestureMap.get((Object)Gesture.TAP) != none || this.mGestureMap.get((Object)Gesture.LONG_TAP) != none);
                    break;
                }
                case SCROLL_HORIZONTAL: 
                case SCROLL_VERTICAL: {
                    this.mScrollGestureFinder.setActive(this.mGestureMap.get((Object)Gesture.SCROLL_HORIZONTAL) != none || this.mGestureMap.get((Object)Gesture.SCROLL_VERTICAL) != none);
                }
            }
            return true;
        }
        this.mapGesture(gesture, none);
        return false;
    }

    public void clearGesture(@NonNull Gesture gesture) {
        this.mapGesture(gesture, GestureAction.NONE);
    }

    @NonNull
    public GestureAction getGestureAction(@NonNull Gesture gesture) {
        return this.mGestureMap.get((Object)gesture);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isOpened()) {
            return true;
        }
        if (ActivityManager.isUserAMonkey()) {
            return true;
        }
        CameraOptions options = this.mCameraEngine.getCameraOptions();
        if (options == null) {
            return true;
        }
        if (this.mPinchGestureFinder.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "pinch!");
            this.onGesture(this.mPinchGestureFinder, options);
        } else if (this.mScrollGestureFinder.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "scroll!");
            this.onGesture(this.mScrollGestureFinder, options);
        } else if (this.mTapGestureFinder.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "tap!");
            this.onGesture(this.mTapGestureFinder, options);
        }
        return true;
    }

    private void onGesture(@NonNull GestureFinder source, @NonNull CameraOptions options) {
        Gesture gesture = source.getGesture();
        GestureAction action = this.mGestureMap.get((Object)gesture);
        PointF[] points = source.getPoints();
        switch (action) {
            case TAKE_PICTURE: {
                this.takePicture();
                break;
            }
            case AUTO_FOCUS: {
                Size size = new Size(this.getWidth(), this.getHeight());
                MeteringRegions regions = MeteringRegions.fromPoint(size, points[0]);
                this.mCameraEngine.startAutoFocus(gesture, regions, points[0]);
                break;
            }
            case ZOOM: {
                float oldValue = this.mCameraEngine.getZoomValue();
                float newValue = source.computeValue(oldValue, 0.0f, 1.0f);
                if (newValue == oldValue) break;
                this.mCameraEngine.setZoom(newValue, points, true);
                break;
            }
            case EXPOSURE_CORRECTION: {
                float oldValue = this.mCameraEngine.getExposureCorrectionValue();
                float minValue = options.getExposureCorrectionMinValue();
                float maxValue = options.getExposureCorrectionMaxValue();
                float newValue = source.computeValue(oldValue, minValue, maxValue);
                if (newValue == oldValue) break;
                float[] bounds = new float[]{minValue, maxValue};
                this.mCameraEngine.setExposureCorrection(newValue, bounds, points, true);
                break;
            }
            case FILTER_CONTROL_1: {
                OneParameterFilter filter;
                float oldValue;
                float newValue;
                if (!(this.getFilter() instanceof OneParameterFilter) || (newValue = source.computeValue(oldValue = (filter = (OneParameterFilter)this.getFilter()).getParameter1(), 0.0f, 1.0f)) == oldValue) break;
                filter.setParameter1(newValue);
                break;
            }
            case FILTER_CONTROL_2: {
                TwoParameterFilter filter;
                float oldValue;
                float newValue;
                if (!(this.getFilter() instanceof TwoParameterFilter) || (newValue = source.computeValue(oldValue = (filter = (TwoParameterFilter)this.getFilter()).getParameter2(), 0.0f, 1.0f)) == oldValue) break;
                filter.setParameter2(newValue);
            }
        }
    }

    public void setRequestPermissions(boolean requestPermissions) {
        this.mRequestPermissions = requestPermissions;
    }

    public boolean isOpened() {
        return this.mCameraEngine.getState().isAtLeast(CameraState.ENGINE) && this.mCameraEngine.getTargetState().isAtLeast(CameraState.ENGINE);
    }

    private boolean isClosed() {
        return this.mCameraEngine.getState() == CameraState.OFF && !this.mCameraEngine.isChangingState();
    }

    public void setLifecycleOwner(@Nullable LifecycleOwner owner) {
        if (owner == null) {
            this.clearLifecycleObserver();
        } else {
            this.clearLifecycleObserver();
            this.mLifecycle = owner.getLifecycle();
            this.mLifecycle.addObserver((LifecycleObserver)this);
        }
    }

    private void clearLifecycleObserver() {
        if (this.mLifecycle != null) {
            this.mLifecycle.removeObserver((LifecycleObserver)this);
            this.mLifecycle = null;
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void open() {
        if (this.mInEditor) {
            return;
        }
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onResume();
        }
        if (this.checkPermissions(this.getAudio())) {
            this.mOrientationHelper.enable();
            this.mCameraEngine.getAngles().setDisplayOffset(this.mOrientationHelper.getLastDisplayOffset());
            this.mCameraEngine.start();
        }
    }

    @SuppressLint(value={"NewApi"})
    protected boolean checkPermissions(@NonNull Audio audio) {
        this.checkPermissionsManifestOrThrow(audio);
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        Context c = this.getContext();
        boolean needsCamera = true;
        boolean needsAudio = audio == Audio.ON || audio == Audio.MONO || audio == Audio.STEREO;
        needsCamera = needsCamera && c.checkSelfPermission("android.permission.CAMERA") != 0;
        boolean bl = needsAudio = needsAudio && c.checkSelfPermission("android.permission.RECORD_AUDIO") != 0;
        if (!needsCamera && !needsAudio) {
            return true;
        }
        if (this.mRequestPermissions) {
            this.requestPermissions(needsCamera, needsAudio);
            return false;
        }
        return false;
    }

    private void checkPermissionsManifestOrThrow(@NonNull Audio audio) {
        if (audio == Audio.ON || audio == Audio.MONO || audio == Audio.STEREO) {
            try {
                PackageManager manager = this.getContext().getPackageManager();
                PackageInfo info = manager.getPackageInfo(this.getContext().getPackageName(), 4096);
                for (String requestedPermission : info.requestedPermissions) {
                    if (!requestedPermission.equals("android.permission.RECORD_AUDIO")) continue;
                    return;
                }
                String message = LOG.e("Permission error: when audio is enabled (Audio.ON) the RECORD_AUDIO permission should be added to the app manifest file.");
                throw new IllegalStateException(message);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void close() {
        if (this.mInEditor) {
            return;
        }
        this.mCameraEngine.stop(false);
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onPause();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void destroy() {
        if (this.mInEditor) {
            return;
        }
        this.clearCameraListeners();
        this.clearFrameProcessors();
        this.mCameraEngine.destroy(true);
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onDestroy();
        }
    }

    public void setExperimental(boolean experimental) {
        this.mExperimental = experimental;
    }

    public void set(@NonNull Control control) {
        if (control instanceof Audio) {
            this.setAudio((Audio)control);
        } else if (control instanceof Facing) {
            this.setFacing((Facing)control);
        } else if (control instanceof Flash) {
            this.setFlash((Flash)control);
        } else if (control instanceof Grid) {
            this.setGrid((Grid)control);
        } else if (control instanceof Hdr) {
            this.setHdr((Hdr)control);
        } else if (control instanceof Mode) {
            this.setMode((Mode)control);
        } else if (control instanceof WhiteBalance) {
            this.setWhiteBalance((WhiteBalance)control);
        } else if (control instanceof VideoCodec) {
            this.setVideoCodec((VideoCodec)control);
        } else if (control instanceof Preview) {
            this.setPreview((Preview)control);
        } else if (control instanceof Engine) {
            this.setEngine((Engine)control);
        } else if (control instanceof PictureFormat) {
            this.setPictureFormat((PictureFormat)control);
        }
    }

    @NonNull
    public <T extends Control> T get(@NonNull Class<T> controlClass) {
        if (controlClass == Audio.class) {
            return (T)this.getAudio();
        }
        if (controlClass == Facing.class) {
            return (T)this.getFacing();
        }
        if (controlClass == Flash.class) {
            return (T)this.getFlash();
        }
        if (controlClass == Grid.class) {
            return (T)this.getGrid();
        }
        if (controlClass == Hdr.class) {
            return (T)this.getHdr();
        }
        if (controlClass == Mode.class) {
            return (T)this.getMode();
        }
        if (controlClass == WhiteBalance.class) {
            return (T)this.getWhiteBalance();
        }
        if (controlClass == VideoCodec.class) {
            return (T)this.getVideoCodec();
        }
        if (controlClass == Preview.class) {
            return (T)this.getPreview();
        }
        if (controlClass == Engine.class) {
            return (T)this.getEngine();
        }
        if (controlClass == PictureFormat.class) {
            return (T)this.getPictureFormat();
        }
        throw new IllegalArgumentException("Unknown control class: " + controlClass);
    }

    public void setPreview(@NonNull Preview preview) {
        boolean isNew;
        boolean bl = isNew = preview != this.mPreview;
        if (isNew) {
            boolean isAttachedToWindow;
            this.mPreview = preview;
            boolean bl2 = isAttachedToWindow = this.getWindowToken() != null;
            if (!isAttachedToWindow && this.mCameraPreview != null) {
                this.mCameraPreview.onDestroy();
                this.mCameraPreview = null;
            }
        }
    }

    @NonNull
    public Preview getPreview() {
        return this.mPreview;
    }

    public void setEngine(@NonNull Engine engine) {
        if (!this.isClosed()) {
            return;
        }
        this.mEngine = engine;
        CameraEngine oldEngine = this.mCameraEngine;
        this.doInstantiateEngine();
        if (this.mCameraPreview != null) {
            this.mCameraEngine.setPreview(this.mCameraPreview);
        }
        this.setFacing(oldEngine.getFacing());
        this.setFlash(oldEngine.getFlash());
        this.setMode(oldEngine.getMode());
        this.setWhiteBalance(oldEngine.getWhiteBalance());
        this.setHdr(oldEngine.getHdr());
        this.setAudio(oldEngine.getAudio());
        this.setAudioBitRate(oldEngine.getAudioBitRate());
        this.setPictureSize(oldEngine.getPictureSizeSelector());
        this.setPictureFormat(oldEngine.getPictureFormat());
        this.setVideoSize(oldEngine.getVideoSizeSelector());
        this.setVideoCodec(oldEngine.getVideoCodec());
        this.setVideoMaxSize(oldEngine.getVideoMaxSize());
        this.setVideoMaxDuration(oldEngine.getVideoMaxDuration());
        this.setVideoBitRate(oldEngine.getVideoBitRate());
        this.setAutoFocusResetDelay(oldEngine.getAutoFocusResetDelay());
        this.setPreviewFrameRate(oldEngine.getPreviewFrameRate());
        this.setPreviewFrameRateExact(oldEngine.getPreviewFrameRateExact());
        this.setSnapshotMaxWidth(oldEngine.getSnapshotMaxWidth());
        this.setSnapshotMaxHeight(oldEngine.getSnapshotMaxHeight());
        this.setFrameProcessingMaxWidth(oldEngine.getFrameProcessingMaxWidth());
        this.setFrameProcessingMaxHeight(oldEngine.getFrameProcessingMaxHeight());
        this.setFrameProcessingFormat(0);
        this.setFrameProcessingPoolSize(oldEngine.getFrameProcessingPoolSize());
        this.mCameraEngine.setHasFrameProcessors(!this.mFrameProcessors.isEmpty());
    }

    @NonNull
    public Engine getEngine() {
        return this.mEngine;
    }

    @Nullable
    public CameraOptions getCameraOptions() {
        return this.mCameraEngine.getCameraOptions();
    }

    public void setExposureCorrection(float EVvalue) {
        CameraOptions options = this.getCameraOptions();
        if (options != null) {
            float min = options.getExposureCorrectionMinValue();
            float max = options.getExposureCorrectionMaxValue();
            if (EVvalue < min) {
                EVvalue = min;
            }
            if (EVvalue > max) {
                EVvalue = max;
            }
            float[] bounds = new float[]{min, max};
            this.mCameraEngine.setExposureCorrection(EVvalue, bounds, null, false);
        }
    }

    public float getExposureCorrection() {
        return this.mCameraEngine.getExposureCorrectionValue();
    }

    public void setZoom(float zoom) {
        if (zoom < 0.0f) {
            zoom = 0.0f;
        }
        if (zoom > 1.0f) {
            zoom = 1.0f;
        }
        this.mCameraEngine.setZoom(zoom, null, false);
    }

    public float getZoom() {
        return this.mCameraEngine.getZoomValue();
    }

    public void setGrid(@NonNull Grid gridMode) {
        this.mGridLinesLayout.setGridMode(gridMode);
    }

    @NonNull
    public Grid getGrid() {
        return this.mGridLinesLayout.getGridMode();
    }

    public void setGridColor(@ColorInt int color2) {
        this.mGridLinesLayout.setGridColor(color2);
    }

    public int getGridColor() {
        return this.mGridLinesLayout.getGridColor();
    }

    public void setHdr(@NonNull Hdr hdr) {
        this.mCameraEngine.setHdr(hdr);
    }

    @NonNull
    public Hdr getHdr() {
        return this.mCameraEngine.getHdr();
    }

    public void setLocation(double latitude, double longitude) {
        Location location = new Location("Unknown");
        location.setTime(System.currentTimeMillis());
        location.setAltitude(0.0);
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        this.mCameraEngine.setLocation(location);
    }

    public void setLocation(@Nullable Location location) {
        this.mCameraEngine.setLocation(location);
    }

    @Nullable
    public Location getLocation() {
        return this.mCameraEngine.getLocation();
    }

    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        this.mCameraEngine.setWhiteBalance(whiteBalance);
    }

    @NonNull
    public WhiteBalance getWhiteBalance() {
        return this.mCameraEngine.getWhiteBalance();
    }

    public void setFacing(@NonNull Facing facing) {
        this.mCameraEngine.setFacing(facing);
    }

    @NonNull
    public Facing getFacing() {
        return this.mCameraEngine.getFacing();
    }

    public Facing toggleFacing() {
        Facing facing = this.mCameraEngine.getFacing();
        switch (facing) {
            case BACK: {
                this.setFacing(Facing.FRONT);
                break;
            }
            case FRONT: {
                this.setFacing(Facing.BACK);
            }
        }
        return this.mCameraEngine.getFacing();
    }

    public void setFlash(@NonNull Flash flash) {
        this.mCameraEngine.setFlash(flash);
    }

    @NonNull
    public Flash getFlash() {
        return this.mCameraEngine.getFlash();
    }

    public void setAudio(@NonNull Audio audio) {
        if (audio == this.getAudio() || this.isClosed()) {
            this.mCameraEngine.setAudio(audio);
        } else if (this.checkPermissions(audio)) {
            this.mCameraEngine.setAudio(audio);
        } else {
            this.close();
        }
    }

    @NonNull
    public Audio getAudio() {
        return this.mCameraEngine.getAudio();
    }

    public void setAutoFocusMarker(@Nullable AutoFocusMarker autoFocusMarker) {
        this.mAutoFocusMarker = autoFocusMarker;
        this.mMarkerLayout.onMarker(1, autoFocusMarker);
    }

    public void setAutoFocusResetDelay(long delayMillis) {
        this.mCameraEngine.setAutoFocusResetDelay(delayMillis);
    }

    public long getAutoFocusResetDelay() {
        return this.mCameraEngine.getAutoFocusResetDelay();
    }

    public void startAutoFocus(float x, float y) {
        if (x < 0.0f || x > (float)this.getWidth()) {
            throw new IllegalArgumentException("x should be >= 0 and <= getWidth()");
        }
        if (y < 0.0f || y > (float)this.getHeight()) {
            throw new IllegalArgumentException("y should be >= 0 and <= getHeight()");
        }
        Size size = new Size(this.getWidth(), this.getHeight());
        PointF point = new PointF(x, y);
        MeteringRegions regions = MeteringRegions.fromPoint(size, point);
        this.mCameraEngine.startAutoFocus(null, regions, point);
    }

    public void startAutoFocus(@NonNull RectF region) {
        RectF full = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        if (!full.contains(region)) {
            throw new IllegalArgumentException("Region is out of view bounds! " + region);
        }
        Size size = new Size(this.getWidth(), this.getHeight());
        MeteringRegions regions = MeteringRegions.fromArea(size, region);
        this.mCameraEngine.startAutoFocus(null, regions, new PointF(region.centerX(), region.centerY()));
    }

    public void setPreviewStreamSize(@NonNull SizeSelector selector) {
        this.mCameraEngine.setPreviewStreamSizeSelector(selector);
    }

    public void setMode(@NonNull Mode mode) {
        this.mCameraEngine.setMode(mode);
    }

    @NonNull
    public Mode getMode() {
        return this.mCameraEngine.getMode();
    }

    public void setPictureSize(@NonNull SizeSelector selector) {
        this.mCameraEngine.setPictureSizeSelector(selector);
    }

    public void setPictureMetering(boolean enable) {
        this.mCameraEngine.setPictureMetering(enable);
    }

    public boolean getPictureMetering() {
        return this.mCameraEngine.getPictureMetering();
    }

    public void setPictureSnapshotMetering(boolean enable) {
        this.mCameraEngine.setPictureSnapshotMetering(enable);
    }

    public boolean getPictureSnapshotMetering() {
        return this.mCameraEngine.getPictureSnapshotMetering();
    }

    public void setPictureFormat(@NonNull PictureFormat pictureFormat) {
        this.mCameraEngine.setPictureFormat(pictureFormat);
    }

    @NonNull
    public PictureFormat getPictureFormat() {
        return this.mCameraEngine.getPictureFormat();
    }

    public void setVideoSize(@NonNull SizeSelector selector) {
        this.mCameraEngine.setVideoSizeSelector(selector);
    }

    public void setVideoBitRate(int bitRate) {
        this.mCameraEngine.setVideoBitRate(bitRate);
    }

    public int getVideoBitRate() {
        return this.mCameraEngine.getVideoBitRate();
    }

    public void setPreviewFrameRateExact(boolean videoFrameRateExact) {
        this.mCameraEngine.setPreviewFrameRateExact(videoFrameRateExact);
    }

    public boolean getPreviewFrameRateExact() {
        return this.mCameraEngine.getPreviewFrameRateExact();
    }

    public void setPreviewFrameRate(float frameRate) {
        this.mCameraEngine.setPreviewFrameRate(frameRate);
    }

    public float getPreviewFrameRate() {
        return this.mCameraEngine.getPreviewFrameRate();
    }

    public void setAudioBitRate(int bitRate) {
        this.mCameraEngine.setAudioBitRate(bitRate);
    }

    public int getAudioBitRate() {
        return this.mCameraEngine.getAudioBitRate();
    }

    public void addCameraListener(@NonNull CameraListener cameraListener) {
        this.mListeners.add(cameraListener);
    }

    public void removeCameraListener(@NonNull CameraListener cameraListener) {
        this.mListeners.remove(cameraListener);
    }

    public void clearCameraListeners() {
        this.mListeners.clear();
    }

    public void takePicture() {
        PictureResult.Stub stub = new PictureResult.Stub();
        this.mCameraEngine.takePicture(stub);
    }

    public void takePictureSnapshot() {
        PictureResult.Stub stub = new PictureResult.Stub();
        this.mCameraEngine.takePictureSnapshot(stub);
    }

    public void takeVideo(@NonNull File file) {
        this.takeVideo(file, null);
    }

    public void takeVideo(@NonNull FileDescriptor fileDescriptor) {
        this.takeVideo(null, fileDescriptor);
    }

    private void takeVideo(@Nullable File file, @Nullable FileDescriptor fileDescriptor) {
        VideoResult.Stub stub = new VideoResult.Stub();
        if (file != null) {
            this.mCameraEngine.takeVideo(stub, file, null);
        } else if (fileDescriptor != null) {
            this.mCameraEngine.takeVideo(stub, null, fileDescriptor);
        } else {
            throw new IllegalStateException("file and fileDescriptor are both null.");
        }
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mKeepScreenOn = CameraView.this.getKeepScreenOn();
                if (!CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(true);
                }
            }
        });
    }

    public void takeVideoSnapshot(@NonNull File file) {
        VideoResult.Stub stub = new VideoResult.Stub();
        this.mCameraEngine.takeVideoSnapshot(stub, file);
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mKeepScreenOn = CameraView.this.getKeepScreenOn();
                if (!CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(true);
                }
            }
        });
    }

    public void takeVideo(@NonNull File file, int durationMillis) {
        this.takeVideo(file, null, durationMillis);
    }

    public void takeVideo(@NonNull FileDescriptor fileDescriptor, int durationMillis) {
        this.takeVideo(null, fileDescriptor, durationMillis);
    }

    private void takeVideo(@Nullable File file, @Nullable FileDescriptor fileDescriptor, int durationMillis) {
        final int old = this.getVideoMaxDuration();
        this.addCameraListener(new CameraListener(){

            @Override
            public void onVideoTaken(@NonNull VideoResult result) {
                CameraView.this.setVideoMaxDuration(old);
                CameraView.this.removeCameraListener(this);
            }

            @Override
            public void onCameraError(@NonNull CameraException exception) {
                super.onCameraError(exception);
                if (exception.getReason() == 5) {
                    CameraView.this.setVideoMaxDuration(old);
                    CameraView.this.removeCameraListener(this);
                }
            }
        });
        this.setVideoMaxDuration(durationMillis);
        this.takeVideo(file, fileDescriptor);
    }

    public void takeVideoSnapshot(@NonNull File file, int durationMillis) {
        final int old = this.getVideoMaxDuration();
        this.addCameraListener(new CameraListener(){

            @Override
            public void onVideoTaken(@NonNull VideoResult result) {
                CameraView.this.setVideoMaxDuration(old);
                CameraView.this.removeCameraListener(this);
            }

            @Override
            public void onCameraError(@NonNull CameraException exception) {
                super.onCameraError(exception);
                if (exception.getReason() == 5) {
                    CameraView.this.setVideoMaxDuration(old);
                    CameraView.this.removeCameraListener(this);
                }
            }
        });
        this.setVideoMaxDuration(durationMillis);
        this.takeVideoSnapshot(file);
    }

    public void stopVideo() {
        this.mCameraEngine.stopVideo();
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.getKeepScreenOn() != CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(CameraView.this.mKeepScreenOn);
                }
            }
        });
    }

    public void setSnapshotMaxWidth(int maxWidth) {
        this.mCameraEngine.setSnapshotMaxWidth(maxWidth);
    }

    public void setSnapshotMaxHeight(int maxHeight) {
        this.mCameraEngine.setSnapshotMaxHeight(maxHeight);
    }

    public int getSnapshotMaxWidth() {
        return this.mCameraEngine.getSnapshotMaxWidth();
    }

    public int getSnapshotMaxHeight() {
        return this.mCameraEngine.getSnapshotMaxHeight();
    }

    @Nullable
    public Size getSnapshotSize() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return null;
        }
        Size preview = this.mCameraEngine.getUncroppedSnapshotSize(Reference.VIEW);
        if (preview == null) {
            return null;
        }
        AspectRatio viewRatio = AspectRatio.of(this.getWidth(), this.getHeight());
        Rect crop = CropHelper.computeCrop(preview, viewRatio);
        Size cropSize = new Size(crop.width(), crop.height());
        if (this.mCameraEngine.getAngles().flip(Reference.VIEW, Reference.OUTPUT)) {
            return cropSize.flip();
        }
        return cropSize;
    }

    @Nullable
    public Size getPictureSize() {
        return this.mCameraEngine.getPictureSize(Reference.OUTPUT);
    }

    @Nullable
    public Size getVideoSize() {
        return this.mCameraEngine.getVideoSize(Reference.OUTPUT);
    }

    @TargetApi(value=23)
    private void requestPermissions(boolean requestCamera, boolean requestAudio) {
        Activity activity = null;
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestCamera) {
            permissions.add("android.permission.CAMERA");
        }
        if (requestAudio) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        if (activity != null) {
            activity.requestPermissions(permissions.toArray(new String[0]), 16);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void playSound(int soundType) {
        if (this.mPlaySounds) {
            if (this.mSound == null) {
                this.mSound = new MediaActionSound();
            }
            this.mSound.play(soundType);
        }
    }

    public void setPlaySounds(boolean playSounds) {
        this.mPlaySounds = playSounds && Build.VERSION.SDK_INT >= 16;
        this.mCameraEngine.setPlaySounds(playSounds);
    }

    public boolean getPlaySounds() {
        return this.mPlaySounds;
    }

    public void setUseDeviceOrientation(boolean useDeviceOrientation) {
        this.mUseDeviceOrientation = useDeviceOrientation;
    }

    public boolean getUseDeviceOrientation() {
        return this.mUseDeviceOrientation;
    }

    public void setVideoCodec(@NonNull VideoCodec codec) {
        this.mCameraEngine.setVideoCodec(codec);
    }

    @NonNull
    public VideoCodec getVideoCodec() {
        return this.mCameraEngine.getVideoCodec();
    }

    public void setVideoMaxSize(long videoMaxSizeInBytes) {
        this.mCameraEngine.setVideoMaxSize(videoMaxSizeInBytes);
    }

    public long getVideoMaxSize() {
        return this.mCameraEngine.getVideoMaxSize();
    }

    public void setVideoMaxDuration(int videoMaxDurationMillis) {
        this.mCameraEngine.setVideoMaxDuration(videoMaxDurationMillis);
    }

    public int getVideoMaxDuration() {
        return this.mCameraEngine.getVideoMaxDuration();
    }

    public boolean isTakingVideo() {
        return this.mCameraEngine.isTakingVideo();
    }

    public boolean isTakingPicture() {
        return this.mCameraEngine.isTakingPicture();
    }

    public void addFrameProcessor(@Nullable FrameProcessor processor) {
        if (processor != null) {
            this.mFrameProcessors.add(processor);
            if (this.mFrameProcessors.size() == 1) {
                this.mCameraEngine.setHasFrameProcessors(true);
            }
        }
    }

    public void removeFrameProcessor(@Nullable FrameProcessor processor) {
        if (processor != null) {
            this.mFrameProcessors.remove(processor);
            if (this.mFrameProcessors.size() == 0) {
                this.mCameraEngine.setHasFrameProcessors(false);
            }
        }
    }

    public void clearFrameProcessors() {
        boolean had = this.mFrameProcessors.size() > 0;
        this.mFrameProcessors.clear();
        if (had) {
            this.mCameraEngine.setHasFrameProcessors(false);
        }
    }

    public void setFrameProcessingMaxWidth(int maxWidth) {
        this.mCameraEngine.setFrameProcessingMaxWidth(maxWidth);
    }

    public void setFrameProcessingMaxHeight(int maxHeight) {
        this.mCameraEngine.setFrameProcessingMaxHeight(maxHeight);
    }

    public int getFrameProcessingMaxWidth() {
        return this.mCameraEngine.getFrameProcessingMaxWidth();
    }

    public int getFrameProcessingMaxHeight() {
        return this.mCameraEngine.getFrameProcessingMaxHeight();
    }

    public void setFrameProcessingFormat(int format) {
        this.mCameraEngine.setFrameProcessingFormat(format);
    }

    public int getFrameProcessingFormat() {
        return this.mCameraEngine.getFrameProcessingFormat();
    }

    public void setFrameProcessingPoolSize(int poolSize) {
        this.mCameraEngine.setFrameProcessingPoolSize(poolSize);
    }

    public int getFrameProcessingPoolSize() {
        return this.mCameraEngine.getFrameProcessingPoolSize();
    }

    public void setFrameProcessingExecutors(int executors) {
        if (executors < 1) {
            throw new IllegalArgumentException("Need at least 1 executor, got " + executors);
        }
        this.mFrameProcessingExecutors = executors;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(executors, executors, 4L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "FrameExecutor #" + this.mCount.getAndIncrement());
            }
        });
        executor.allowCoreThreadTimeOut(true);
        this.mFrameProcessingExecutor = executor;
    }

    public int getFrameProcessingExecutors() {
        return this.mFrameProcessingExecutors;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        if (!this.mInEditor && this.mOverlayLayout.isOverlay(attributeSet)) {
            return this.mOverlayLayout.generateLayoutParams(attributeSet);
        }
        return super.generateLayoutParams(attributeSet);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.mInEditor && this.mOverlayLayout.isOverlay(params)) {
            this.mOverlayLayout.addView(child, params);
        } else {
            super.addView(child, index, params);
        }
    }

    public void removeView(View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!this.mInEditor && params != null && this.mOverlayLayout.isOverlay(params)) {
            this.mOverlayLayout.removeView(view);
        } else {
            super.removeView(view);
        }
    }

    public void setFilter(@NonNull Filter filter) {
        if (this.mCameraPreview == null) {
            this.mPendingFilter = filter;
        } else {
            boolean isNoFilter = filter instanceof NoFilter;
            boolean isFilterPreview = this.mCameraPreview instanceof FilterCameraPreview;
            if (!isNoFilter && !isFilterPreview) {
                throw new RuntimeException("Filters are only supported by the GL_SURFACE preview. Current preview:" + this.mPreview);
            }
            if (isFilterPreview) {
                ((FilterCameraPreview)((Object)this.mCameraPreview)).setFilter(filter);
            }
        }
    }

    @NonNull
    public Filter getFilter() {
        if (this.mCameraPreview == null) {
            return this.mPendingFilter;
        }
        if (this.mCameraPreview instanceof FilterCameraPreview) {
            return ((FilterCameraPreview)((Object)this.mCameraPreview)).getCurrentFilter();
        }
        throw new RuntimeException("Filters are only supported by the GL_SURFACE preview. Current:" + this.mPreview);
    }

    @VisibleForTesting
    class CameraCallbacks
    implements CameraEngine.Callback,
    OrientationHelper.Callback,
    GestureFinder.Controller {
        private final String TAG = CameraCallbacks.class.getSimpleName();
        private final CameraLogger LOG = CameraLogger.create(this.TAG);

        CameraCallbacks() {
        }

        @Override
        @NonNull
        public Context getContext() {
            return CameraView.this.getContext();
        }

        @Override
        public int getWidth() {
            return CameraView.this.getWidth();
        }

        @Override
        public int getHeight() {
            return CameraView.this.getHeight();
        }

        @Override
        public void dispatchOnCameraOpened(final @NonNull CameraOptions options) {
            this.LOG.i("dispatchOnCameraOpened", options);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraOpened(options);
                    }
                }
            });
        }

        @Override
        public void dispatchOnCameraClosed() {
            this.LOG.i("dispatchOnCameraClosed");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraClosed();
                    }
                }
            });
        }

        @Override
        public void onCameraPreviewStreamSizeChanged() {
            Size previewSize = CameraView.this.mCameraEngine.getPreviewStreamSize(Reference.VIEW);
            if (previewSize == null) {
                throw new RuntimeException("Preview stream size should not be null here.");
            }
            if (previewSize.equals(CameraView.this.mLastPreviewStreamSize)) {
                this.LOG.i("onCameraPreviewStreamSizeChanged:", "swallowing because the preview size has not changed.", previewSize);
            } else {
                this.LOG.i("onCameraPreviewStreamSizeChanged: posting a requestLayout call.", "Preview stream size:", previewSize);
                CameraView.this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraView.this.requestLayout();
                    }
                });
            }
        }

        @Override
        public void onShutter(boolean shouldPlaySound) {
            if (shouldPlaySound && CameraView.this.mPlaySounds) {
                CameraView.this.playSound(0);
            }
        }

        @Override
        public void dispatchOnPictureTaken(final @NonNull PictureResult.Stub stub) {
            this.LOG.i("dispatchOnPictureTaken", stub);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    PictureResult result = new PictureResult(stub);
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onPictureTaken(result);
                    }
                }
            });
        }

        @Override
        public void dispatchOnVideoTaken(final @NonNull VideoResult.Stub stub) {
            this.LOG.i("dispatchOnVideoTaken", stub);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoResult result = new VideoResult(stub);
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onVideoTaken(result);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusStart(final @Nullable Gesture gesture, final @NonNull PointF point) {
            this.LOG.i(new Object[]{"dispatchOnFocusStart", gesture, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.mMarkerLayout.onEvent(1, new PointF[]{point});
                    if (CameraView.this.mAutoFocusMarker != null) {
                        AutoFocusTrigger trigger = gesture != null ? AutoFocusTrigger.GESTURE : AutoFocusTrigger.METHOD;
                        CameraView.this.mAutoFocusMarker.onAutoFocusStart(trigger, point);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onAutoFocusStart(point);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusEnd(final @Nullable Gesture gesture, final boolean success, final @NonNull PointF point) {
            this.LOG.i(new Object[]{"dispatchOnFocusEnd", gesture, success, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (success && CameraView.this.mPlaySounds) {
                        CameraView.this.playSound(1);
                    }
                    if (CameraView.this.mAutoFocusMarker != null) {
                        AutoFocusTrigger trigger = gesture != null ? AutoFocusTrigger.GESTURE : AutoFocusTrigger.METHOD;
                        CameraView.this.mAutoFocusMarker.onAutoFocusEnd(trigger, success, point);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onAutoFocusEnd(success, point);
                    }
                }
            });
        }

        @Override
        public void onDeviceOrientationChanged(int deviceOrientation) {
            this.LOG.i("onDeviceOrientationChanged", deviceOrientation);
            int displayOffset = CameraView.this.mOrientationHelper.getLastDisplayOffset();
            if (!CameraView.this.mUseDeviceOrientation) {
                int fakeDeviceOrientation = (360 - displayOffset) % 360;
                CameraView.this.mCameraEngine.getAngles().setDeviceOrientation(fakeDeviceOrientation);
            } else {
                CameraView.this.mCameraEngine.getAngles().setDeviceOrientation(deviceOrientation);
            }
            final int value = (deviceOrientation + displayOffset) % 360;
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onOrientationChanged(value);
                    }
                }
            });
        }

        @Override
        public void onDisplayOffsetChanged(int displayOffset, boolean willRecreate) {
            this.LOG.i("onDisplayOffsetChanged", displayOffset, "recreate:", willRecreate);
            if (CameraView.this.isOpened() && !willRecreate) {
                this.LOG.w("onDisplayOffsetChanged", "restarting the camera.");
                CameraView.this.close();
                CameraView.this.open();
            }
        }

        @Override
        public void dispatchOnZoomChanged(final float newValue, final @Nullable PointF[] fingers) {
            this.LOG.i("dispatchOnZoomChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onZoomChanged(newValue, new float[]{0.0f, 1.0f}, fingers);
                    }
                }
            });
        }

        @Override
        public void dispatchOnExposureCorrectionChanged(final float newValue, final @NonNull float[] bounds, final @Nullable PointF[] fingers) {
            this.LOG.i("dispatchOnExposureCorrectionChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onExposureCorrectionChanged(newValue, bounds, fingers);
                    }
                }
            });
        }

        @Override
        public void dispatchFrame(final @NonNull Frame frame) {
            this.LOG.v("dispatchFrame:", frame.getTime(), "processors:", CameraView.this.mFrameProcessors.size());
            if (CameraView.this.mFrameProcessors.isEmpty()) {
                frame.release();
            } else {
                CameraView.this.mFrameProcessingExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        CameraCallbacks.this.LOG.v("dispatchFrame: executing. Passing", frame.getTime(), "to processors.");
                        for (FrameProcessor processor : CameraView.this.mFrameProcessors) {
                            try {
                                processor.process(frame);
                            }
                            catch (Exception e) {
                                CameraCallbacks.this.LOG.w("Frame processor crashed:", e);
                            }
                        }
                        frame.release();
                    }
                });
            }
        }

        @Override
        public void dispatchError(final CameraException exception) {
            this.LOG.i("dispatchError", exception);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraError(exception);
                    }
                }
            });
        }

        @Override
        public void dispatchOnVideoRecordingStart() {
            this.LOG.i("dispatchOnVideoRecordingStart");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onVideoRecordingStart();
                    }
                }
            });
        }

        @Override
        public void dispatchOnVideoRecordingEnd() {
            this.LOG.i("dispatchOnVideoRecordingEnd");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onVideoRecordingEnd();
                    }
                }
            });
        }
    }
}

