/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.view.filter.BaseFilter;
import com.talpa.translate.camera.view.filter.OneParameterFilter;

public class HueFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float hue;\nvoid main() {\n  vec4 kRGBToYPrime = vec4 (0.299, 0.587, 0.114, 0.0);\n  vec4 kRGBToI = vec4 (0.595716, -0.274453, -0.321263, 0.0);\n  vec4 kRGBToQ = vec4 (0.211456, -0.522591, 0.31135, 0.0);\n  vec4 kYIQToR = vec4 (1.0, 0.9563, 0.6210, 0.0);\n  vec4 kYIQToG = vec4 (1.0, -0.2721, -0.6474, 0.0);\n  vec4 kYIQToB = vec4 (1.0, -1.1070, 1.7046, 0.0);\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  float YPrime = dot(color, kRGBToYPrime);\n  float I = dot(color, kRGBToI);\n  float Q = dot(color, kRGBToQ);\n  float chroma = sqrt (I * I + Q * Q);\n  Q = chroma * sin (hue);\n  I = chroma * cos (hue);\n  vec4 yIQ = vec4 (YPrime, I, Q, 0.0);\n  color.r = dot (yIQ, kYIQToR);\n  color.g = dot (yIQ, kYIQToG);\n  color.b = dot (yIQ, kYIQToB);\n  gl_FragColor = color;\n}\n";
    private float hue = 0.0f;
    private int hueLocation = -1;

    public void setHue(float hue) {
        this.hue = hue % 360.0f;
    }

    public float getHue() {
        return this.hue;
    }

    @Override
    public void setParameter1(float value) {
        this.setHue(value * 360.0f);
    }

    @Override
    public float getParameter1() {
        return this.getHue() / 360.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.hueLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"hue");
        Egloo.checkGlProgramLocation(this.hueLocation, "hue");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.hueLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float shaderHue = ((this.hue - 45.0f) / 45.0f + 0.5f) * -1.0f;
        GLES20.glUniform1f((int)this.hueLocation, (float)shaderHue);
        Egloo.checkGlError("glUniform1f");
    }
}

