/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.preview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.photo.translation.R;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.preview.CameraPreview;

public class SurfaceCameraPreview
extends CameraPreview<SurfaceView, SurfaceHolder> {
    private static final CameraLogger LOG = CameraLogger.create(SurfaceCameraPreview.class.getSimpleName());
    private boolean mDispatched;
    private View mRootView;

    public SurfaceCameraPreview(@NonNull Context context, @NonNull ViewGroup parent) {
        super(context, parent);
    }

    @Override
    @NonNull
    protected SurfaceView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.cameraview_surface_view, parent, false);
        parent.addView(root, 0);
        SurfaceView surfaceView = (SurfaceView)root.findViewById(R.id.surface_view);
        SurfaceHolder holder = surfaceView.getHolder();
        holder.setType(3);
        holder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                LOG.i("callback:", "surfaceChanged", "w:", width, "h:", height, "dispatched:", SurfaceCameraPreview.this.mDispatched);
                if (!SurfaceCameraPreview.this.mDispatched) {
                    SurfaceCameraPreview.this.dispatchOnSurfaceAvailable(width, height);
                    SurfaceCameraPreview.this.mDispatched = true;
                } else {
                    SurfaceCameraPreview.this.dispatchOnSurfaceSizeChanged(width, height);
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                LOG.i("callback:", "surfaceDestroyed");
                SurfaceCameraPreview.this.dispatchOnSurfaceDestroyed();
                SurfaceCameraPreview.this.mDispatched = false;
            }
        });
        this.mRootView = root;
        return surfaceView;
    }

    @Override
    @NonNull
    public View getRootView() {
        return this.mRootView;
    }

    @Override
    @NonNull
    public SurfaceHolder getOutput() {
        return ((SurfaceView)this.getView()).getHolder();
    }

    @Override
    @NonNull
    public Class<SurfaceHolder> getOutputClass() {
        return SurfaceHolder.class;
    }
}

