/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.datasource;

import android.content.Context;
import androidx.lifecycle.LifecycleOwner;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.camera.view.CameraListener;
import com.talpa.translate.camera.view.CameraView;
import com.talpa.translate.camera.view.PictureResult;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Engine;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Grid;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.Preview;
import com.talpa.translate.camera.view.gesture.Gesture;
import com.talpa.translate.camera.view.gesture.GestureAction;
import com.talpa.translate.camera.view.markers.DefaultAutoFocusMarker;
import com.talpa.translate.datasource.ICameraSource;
import com.talpa.translate.ocr.exception.NoContentException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/talpa/translate/datasource/CameraCompatSource;", "Lcom/talpa/translate/datasource/ICameraSource;", "()V", "mCamera", "Lcom/talpa/translate/camera/view/CameraView;", "mOrientation", "", "mStatus", "Lcom/talpa/translate/datasource/ICameraSource$Status;", "initialize", "", "context", "Landroid/content/Context;", "camera", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "open", "pause", "release", "setStatusCallback", "status", "takePicture", "torch", "switch", "", "L", "translation_xiaomiRelease"})
public final class CameraCompatSource
implements ICameraSource {
    private CameraView mCamera;
    private ICameraSource.Status mStatus;
    private int mOrientation;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@NotNull Context context, @NotNull CameraView camera, @NotNull LifecycleOwner lifecycleOwner) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)camera), (String)"camera");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        CameraView cameraView = camera;
        boolean bl = false;
        boolean bl2 = false;
        CameraView cameraView2 = cameraView;
        CameraCompatSource cameraCompatSource = this;
        boolean bl3 = false;
        $this$apply.setEngine(Engine.CAMERA2);
        $this$apply.setExperimental(true);
        $this$apply.setPreview(Preview.GL_SURFACE);
        $this$apply.setPlaySounds(false);
        $this$apply.setGrid(Grid.OFF);
        $this$apply.setFlash(Flash.OFF);
        $this$apply.setAudio(Audio.OFF);
        $this$apply.setFacing(Facing.BACK);
        $this$apply.mapGesture(Gesture.TAP, GestureAction.AUTO_FOCUS);
        $this$apply.mapGesture(Gesture.LONG_TAP, GestureAction.NONE);
        $this$apply.mapGesture(Gesture.PINCH, GestureAction.ZOOM);
        $this$apply.setMode(Mode.PICTURE);
        $this$apply.setAutoFocusMarker(new DefaultAutoFocusMarker());
        $this$apply.setUseDeviceOrientation(false);
        $this$apply.setFrameProcessingFormat(35);
        Unit unit = Unit.INSTANCE;
        cameraCompatSource.mCamera = cameraView;
        CameraView cameraView3 = this.mCamera;
        if (cameraView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        cameraView3.setLifecycleOwner(lifecycleOwner);
        CameraView cameraView4 = this.mCamera;
        if (cameraView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        cameraView4.addCameraListener(new L());
    }

    @Override
    public void setStatusCallback(@NotNull ICameraSource.Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.mStatus = status;
    }

    @Override
    public void open() {
        CameraView cameraView = this.mCamera;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        if (!cameraView.isOpened()) {
            CameraView cameraView2 = this.mCamera;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
            }
            cameraView2.open();
        }
    }

    @Override
    public void pause() {
        CameraView cameraView = this.mCamera;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        if (cameraView.isOpened()) {
            CameraView cameraView2 = this.mCamera;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
            }
            cameraView2.close();
        }
    }

    @Override
    public void release() {
        CameraView cameraView = this.mCamera;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        cameraView.destroy();
    }

    @Override
    public void takePicture() {
        CameraView cameraView = this.mCamera;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        cameraView.takePictureSnapshot();
    }

    @Override
    public void torch(boolean bl) {
        block1: {
            CameraView cameraView = this.mCamera;
            if (cameraView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
            }
            cameraView.set(bl ? Flash.TORCH : Flash.OFF);
            ICameraSource.Status status = this.mStatus;
            if (status == null) break block1;
            status.onStatusChange(bl ? 0 : 1);
        }
    }

    public static final /* synthetic */ CameraView access$getMCamera$p(CameraCompatSource $this) {
        CameraView cameraView = $this.mCamera;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        }
        return cameraView;
    }

    public static final /* synthetic */ void access$setMCamera$p(CameraCompatSource $this, CameraView cameraView) {
        $this.mCamera = cameraView;
    }

    public static final /* synthetic */ void access$setMStatus$p(CameraCompatSource $this, ICameraSource.Status status) {
        $this.mStatus = status;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/talpa/translate/datasource/CameraCompatSource$L;", "Lcom/talpa/translate/camera/view/CameraListener;", "(Lcom/talpa/translate/datasource/CameraCompatSource;)V", "onOrientationChanged", "", "orientation", "", "onPictureTaken", "result", "Lcom/talpa/translate/camera/view/PictureResult;", "translation_xiaomiRelease"})
    private final class L
    extends CameraListener {
        @Override
        public void onPictureTaken(@NotNull PictureResult result) {
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    if (result.getData() == null) break block3;
                    int height = CameraCompatSource.access$getMCamera$p(CameraCompatSource.this).getHeight();
                    int width = CameraCompatSource.access$getMCamera$p(CameraCompatSource.this).getWidth();
                    switch (CameraCompatSource.this.mOrientation % 360) {
                        case 90: 
                        case 270: {
                            height = CameraCompatSource.access$getMCamera$p(CameraCompatSource.this).getWidth();
                            width = CameraCompatSource.access$getMCamera$p(CameraCompatSource.this).getHeight();
                            break;
                        }
                    }
                    FrameMetadata metadata = new FrameMetadata.Builder().setWidth(width).setHeight(height).setRotation(CameraCompatSource.this.mOrientation).setCameraFacing(CameraCompatSource.access$getMCamera$p(CameraCompatSource.this).getFacing()).setPictureFormat(result.getFormat()).build();
                    ICameraSource.Status status = CameraCompatSource.this.mStatus;
                    if (status == null) break block4;
                    byte[] byArray = result.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"result.data");
                    FrameMetadata frameMetadata = metadata;
                    Intrinsics.checkNotNullExpressionValue((Object)frameMetadata, (String)"metadata");
                    status.onPicturetaked(byArray, frameMetadata);
                    break block4;
                }
                ICameraSource.Status status = CameraCompatSource.this.mStatus;
                if (status == null) break block4;
                status.onPicturetakeFail(new NoContentException(null, 1, null));
            }
        }

        @Override
        public void onOrientationChanged(int orientation) {
            super.onOrientationChanged(orientation);
            CameraCompatSource.this.mOrientation = orientation;
        }
    }
}

