package com.talpa.translate.base.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.ScrollView
import com.photo.translation.R

/**
 * Created by luna.zhu on 2019/5/27.
 */
class MaxHeightScrollView : ScrollView {
    private var mMaxHeight: Int = 0

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init(context, attrs)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        init(context, attrs)
    }

    private fun init(context: Context, attrs: AttributeSet?) {
        if (attrs == null) {
            return
        }

        val a = context.obtainStyledAttributes(attrs, R.styleable.MaxHeightScrollView_1)

        try {
            setMaxHeight(a.getDimensionPixelSize(R.styleable.MaxHeightScrollView_1_maxHeight, 200))
        } finally {
            a.recycle()
        }
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec(mMaxHeight, View.MeasureSpec.AT_MOST))
    }

    private fun setMaxHeight(maxHeight: Int) {
        this.mMaxHeight = maxHeight
    }
}