package com.talpa.translate.factory

import android.content.Context
import com.talpa.translate.ocr.FirebaseRecognizer
import com.talpa.translate.ocr.GoogleRecognizer
import com.talpa.translate.ocr.IAnalyzer
import com.talpa.translate.ocr.Recognizer
import com.talpa.translate.render.Render
import com.talpa.translate.render.TranslatorRender

/**
 * Create by chenjunsheng on 2020/6/17
 */
class TranslatorFactory {

    companion object {
        fun getFirebaseRecognizer(context: Context): Recognizer {
            return FirebaseRecognizer(context)
        }

        fun getRender(context: Context, analyzer: IAnalyzer): Render {
            return TranslatorRender(context, analyzer)
        }

        fun getGoogleRecognizer(context: Context) : Recognizer {
            return GoogleRecognizer(context)
        }
    }
}