/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.result;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.RecyclerView;
import com.photo.translation.R;
import com.talpa.translate.base.utils.StaticesEventKt;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.network.Result;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.datasource.CompleteResult;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/talpa/translate/ocr/result/ContrastAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/talpa/translate/ocr/result/ContrastAdapter$ContrastHolder;", "completeResult", "Lcom/talpa/translate/ocr/datasource/CompleteResult;", "(Lcom/talpa/translate/ocr/datasource/CompleteResult;)V", "blockList", "", "Lcom/talpa/translate/ocr/result/Block;", "responseList", "", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "ContrastHolder", "translation_xiaomiRelease"})
public final class ContrastAdapter
extends RecyclerView.Adapter<ContrastHolder> {
    private final List<Block> blockList;
    private final List<String> responseList;

    @NotNull
    public ContrastHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View view;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view2 = view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.contrast_item, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        return new ContrastHolder(view2);
    }

    public void onBindViewHolder(@NotNull ContrastHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        List<Block> list = this.blockList;
        String ocrText = list != null && (list = list.get(position)) != null ? ((Block)((Object)list)).getText() : null;
        List<String> list2 = this.responseList;
        String translation = list2 != null ? list2.get(position) : null;
        CharSequence charSequence = ocrText;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = translation;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                holder.getSource().setText((CharSequence)ocrText);
                holder.getTarget().setText((CharSequence)Html.fromHtml((String)translation));
            }
        }
        holder.getCopy().setOnClickListener(new View.OnClickListener(holder){
            final /* synthetic */ ContrastHolder $holder;

            public final void onClick(View it) {
                View view = it;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"it");
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"it.context");
                CharSequence charSequence = "Contrast";
                StringBuilder stringBuilder = new StringBuilder();
                TextView textView = this.$holder.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"holder.source");
                StringBuilder stringBuilder2 = stringBuilder.append(textView.getText()).append(' ');
                TextView textView2 = this.$holder.getTarget();
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"holder.target");
                UtilsKt.clipboard(context, charSequence, stringBuilder2.append(textView2.getText()).toString());
                StaticesEventKt.logEvent$default("PT_contrast_copy", null, null, 6, null);
                Toast.makeText((Context)it.getContext(), (int)R.string.copied_toast_contrast, (int)0).show();
            }
            {
                this.$holder = contrastHolder;
            }
        });
    }

    public int getItemCount() {
        List<Block> list = this.blockList;
        int n = list != null ? list.size() : 0;
        List<String> list2 = this.responseList;
        int n2 = list2 != null ? list2.size() : 0;
        boolean bl = false;
        return Math.min(n, n2);
    }

    public ContrastAdapter(@NotNull CompleteResult completeResult) {
        Intrinsics.checkNotNullParameter((Object)completeResult, (String)"completeResult");
        OcrResult ocrResult = completeResult.getOcrResult();
        this.blockList = ocrResult != null ? ocrResult.getBlocks() : null;
        Object object = completeResult.getTransResponse();
        this.responseList = object != null && (object = ((TransResponse)object).getResult()) != null ? ((Result)object).getTexts() : null;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0019\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/ocr/result/ContrastAdapter$ContrastHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "copy", "kotlin.jvm.PlatformType", "getCopy", "()Landroid/view/View;", "source", "Landroid/widget/TextView;", "getSource", "()Landroid/widget/TextView;", "target", "getTarget", "translation_xiaomiRelease"})
    public static final class ContrastHolder
    extends RecyclerView.ViewHolder {
        private final TextView source;
        private final TextView target;
        private final View copy;

        public final TextView getSource() {
            return this.source;
        }

        public final TextView getTarget() {
            return this.target;
        }

        public final View getCopy() {
            return this.copy;
        }

        public ContrastHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.source = (TextView)itemView.findViewById(R.id.source);
            this.target = (TextView)itemView.findViewById(R.id.target);
            this.copy = itemView.findViewById(R.id.ic_copy);
        }
    }
}

