/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.thirdpart.leptonica;

import com.talpa.translate.ocr.thirdpart.leptonica.Pix;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Edge {
    public static final int L_HORIZONTAL_EDGES = 0;
    public static final int L_VERTICAL_EDGES = 1;
    public static final int L_ALL_EDGES = 2;

    public static Pix pixSobelEdgeFilter(Pix pixs, int orientFlag) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixs.getDepth() != 8) {
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        if (orientFlag < 0 || orientFlag > 2) {
            throw new IllegalArgumentException("Invalid orientation flag");
        }
        long nativePix = Edge.nativePixSobelEdgeFilter(pixs.getNativePix(), orientFlag);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to perform Sobel edge filter on image");
        }
        return new Pix(nativePix);
    }

    private static native long nativePixSobelEdgeFilter(long var0, int var2);

    static {
        System.loadLibrary("leptonica");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EdgeOrientationFlag {
    }
}

