package com.talpa.translate.ocr

import android.content.Context
import com.photo.translation.BuildConfig
import com.talpa.translate.base.utils.googleVisionLanguages
import com.talpa.translate.factory.TranslatorFactory

/**
 * Create by chenjunsheng on 2020/7/29
 */
object OcrDispatcher {

    private var googleOcrEnable = true

    fun setGoogleOcrEnable(googleOcrEnable: Boolean) {
        this.googleOcrEnable = googleOcrEnable
    }

    fun getGoogleOcrEnable() = googleOcrEnable

    fun dispatchOcrTranslator(context: Context, sourceLanguage: String): Recognizer {
        if (BuildConfig.FLAVOR != "hw") {
            return if (googleVisionLanguages.contains(sourceLanguage) && googleOcrEnable) {
                TranslatorFactory.getGoogleRecognizer(context)
            } else {
                TranslatorFactory.getFirebaseRecognizer(context)
            }
        } else {
            return if (sourceLanguage != "zh" && sourceLanguage != "ko" && sourceLanguage != "ja"
                && (googleVisionLanguages.contains(sourceLanguage) && googleOcrEnable)
            ) {
                TranslatorFactory.getGoogleRecognizer(context)
            } else {
                TranslatorFactory.getFirebaseRecognizer(context)
            }
        }
    }

}
