package com.talpa.translate.network

import androidx.annotation.Keep

/**
 * Create by chenjunsheng on 2020/7/10
 */
@Keep
data class TransResponse(
    var code: Int = 0,
    var message: String? = null,
    var result: Result? = null
)
@Keep
data class Result(var texts: List<String>? = null)

/*{
    "app_key": "10025"
    "to":"en",
    "texts"[
    "fasdfa",
    "fasdff",
    "faweff"
    ]
    "from":"",
    "timestamp": 1231234213,
    "nonce": "acbf"
    "sig":"feafefaefaefef"
}*/
@Keep
data class TransRequest(
    var app_key: String?,
    var to: String?,
    var texts: List<String>?,
    var from: String?,
    var timestamp: Long,
    var nonce: String?,
    var sig: String?
)