package com.talpa.translate.ocr

import android.R.attr
import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Base64
import android.util.Log
import androidx.annotation.Keep
import com.talpa.translate.ocr.text.NormalTextDrawer
import java.io.ByteArrayOutputStream
import java.io.IOException


/**
 * Create by chenjunsheng on 2020/7/28
 */
class PhotoAnalyzer(context: Context) : IAnalyzer {

    /*companion object {
        init {
            System.loadLibrary("c++_shared")
            System.loadLibrary("imgprocessor")
        }

        fun getBase64String(bitmap: Bitmap) : String? {
            return getBase64Native(bitmap)
        }

        @JvmStatic
        external fun preprocessor(bitmap: Bitmap) : Bitmap?

        @JvmStatic
        private external fun getBase64Native(bitmap: Bitmap) : String?
    }*/
    companion object {
        fun getBase64String(bitmap: Bitmap) : String? {
            var result: String? = null
            ByteArrayOutputStream().use {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, it)
                val bitmapBytes: ByteArray = it.toByteArray()
                result = Base64.encodeToString(bitmapBytes, Base64.DEFAULT)
            }
            return result
        }

        fun preprocessor(bitmap: Bitmap) : Bitmap? = bitmap
    }

    private val mTextDrawer = NormalTextDrawer(context)

    override fun getTextDrawer(): TextDrawer {
        return mTextDrawer
    }

    private var mNativeAddr: Long = 0
    private var mRecycled = true

    private var sourceConfig: Bitmap.Config? = null

    /**
     * for jni call
     * 这个函数名称不能混淆
     */
    @Keep
    fun getSourceConfig() : Bitmap.Config? {
        Log.d("cjslog", "from jni call")
        return sourceConfig
    }

    private var mBitmap: Bitmap? = null

    override fun initialize(bitmap: Bitmap) {
        //sourceBitmap = bitmap
        mBitmap = bitmap
        /*mNativeAddr = initializeNative(bitmap)
        if (mNativeAddr == 0L) {
            throw RuntimeException("can't initialize photo analyze object")
        }
        mRecycled = false
        sourceConfig = bitmap.config*/

    }

    override fun release() {
        /*if (!mRecycled) {
            nReleaseNative(mNativeAddr)
            mRecycled = true
        }*/
    }

    private fun generateBgBitmap(rects: Array<Rect>) : Bitmap? {
        /*if (mRecycled) {
            throw IllegalStateException("analyzer has been recycled")
        }*/
        return /*generateBitmapNative(rects)*/mBitmap
    }

    override fun postAnalyzeArea(rects: Array<Rect>) : Bitmap? {

        return /*generateBgBitmap(rects)*/mBitmap
    }

    override fun analyzeTextColor(rects: Array<Rect>): IntArray {
        //return nTextColor(rects)
        return IntArray(rects.size) {
            0
        }
    }


    /*private external fun generateBitmapNative(areas: Array<Rect>) : Bitmap?

    private external fun initializeNative(bitmap: Bitmap) : Long

    private external fun nTextColor(areas: Array<Rect>) : IntArray

    private external fun nReleaseNative(addr: Long)

    private external fun convert64ToBitmap(base64: String) : Bitmap*/
}