package com.talpa.base.utils

import android.R.attr
import android.content.Context
import android.graphics.*
import android.os.Environment
import android.os.StatFs
import java.io.File
import java.text.SimpleDateFormat
import java.util.*


/**
 * Create by chenjunsheng on 2020/4/27
 */

fun isSDCardEnable(): Boolean {
    return Environment.MEDIA_MOUNTED == Environment.getExternalStorageState()
}

fun getFreeSpace(): Long {
    if (!isSDCardEnable()) {
        return -1
    }
    val stat = StatFs(Environment.getExternalStorageDirectory().getPath())
    val blockSize = stat.blockSizeLong
    val availableBlocks = stat.availableBlocksLong
    val size = availableBlocks * blockSize / 1024L
    return size
}

/**
 * Create Photo File
 */
fun createPhotoFile(context: Context): File {

    val baseDir: File = context.externalMediaDirs.firstOrNull() ?: context.filesDir

    if (!baseDir.exists()) {
        baseDir.mkdirs()
    }

    val pattern = "yyyy-MM-dd-HH-mm-ss"

    val extension = ".jpg"

    val dateFormat =
        SimpleDateFormat(pattern, Locale.US).format(System.currentTimeMillis())

    val fileName = "$dateFormat$extension"

    return File(baseDir, fileName)
}

fun Context.navigationBarHeight(): Int {
    val resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android")
    val height = resources.getDimensionPixelSize(resourceId)
    //Log.v("dbw", "Navi height:" + height);
    return height
}

fun drawTextToBitmap(bitmap: Bitmap, context: Context, text: String): Bitmap {
    val scale = context.resources.displayMetrics.density
    var bitmapConfig = bitmap.getConfig()
    if (bitmapConfig == null) {
        bitmapConfig = Bitmap.Config.ARGB_8888;
    }
    val newBitmap = bitmap.copy(bitmapConfig, true)
    val canvas = Canvas(newBitmap)
    val paint = Paint(Paint.ANTI_ALIAS_FLAG)
        .also {
            it.setColor(Color.BLACK)
            it.setTextSize((12 * scale))
            it.setShadowLayer(1f, 0f, 1f, Color.WHITE)
        }
    val bounds = Rect()
    paint.getTextBounds(text, 0, text.length, bounds)
    val x: Int = (bitmap.getWidth() - bounds.width()) / 2
    val y: Int = (bitmap.getHeight() + bounds.height()) / 2
    canvas.drawText(text, x.toFloat(), y.toFloat(), paint)

    return newBitmap
}