package com.talpa.camera.translate.utils

import android.content.Context
import android.graphics.*
import android.net.ConnectivityManager
import android.text.StaticLayout
import android.text.TextPaint
import android.util.Log
import com.talpa.base.BaseApp
import com.tencent.mmkv.MMKV

/**
 * Create by chenjunsheng on 2020/4/27
 */

private const val RATIO_4_3_VALUE = 4.0 / 3.0
private const val RATIO_16_9_VALUE = 16.0 / 9.0

const val PREFER_KEY_SOURCE_LANG = "key_source_lang"
const val PREFER_NAME = "prefer_camera"

const val MAX_TEXT_SIZE_PX = 160
const val MIN_TEXT_SIZE_PX = 12

/**
 * Release origin image by translation bitmap
 */

/**
 *  [androidx.camera.core.ImageAnalysisConfig] requires enum value of
 *  [androidx.camera.core.AspectRatio]. Currently it has values of 4:3 & 16:9.
 *
 *  Detecting the most suitable ratio for dimensions provided in @params by counting absolute
 *  of preview ratio to one of the provided values.
 *
 *  @param width - preview width
 *  @param height - preview height
 *  @return suitable aspect ratio
 */
/*fun aspectRatio(width: Int, height: Int): Int {
    val previewRatio = max(width, height).toDouble() / min(width, height)
    if (abs(previewRatio - RATIO_4_3_VALUE) <= abs(previewRatio - RATIO_16_9_VALUE)) {
        return AspectRatio.RATIO_4_3
    }
    return AspectRatio.RATIO_16_9
}*/

/**
 * Save Language Tag
 */
fun saveLanguage(
    preferKey: String = PREFER_KEY_SOURCE_LANG,
    value: String
) {
    //val prefer = context.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE)
    //prefer.edit().putString(preferKey, value).apply()
    val mmkv = MMKV.defaultMMKV()
    mmkv.encode(preferKey, value)
}

fun Context.isNetworkConnected(): Boolean {
    val connectivityManager =
        getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

    val networkInfo = connectivityManager.activeNetworkInfo
    return networkInfo?.isAvailable == true && networkInfo.isConnected
}

