package com.talpa.camera.translate.view

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.drawable.Drawable
import android.graphics.drawable.RippleDrawable
import android.util.AttributeSet
import android.util.Log
import android.view.View
import android.view.animation.Animation
import android.view.animation.LinearInterpolator
import android.view.animation.Transformation
import androidx.core.content.ContextCompat
import com.photo.translation.R
import kotlin.math.abs

/**
 * Create by chenjunsheng on 2020/4/27
 */

const val RING_WIDTH_OUT = 8
const val GAP = 8
const val TRANSFORM_PRECENT = 0.75F

interface CaptureButtonState {
    fun onDraw(canvas: Canvas)

    fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int)
}

class CaptureButton : View {

    private var mAlpha = 255
    private var mPaint: Paint = Paint()
    private val transparentAnim = TransparentAnim()
    private var transformRate = 1F
    val cameraState = CameraState()
    //val cropState = TranslateState()
    val resultState = ResultState()
    //private var cropButton: Drawable? = null

    constructor(context: Context) : this(context, null)

    constructor(context: Context, attributes: AttributeSet?) : this(context, attributes, 0)

    constructor(context: Context, attributes: AttributeSet?, defStyle: Int) : super(context, attributes, defStyle) {
        mPaint.isAntiAlias = true
        /*cropButton = context.getDrawable(R.mipmap.select_language)
            ?.also { it.setBounds(0, 0, it.getIntrinsicWidth(), it.getIntrinsicHeight()) }*/

        val drawable = background

        //当控件设置了点击监听器，并且控件点击有效，时，才能产生水波纹
        val rippleDrawable = RippleDrawable(
            ColorStateList.valueOf(ContextCompat.getColor(context, R.color.capture_foreground)),
            drawable, null
        )
        background = rippleDrawable
    }

    fun startAnim() {
        startAnimation(transparentAnim)
    }

    fun revertAnim() {
        animation?.cancel()
    }

    private var state: CaptureButtonState? = cameraState

    fun setState(state: CaptureButtonState?) {
        this.state = state
        requestLayout()
    }

    override fun onDraw(canvas: Canvas) {
        state?.onDraw(canvas)
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        state?.onMeasure(widthMeasureSpec, heightMeasureSpec)
    }

    /*inner class TranslateState : CaptureButtonState {

        override fun onDraw(canvas: Canvas) {
            val dx = measuredWidth / 2 - (cropButton?.intrinsicWidth ?: 0) / 2
            val dy = measuredHeight / 2 - (cropButton?.intrinsicHeight ?: 0) / 2
            canvas.translate(abs(dx).toFloat(), abs(dy).toFloat())
            cropButton?.draw(canvas)
        }

        override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
            setMeasuredDimension(
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.camera_capture), MeasureSpec.EXACTLY),
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.camera_capture), MeasureSpec.EXACTLY)
            )
        }
    }*/

    private fun cameraDraw(canvas: Canvas) {
        mPaint.color = Color.WHITE
        mPaint.alpha = mAlpha
        val circleCenter = measuredHeight / 2F
        val radius = measuredHeight / 2F * transformRate
        canvas.drawCircle(circleCenter, circleCenter, radius, mPaint)

        mPaint.color = ContextCompat.getColor(context, R.color.pickerview_bg_topbar)
        mPaint.alpha = mAlpha
        canvas.drawCircle(circleCenter, circleCenter, radius - RING_WIDTH_OUT * transformRate, mPaint)

        mPaint.color = Color.WHITE
        mPaint.alpha = mAlpha
        canvas.drawCircle(circleCenter, circleCenter, radius - RING_WIDTH_OUT * transformRate - GAP * transformRate, mPaint)
    }

    inner class CameraState : CaptureButtonState {

        override fun onDraw(canvas: Canvas) {
            cameraDraw(canvas)
        }

        override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
            setMeasuredDimension(
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.camera_capture), MeasureSpec.EXACTLY),
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.camera_capture), MeasureSpec.EXACTLY)
            )
        }
    }

    inner class ResultState : CaptureButtonState {

        override fun onDraw(canvas: Canvas) {
            cameraDraw(canvas)
        }

        override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
            setMeasuredDimension(
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.translation_result), MeasureSpec.EXACTLY),
                MeasureSpec.makeMeasureSpec(resources.getDimensionPixelSize(R.dimen.translation_result), MeasureSpec.EXACTLY)
            )
        }
    }

    inner class TransparentAnim : Animation() {
        override fun applyTransformation(interpolatedTime: Float, t: Transformation?) {
            super.applyTransformation(interpolatedTime, t)
            mAlpha = 255 - (0.5 * interpolatedTime * 255).toInt()
            transformRate = (1 - (1 - TRANSFORM_PRECENT) * interpolatedTime)
            postInvalidate()
        }

        override fun initialize(width: Int, height: Int, parentWidth: Int, parentHeight: Int) {
            super.initialize(width, height, parentWidth, parentHeight)
            duration = 50
            fillAfter = true
            interpolator = LinearInterpolator()
        }
    }
}